<?php

namespace App\Http\Controllers\ATControllers;
use App\Http\Controllers\Controller;
use App\Models\atmodels\Airtime_sending_record;
use App\Models\atmodels\Airtime_group;
use App\Models\atmodels\Currency_credit;
use EloquentBuilder;
use App\Exports\AirtimeHistory;
use App\Exports\AirtimeHistoryPDF;
use Illuminate\Http\Request;
use Auth;
use PDF;

class AirtimeSendingRecordController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //

        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');
            $query = Airtime_sending_record::where('customer_id',$customer_id);
            $groups = Airtime_group::where('customer_id',$customer_id)->get();
            $history=EloquentBuilder::to($query,request()->all())->limit(1000)->orderBy('date_sent','desc')->get();    
           
            return view('atviews.history.index', compact('wallet','history','groups','customer_id'));
        }
        else{
            return abort(401);
        }
 
    }

    //export excel
    public function exportExcel()
    {
        return new AirtimeHistory(request()->all());
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */


// Display user data in view
public function showHistory(){
    $customer_id=Auth::user()->userShopUser['customer_id'];
    $history = Airtime_sending_record::where('customer_id',$customer_id)->get();
    return view('atviews.history.pdf_view', compact('history'));
  }

  // Generate PDF
  public function createPDF() {
    // retreive all records from db
    $customer_id=Auth::user()->userShopUser['customer_id'];
    $query = Airtime_sending_record::where('customer_id',$customer_id);
    $history=EloquentBuilder::to($query,request()->all())->get();

    // share data to view
    //view()->share('history',$data);
    $shop_id=Auth::user()->shop_id;
    $customer_id=Auth::user()->userShopUser['customer_id'];
    $shopname=Auth::user()->userShopUser['customer_id'];
    $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');
    $query = Airtime_sending_record::where('customer_id',$customer_id);
    $groups = Airtime_group::where('customer_id',$customer_id)->get();
   $history=EloquentBuilder::to($query,request()->all())->get();   
    $pdf = PDF::loadView('atviews.history.pdf_view', compact('wallet','shopname','history','groups','customer_id'));


    // download PDF file with download method
    return $pdf->download('AirtimeHistory.pdf');
  }
    
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Airtime_sending_record  $airtime_sending_record
     * @return \Illuminate\Http\Response
     */
    public function show(Airtime_sending_record $airtime_sending_record)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Airtime_sending_record  $airtime_sending_record
     * @return \Illuminate\Http\Response
     */
    public function edit(Airtime_sending_record $airtime_sending_record)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Airtime_sending_record  $airtime_sending_record
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Airtime_sending_record $airtime_sending_record)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Airtime_sending_record  $airtime_sending_record
     * @return \Illuminate\Http\Response
     */
    public function destroy(Airtime_sending_record $airtime_sending_record)
    {
        //
    }
}
