@extends('layouts.admin_template')

@section('content')

<style>
.dropdown-menu a:hover{ background: #007bff;color:#fff;}
</style>
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Customers Account</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">

                                    
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Customer Account</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="{{route('admin-dashboard')}}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <a href="{{ route('users.create')}}" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add Customers Account </a>
                        </div>
                    </div>
                </div>
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
               

                                    <div class="text-right mb-3 border-bottom pb-3">
                                    <div class="card-title pull-left">Customer Account Details</div>
                                        <a href="" class="btn btn-primary btn-border btn-round btn-sm">
                                            <i class="far fa-file-excel"></i> Export Excel
                                        </a>
                                        <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panel">
                                            <i class="fas fa-filter"></i> Filter
                                        </a>
                                    </div>
                                        @if ($errors->any())
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                            <strong>Error! </strong>There were some errors with inputs.
                                            <ul>
                                                @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                            </ul>
                                            </div>

                                        @endif
                                        @include('layouts.messages')
                                        @if(!$users->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th>ID#</th>
                                                <th>Organization Name</th>
                                                <th>API Account</th>
                                                <th>Email</th>
                                                <th>Username</th>
                                                <th>Ma user_id</th>
                                                <th>Status</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>ID#</th>
                                                <th>Organization Name</th>
                                                <th>API Account</th>
                                                <th>Email</th>
                                                <th>Username</th>
                                                <th>Ma user_id</th>
                                                <th>Status</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($users as $user)
                                            <tr>
  
                                            <td>{{ $user->user_id }}</td>
                                            <td>{{ ucfirst($user->fname) }}</td>
                                            <td>{{ $user->lname }}</td>
                                            <td>{{ $user->email }}</td>

                                            <td>{{ $user->department_id }}</td>
                                            <td>{{ $user->role_id }}</td>

                                            <td>@if($user->status == 1)
                                            <span class="badge badge-success">Active</span>
                                            @elseif($user->status == 0)
                                            <span class="badge badge-danger">Inactive</span>
                                            @endif
                                            </td>
                                            <td>
                                            
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                      
                                            <a href="{{ route('users.edit',$user->user_id)}}"><button data-toggle="tooltip" data-original-title="Edit" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i>   </button></a>
                                            <form name="delete" action="{{ route('user.destroy', $user->user_id)}}" method="get">
                                                    @csrf
                                                    @METHOD('DELETE')
                                                    <button type="submit" data-toggle="tooltip" onsubmit="return confirm('Sure to Delete management accounts ?')" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"></i>
                                                    </button>
                                                    </form>
                                            </div>
                                            </td>
                                            </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
            </div>
            </div>
        </div>
    </div>
    
<script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
<script src='https://unpkg.com/popper.js@1.11.1'></script>
<script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
    @endsection
