<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>{{ config('app.name')}} </title>

    <style>
        @page {
            margin: 0px;
        }

        body {
            font-size: 12px;
            margin: 0px;
            font-family: sans-serif;
        }

        div .inline {
            color: black;
            float: left;
            line-height: 1;
            font-size: 13px;
        }

        .row {
            width: 100%;
        }

        div .row:after {
            clear: both;
            width: 100%;
        }

        .report-title {
            float: left;
            font-size: 1.3em;
            font-weight: 100;
            font-family: sans-serif;
            text-align: center;
            width: 100%;
        }

        .right {
            float: right;
        }

        .header {
            font-size: 12px;
            color: #aaa;
            line-height: 1.5;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        td {
            margin: 0;
            border: none;
            padding: 5px;
            text-align: left;
            font-size: 12px;
            border-bottom: #ddd 1px solid;
            border-right: #ddd 1px solid;
            border-top: #ddd 1px solid;
            border-left: #ddd 1px solid;
        }

        tr {
            border-bottom: #ddd 10px solid;
            width: 100%;
        }

        th {
            padding: 3px;
            background: #eee;
            border-bottom: 1px solid #eee;
            font-size: 9px;
            font-weight: bold;
            color: black;
        }

        td a {
            text-decoration: none;
            color: black;
        }

        .summary-table {
            width: 30%;
            margin-bottom: 20px;
            color: black
        }

        .summary-table tr {
            border-bottom: #eee 0.5pt solid;
            border-top: #eee 0.5pt solid
        }

        .key {
            padding: 10px;
            font-weight: bold;
            background: #eee
        }

        .value {
            padding: 10px;
            text-align: center;
        }

        .col-md-6 {
            width: 50%;
        }

        .col-md-2 {
            width: 20%;
        }
    </style>

    @yield('styles')
</head>
<body>


<div style="margin-top: 20px; width: 100%; text-align:center;">
    <h1 align="center">Monthly Transaction Statements</h1>
    <img style="width: 180px;"
         src=""     alt="Logo">
    <div style="width: 100%; clear: both;">
    </div>

</div>


<div style="width: 100%; padding: 20px">

    <l><strong>Customer: </strong></l> {{ $user->cust_name }}  <br>
    <l><strong>Phone: </strong></l> +254 {{ $user->cust_primary_contact_type }}  <br>
    <l><strong>Email: </strong></l> {{ $user->email }}  <br>
    <l><strong>Statement Period: </strong></l>{{ date('M') }}  <br>
    <l><strong>Date sent: </strong></l> {{ date('D-m-Y') }}  <br>
    <h3 align="center">Summary</h3>
 
    <table>
        <tr>
            <th>Transaction Type</th>
            <th>Wallet In</th>
            <th>Wallet Out</th>
        </tr>
        <tr>
            <td>Deposits </td>
            <td>KES. {{$creditsum}} </td>
            <td> </td>
        </tr>
        <tr>
            <td>Sent Money(Individuals) </td>
            <td></td>
            <td>KES. {{$individuals}} </td>
        </tr>
        <tr>
            <td>Paybills </td>
            <td></td>
            <td>KES. {{$paybill}} </td>
        </tr>
        <tr>
            <td>Tillnumbers </td>
            <td></td>
            <td>KES. {{$till}} </td>
        </tr>
            <td>Total </td>
            <td>KES. {{$creditsum }}</td>
            <td>KES. {{$individuals+$paybill+$till}}</td>
        </tr>
    </table>
    <h3 align="center">Detailed Statement</h3>

    <table>
        <tr>
            <th>Reference</th>
            <th>Description</th>
            <th>Wallet In</th>
            <th>Wallet Out</th> 
            <th>Charges</th>
            <th>Date</th>
        </tr>
        @foreach($trans as $trans)
        <tr>
            <td>{{ $trans->wallet_trans_ref }}</td>
            <td>{{ $trans->wallet_trans_decsription }}</td>
            <td>@if($trans->wallet_trans_charge == 0)
           Kes. {{ $trans->wallet_trans_amount }}.00
            @endif</td>
            <td>@if($trans->wallet_trans_charge != 0)
            Kes. {{ $trans->wallet_trans_amount }}.00
            @endif</td>
            <td>Kes. {{ $trans->wallet_trans_charge }}.00</td>
            <td>{{ $trans->created_at }}</td>
        </tr>
        @endforeach
    </table>
</div>

<div style="width: 100%; clear: both;">
</div>

<footer
        style="position: absolute;
    bottom: 0;
    width: 100%;
    text-align: center;
    background-color: black;
    padding: 10px;
    color:#FFF;
    line-height: 1.6;">

    <p>
        {{ config('app.name')}}
    </p>
    Disclaimer: This record is produced for your personal use and is not transferable. For more details or any queries please contact info@mobisky.biz or call +254720000334
</footer>

</body>
</html>