@php
if(Auth::user()->user_type == 'organization')
{
    $layout = 'atviews.layouts.customer';
}
elseif(Auth::user()->user_type == 'organization_user')
{
    $layout = 'atviews.layouts.user';
}
@endphp
@extends($layout)
@section('content')
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Group</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Group</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            @if(Auth::user()->user_type == 'organization_user')
                                <a href="#" data-target="#addgroup" data-toggle="modal" id="show-modal" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add Group</a>
                            @endif
                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Groups Details</div>
                                        <!-- check if exist -->
                                        @if(!$groups->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th>ID#</th>
                                                <th>Group Name</th>
                                                  <th>Contacts</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                            <tr>
                                                <th>ID#</th>
                                                <th>Group Name</th>
                                                <th>Contacts</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($groups as $group)
                                            <tr>
                                            <td>{{ $group->group_id }}</td>
                                            <td>{{ ucfirst($group->name) }}</td>
                                                  <td>@php
                                                       echo App\Http\Controllers\ATControllers\AirtimeGroupController::getGroupContactsCount($group->group_id );
                                                  @endphp
                                                  </td>
                                           
                                            <td>
                                            @if(Auth::user()->user_type == 'organization_user')
                                                <div class="form-button-action" role="group" aria-label="Actions">
                                                <a href="#" data-target="#edit-{{ $group->group_id }}" data-toggle="modal" id="show-modal"> <button class="btn btn-info btn-sm" data-toggle="tooltip"  data-original-title="Edit"><i class="far fa-edit"></i> </button>  </a>

                                                <button  @click.prevent="airtime_deleteItem('atgroupdelete',{{$group->group_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">


                                                <button  @click.prevent="deleteItem('atgroupdelete',{{$group->group_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">

                                                <button  @click.prevent="airtime_deleteItem('atgroupdelete',{{$group->group_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">

                                                            <i class="fa fa-trash-alt"></i> 
                                                </button>
                                                
                                                </form>
                                                </div>
                                            @endif
                                            </td>
                                            </tr>
                                            <!-- edit modal -->
                                            <div class="modal fade" id="edit-{{ $group->group_id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit Group </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                         <atgroupedit_component :groupdata="{{json_encode($group)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end edit modal -->
                                            <!-- view modal -->
                                            <div class="modal fade" id="view-{{ $group->group_id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit Group </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                         <groupedit_component :groupdata="{{json_encode($group)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end view modal -->
                                            @endforeach
                                            </tbody>
                                        </table>
                                       
                                        @endif
                                    </div>
                                    <!-- Create modal -->
                                    <div class="modal fade" id="addgroup" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Group </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                                    <atgroupcreate_component/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <!-- end Create modal -->
                                </div>
                            </div>
                        </div>
            </div>
            </div>
            </div>
        </div>
    </div>
    @endsection