export default {
    data() {
      return {
        fields: {},
        errors: {},
        success: false,
        loaded: true,
        action: '', //save action
        action2: '', //edit action
        action3: '', //delete
        text: '',
        redirect: '',
        client: 0,
        clients: [],
        myClient: 0,
        myClients: [],
        myGroup: 0,
        myGroups: [],
        group: 0,
        groups: [],
        batch: 0,
        batches: [],

      }
    },
  
    methods: {
      
      submit() {
        if (this.loaded) {
          this.loaded = false;
          this.success = false;
          this.errors = {};
          
         /*        swal({
                        title: 'Sending...',
                        text: 'Please wait...',
                        type: 'success',
                        buttons : {
                          confirm: {
                            className : 'btn btn-success'                 
                          }
                        }             
                      }).then(function(){
                        // window.location.href = '';
                      });*/
          
          axios.post(this.action, this.fields).then(response => {
            this.fields = {}; //Clear input fields.
            this.loaded = true;
            this.success = true;
            //sweet alert with redirect
            var mtext = this.text;
            var back = this.redirect;
            swal({
              title: 'Success',
              text: mtext,
              icon: 'success',
              type: 'success',
              buttons:{
                confirm: {
                  text : 'Go Back',
                  className : 'btn btn-success'
                },
                cancel: {
                  text: 'Add more..',
                  visible: true,
                  className: 'btn btn-info'
                }
              }
            }).then((Delete) => {
              if (Delete) {
                window.location.href = back;
              } else {
                swal.close();
              }
            });

          }).catch(error => {
            this.loaded = true;
            if (error.response.status === 422) {
              this.errors = error.response.data.errors || {};
            }
          });
        }
      },
      update() {
    
        
        if (this.loaded) {
          this.loaded = false;
          this.success = false;
          this.errors = {};
          console.log(this.fields);
          axios.post(this.action2, this.fields).then(response => {
            this.fields = {}; //Clear input fields.
            this.loaded = true;
            this.success = true;
            //console.log(response.data);
            //sweet alert with redirect
            var mtext = this.text;
            var back = this.redirect;
            swal({
              title: 'Success',
              text: mtext,
              icon: 'success',
              type: 'success',
              buttons:{
                confirm: {
                  text : 'Go Back',
                  className : 'btn btn-success'
                },
                cancel: {
                  text: 'Edit Again',
                  visible: true,
                  className: 'btn btn-info'
                }
              }
            }).then((Delete) => {
              if (Delete) {
                window.location.href = back;
              } else {
                swal.close();
              }
            });


          }).catch(error => {
           
            this.loaded = true;
            if (error.response.status === 422) {
              this.errors = error.response.data.errors || {};
             
            }
            console.log(this.errors);
          });
        }
      },
      onFileChange(e){
        console.log(e.target.files[0]);
        this.fields.file = e.target.files[0];
        },
      formSubmit(e) {
          e.preventDefault();
          let currentObj = this;
          const config = {
              headers: { 'content-type': 'multipart/form-data' }
                  }
          let formData = new FormData();
          formData.append('file', this.fields.file);
        //  formData.append('contact', this.fields.contact);
          formData.append('contact', JSON.stringify(this.fields.contact));
          
          formData.append('message', this.fields.message);
          formData.append('id', this.fields.id);
          axios.post(this.action3, formData, config)
          .then(response => {
          currentObj.success = true;
          var mtext = this.text;
            var back = this.redirect;
          swal({
              title: 'Success',
              text: mtext,
              icon: 'success',
              type: 'success',
              buttons:{
                  confirm: {
                  text : 'Go Back',
                  className : 'btn btn-success'
                  },
                  cancel: {
                  text: 'Add more..',
                  visible: true,
                  className: 'btn btn-info'
                  }
              }
              }).then((Delete) => {
              if (Delete) {
                  window.location.href = back;
              } else {
                  swal.close();
              }
              });
      })
      .catch(error => {
          if (error.response.status === 422) {
          this.errors = error.response.data.errors || {};                
              }
          
    console.log(this.errors);
          });
      },

     ///get clients and group data
     getClients: function(){
      axios.get('/getClients')
      .then(function (response) {
         this.clients = response.data;
         console.log(this.clients);
      }.bind(this));

    },
    getGroups: function() {
        axios.get('/getGroups')
        .then(function(response){
            this.groups = response.data;
        }.bind(this));
    },
    getMyClients: function() {
      axios.get('/getMyClients')
      .then(function(response){
          this.myClients = response.data;
          this.options = response.data;
      }.bind(this));
    },
    getMyGroups: function() {
      axios.get('/getMyGroups')
      .then(function(response){
          this.myGroups = response.data;
      }.bind(this));
    },
    getBatch: function() {
      axios.get('/user/getBatch')
      .then(function(response){
          this.batches = response.data;
      }.bind(this));
    },
    },
    created: function(){
      this.getClients(),this.getGroups(),this.getMyClients(),this.getMyGroups(),this.getBatch()
  }
  }