<?php

namespace App\Http\Controllers\FCControllers\Survey;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use Hash;
use DB;
use Log;
use Exception;
use App\Charts\ClosedQuizChart;
use EloquentBuilder;
use App\Models\fcmodels\Organization;
use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Wallet;
use App\Models\fcmodels\Shop;
use App\Models\fcmodels\Participant;
use App\Models\fcmodels\Incoming;
use App\Charts\FCCharts\SMSChart;
Use  App\Charts\FCCharts\NewChart;
use App\Models\fcmodels\Survey;
use App\Models\fcmodels\Question;
use App\Models\fcmodels\Response;
use App\Models\fcmodels\Option;
use App\Models\fcmodels\ApiTopup;
use App\Models\fcmodels\Language;

class MobiResponseReportController extends Controller
{
    //
    ////return survey view
    public function surveys()
    {
                 if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $surveys = Survey::where('organization_id',$id)->get();
        return view('fcviews.mobisurvey.reports_survey.surveys', compact('surveys','wallet'));
    }
    public function repo($id)
    {
             if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        $survey = Survey::findOrFail($id);
        $i=0;
        $questions = Question::where('survey_id',$id)->where('type','Closed')->get();
                // 
        //get labels and count
         $dbtable = 'participant_'.$ids.'_'.$id;
         $participantsnotparticipated = DB::select("SELECT count(*) as count FROM $dbtable where language='0' and status='0'"); 
         $participantsnotparticipated=$participantsnotparticipated[0]->count;
         $participantscompleted = DB::select("SELECT * FROM $dbtable where language !='0' and status='1'"); 
             
         $incomplete_arr=[];
         $complete_arr=[];
         foreach($participantscompleted as $participant){
             $languageid=$participant->language;
             $participantid= $participant->id;
             $question= Question::where('language_id',$languageid)->max('id');
             $responses= Response::where('participant_id',$participantid)->where('question_id',$question)->get()->toArray();
             
              if(!empty($responses)){
                 array_push($complete_arr,$responses);
              }
              else
              {
                 array_push($incomplete_arr,$responses);
              }
        }
        $complete = count($complete_arr);
        $incomplete = count($incomplete_arr); 
        
        
        
        $borderColors = [ "#30ba35", "#f25961" ];
        $fillColors = ["#fdaf4b","#59d05d" ];
        $chart1 = new SMSChart;
        // $chart1->minimalist(true);
        $chart1->labels(['Completed','Not Completed','Not Attempted']);
        //$sentsmscountSuccess=$smscountSuccess+$smscountsent;
        $chart1->dataset('Survey statistics', 'doughnut',[$complete,$incomplete,$participantsnotparticipated])
        // ->color($borderColors)
        ->backgroundcolor($fillColors);
        
        
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        return view('fcviews.mobisurvey.reports_survey.index',compact('wallet','id','survey','questions','chart1','incomplete','questions','complete','participantsnotparticipated')); 
    }
    //closed questions data
    public function getClosedQuiz($id)
    {
                if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
            $option_arr = [];
            $responsecount = [];
            //get options
            $options= Option::where('question_id',$id)->get();
            foreach($options as $option)
            {
                $theoption = $option->option;
                //get response to the question
                $responses = Response::where('question_id',$id)->where('response',$option->option)->orWhere('response','LIKE','%'.$option->response.'%')->count();
                array_push($responsecount,$responses);
                array_push($option_arr, $theoption);
            }
            // $responsecount1 = implode(",",$responsecount);
            // $option_arr1 = implode(",",$option_arr);
        $array = ['options'=>$option_arr, 'responses'=> $responsecount];
        return $array;
    }
}
