<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
use Session;
use App\Models\bmmodels\Customer;
use App\Models\bmmodels\CustomerUser;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    public function logout()
    {
        //reset otp
        //check if user has mpesa
        if(Auth::user()->bulk_cust_id != NULL)
        {
            if(Auth::user()->user_type == 'organization')
            {
                 Customer::where('cust_id',Auth::user()->bulk_cust_id)->update(['cust_otp_status' => '0']);
            }
            else if(Auth::user()->user_type == 'organization_user')
            {
                CustomerUser::where('cust_user_id',Auth::user()->cust_user_id)->update(['cust_otp_status' => '0']);
            }
        }

        Auth::logout();
        Session::flush();

        return redirect('/login');
    }
}
