<?php

namespace App\Http\Controllers\ATControllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\atmodels\Airtime_group;
use App\Models\atmodels\Airtime_sending_credential;
use App\Models\atmodels\Currency_expenditure;
use App\Models\atmodels\Airtime_contact;
use App\Models\atmodels\Airtime_customer;
use App\Models\bmmodels\CustomerClient;
use App\Models\fcmodels\Contact;
use App\Models\atmodels\SmsApiUser;
use App\Models\atmodels\Currency_credit;
use Auth;
use Log;
use Exception;
use App\Libs\MobiskyAirtime;

class AirtimeTopupController extends Controller
{
    //return topup group view
    public function group()
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $groups = Airtime_group::where('customer_id',$customer_id)->get();
            $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');
            return view('atviews.topup.group', compact('groups','wallet'));
        }
    }
    
    //return topup contact view
    public function contact()
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
      
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $shop_id=Auth::user()->shop_id;            
            $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount'); 

            $contactsAirtime = Airtime_contact::where('customer_id',$customer_id)->with('contactGroup')->get();
               $c=array();
            ////////////////////////////////added/////////////////////////
            
             $shop_id=Auth::user()->shop_id;
             $customer_id=Auth::user()->userShopUser['customer_id'];
             $contacts1 = Airtime_contact::where('customer_id',$customer_id)->get()->toArray();
             
               foreach($contacts1 as $d){
                    $e['contact']="+254".substr($d['contact'],-9);
                    $e['fname']=$d['fname'];
                    $e['contact_id']=$d['contact_id'];
                    array_push($c,$e);
                
                }
            if(Auth::user()->cust_id){
             
                 $fcuser_id = Auth::user()->organization_id;
                 $contacts2=Contact::where('organization_id',$fcuser_id)->get(['phone AS contact','name AS fname','contact_id'])->toArray();
       
                foreach($contacts2 as $a){
                    $b['contact']="+254".substr($a['contact'],-9);
                    $b['fname']=$a['fname'];
                    $b['contact_id']=$a['contact_id'];
                    array_push($c,$b);
                
                }
            }
            
            if(Auth::user()->bulk_cust_id){
                $id=Auth::user()->bulk_cust_id;
                $data = CustomerClient::where('customer_cust_id',$id)->where('cust_client_status',1)->get(['cust_client_phone AS contact','cust_client_fullname AS fname','cust_client_id AS contact_id'])->toArray();
               
                foreach($data as $a){
                    $mdata['contact']="+254".$a['contact'];
                    $mdata['fname']=$a['fname'];
                    $mdata['contact_id']=$a['contact_id'];
                    array_push($c,$mdata);
                
                }
            }
            
           $contacts=$c;
            
            $groups = Airtime_group::where('customer_id',$customer_id)->get();
            return view('atviews.topup.contact', compact('contacts','groups','wallet','contactsAirtime'));
        }
    }
    //topup group
    public function topupGroup(Request $request)
    {
        
        //
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
             $request->validate([
            'group_id'=>'required',
            'amount'=>'required|integer|min:5',
        ],
        [
            'group_id.required'=>'Please select group',
            'amount.required'=>'Please enter amount',
            'amount.integer'=>'Please enter a whole number',
            'amount.integer'=>'Please enter amount not less than 5',
        ]);
        $credentials = Airtime_sending_credential::where('customer_id',$customer_id)->first();
        $username = $credentials['username'];
        $password = $credentials['password'];
        $amount=$request->amount;
        //get the airtime_customer
        $user_sms_api = SmsApiUser::where('shop_id',$shop_id)->pluck('username');
        $pass_sms_api = SmsApiUser::where('shop_id',$shop_id)->pluck('password');

        $apiuser = Airtime_customer::where('customer_id',$customer_id)->pluck('username');
        //get contacts
        $group_id = $request->group_id['group_id'];
        $contacts_customer_id= Airtime_contact::where('customer_id',$customer_id)->pluck('contact','group_id');
         
        $contacts = Airtime_contact::where('group_id',$group_id)->pluck('contact');
        //call the function that returns the contacts for this group
        $converted_c=$contacts_customer_id->toArray()  ;
        
        $contacts_array=[];
        
        foreach($converted_c as $index=>$a){
       
         //get an array
         $n=explode(',',str_replace(']','',str_replace('[','',strtok("$index = $a",'='))));
         
         //check existence in array and return contactid;
         if(in_array($group_id,$n)){
             array_push($contacts_array,$a);
         }
         
        }
        
      
        foreach($contacts_array as $contact)
        {
            //send airtime
            //get the variables
            //$username,$password,$amount,$recipient,$apiuser
            $send = new MobiskyAirtime($user_sms_api[0],$pass_sms_api[0],$amount,$contact,$customer_id);
            $sending = $send->sendAirtime();
            //if sent, save to db
            if($sending == 'Sent')
            {
              //save the log
              Log::info("Airtime Sent")  ;
            }
            else{
                  Log::info("Airtime Failed")  ;
            }
           // Log::info($contact);
        }
        return 'success';
        
    }
}
    
    //get contacts for a group
    public function getGroupeContacts($group_id){
        
        //get the contacts with this group id
       $contacts = Airtime_contact::select('group_id', 'contact')->get();
       $groupes=$contacts->toArray();
      
       foreach($groupes as $grp){
         $group_ee=$grp['group_id'];
         $replace1=str_replace('[','',$group_ee);
         $replace2=str_replace(']','',$replace1);
         //convert into array
         $new_grp=explode(",",$replace2);
         $count1=AirtimeGroupController::count_array_values($new_grp, $idtofind);
         $count+=$count1;
         array_push($array1,$new_grp);
       }
       return $count; 
    
    }
    //topup contact
    public function topupContact(Request $request)
    {
        //
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $request->validate([
            'contact'=>'required',
            'amount'=>'required|integer|min:5',
        ],
        [
            'contact.required'=>'Please select contact',
            'amount.required'=>'Please enter amount',
            'amount.integer'=>'Please enter a whole number',
            'amount.min'=>'Please enter amount not less than 5',
        ]);
        //get credentials
        $credentials = Airtime_sending_credential::where('customer_id',$customer_id)->first();
        $username = $credentials['username'];
        $password = $credentials['password'];

        $amount=$request->amount;
        //get the airtime_customer
        $user_sms_api = SmsApiUser::where('shop_id',$shop_id)->pluck('username');
        $pass_sms_api = SmsApiUser::where('shop_id',$shop_id)->pluck('password');

        $apiuser = Airtime_customer::where('customer_id',$customer_id)->pluck('username');

        //get contacts
        $contacts = $request->contact;
        foreach($contacts as $contact)
        {
            //send airtime
            $send = new MobiskyAirtime($user_sms_api[0],$pass_sms_api[0],$amount,$contact['contact'],$customer_id);
            $sending = $send->sendAirtime();
            //log
        }
        return 'success';
    }
    //topup all contacts
    public function topupMyContacts(Request $request)
    {
        //
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $request->validate([
            'amount'=>'required|integer|min:5',
        ],
        [
            'amount.required'=>'Please enter amount',
            'amount.integer'=>'Please enter a whole number',
            'amount.min'=>'Please enter amount not less than 5',
        ]);
        // get credentials
        $credentials = Airtime_sending_credential::where('customer_id',$customer_id)->first();
        $username = $credentials['username'];
        $password = $credentials['password'];

        $amount=$request->amount;
        //get the airtime_customer
        $user_sms_api = SmsApiUser::where('shop_id',$shop_id)->pluck('username');
        $pass_sms_api = SmsApiUser::where('shop_id',$shop_id)->pluck('password');

        $apiuser = Airtime_customer::where('customer_id',$customer_id)->pluck('username');
        //get contacts
        $contacts = Airtime_contact::where('customer_id',$customer_id)->pluck('contact');
        
        Log::info("");

        foreach($contacts as $contact)
        {
            //send airtime
            $send = new MobiskyAirtime($user_sms_api[0],$pass_sms_api[0],$amount,$contact,$customer_id);
            $sending = $send->sendAirtime();

            Log::info($sending);
            
        }
        return 'success';
    }

   //return topupMyLine contact view
   public function contacttopupMyLine()
   {
       if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
       {
           $customer_id=Auth::user()->userShopUser['customer_id'];
           $shop_id=Auth::user()->shop_id;            
            $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount'); 
           $contacts = Airtime_contact::where('customer_id',$customer_id)->with('contactGroup')->get();
           $myline = Airtime_customer::where('customer_id',$customer_id)->get();

        
             return view('atviews.topup.myline', compact('contacts','myline','wallet'));
       }
   }
   //Topup Mycontact
   public function topupMyLine(Request $request)
   {
       //
       if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
       {
           $shop_id=Auth::user()->shop_id;
           $customer_id=Auth::user()->userShopUser['customer_id'];
       }
       else{
           return abort(401);
       }
       $request->validate([
           'phone'=>'required',
           'amount'=>'required|integer|min:5',
       ],
       [
           'phone.required'=>'Please select contact',
           'amount.required'=>'Please enter amount',
           'amount.integer'=>'Please enter a whole number',
           'amount.min'=>'Please enter amount not less than 5',
       ]);
       //get credentials
        $credentials = Airtime_sending_credential::where('customer_id',$customer_id)->first();
       $username = $credentials['username'];
       $password = $credentials['password'];

       $amount=$request->amount;
       //get the airtime_customer
       $user_sms_api = SmsApiUser::where('shop_id',$shop_id)->pluck('username');
       $pass_sms_api = SmsApiUser::where('shop_id',$shop_id)->pluck('password');

       $apiuser = Airtime_customer::where('customer_id',$customer_id)->pluck('username');
       //get contacts
       //get contacts
       $contacts = $request->phone;
      
          // return $contact;
           //send airtime
           $send = new MobiskyAirtime($user_sms_api[0],$pass_sms_api[0],$amount,$contacts,$customer_id);
           $sending = $send->sendAirtime();
           //if sent, save to db
           
           if($sending == 'Sent')
           {
               
           }
 
       return 'success';
   }


}