<?php

namespace App\Exports;
use EloquentBuilder;
use Maatwebsite\Excel\Excel;
use Illuminate\Contracts\Support\Responsable;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use App\Models\fcmodels\contact;
use App\Models\CustomerClientPayment;
use Maatwebsite\Excel\Concerns\FromCollection;
use Auth;
class ContactExport implements Responsable, FromCollection, WithHeadings, WithMapping
{
    use Exportable;
    protected $request;

    /**
    * It's required to define the fileName within
    * the export class when making use of Responsable.
    */
    private $fileName = 'customers.xlsx';

    /**
    * Optional Writer Type
    */
    private $writerType = Excel::XLSX;

    /**
    * Optional headers
    */
    private $headers = [
        'Content-Type' => 'text/csv',
    ];

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Contact Name',
            'Phone',
            'Group',
        ];
    }

    public function map($contacts): array
    {
        
        
      if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
            
        }
        else{
            return abort('401');
        }
        
        
  $contact = Contact::where('organization_id',$id)->get();
    return [
            $contacts->contact_id,
            $contacts->name,
            $contacts->phone,
    
            isset($contacts->contactGroup) ? $contacts->contactGroup->group_name : '',
        ];
    }

   public function collection()
    {
       if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
            
        }
        else{
            return abort('401');
        }
        // return Customer::all();
        $query = Contact::where('organization_id',$id)->get();
      //  $history = EloquentBuilder::to($query, request()->all())->get();
        return $query;
    }


}
