<?php

namespace Bryceandy\Laravel_Pesapal\OAuth;

use Exception;

class OAuthSignatureMethod_RSA_SHA1 extends OAuthSignatureMethod
{
    public function get_name()
    {
        return "RSA-SHA1";
    }

    /**
     * @param $request
     * @throws Exception
     */
    protected function fetch_public_cert(&$request)
    {
        // not implemented yet, ideas are:
        // (1) do a lookup in a table of trusted certs keyed off of consumer
        // (2) fetch via http using a url provided by the requester
        // (3) some sort of specific discovery code based on request
        //
        // either way should return a string representation of the certificate
        throw new Exception("fetch_public_cert not implemented");
    }

    /**
     * @param $request
     * @throws Exception
     */
    protected function fetch_private_cert(&$request)
    {
        // not implemented yet, ideas are:
        // (1) do a lookup in a table of trusted certs keyed off of consumer
        //
        // either way should return a string representation of the certificate
        throw new Exception("fetch_private_cert not implemented");
    }

    /**
     * @param $request
     * @param $consumer
     * @param $token
     * @return string
     * @throws Exception
     */
    public function build_signature(&$request, $consumer, $token)
    {
        $base_string = $request->get_signature_base_string();
        $request->base_string = $base_string;

        // Fetch the private key cert based on the request
        $cert = $this->fetch_private_cert($request);

        // Pull the private key ID from the certificate
        $privatekeyid = openssl_get_privatekey($cert);

        // Sign using the key
        $ok = openssl_sign($base_string, $signature, $privatekeyid);

        // Release the key resource
        openssl_free_key($privatekeyid);

        return base64_encode($signature);
    }

    /**
     * @param $request
     * @param $consumer
     * @param $token
     * @param $signature
     * @return bool
     * @throws Exception
     */
    public function check_signature(&$request, $consumer, $token, $signature)
    {
        $decoded_sig = base64_decode($signature);

        $base_string = $request->get_signature_base_string();

        // Fetch the public key cert based on the request
        $cert = $this->fetch_public_cert($request);

        // Pull the public key ID from the certificate
        $publickeyid = openssl_get_publickey($cert);

        // Check the computed signature against the one passed in the query
        $ok = openssl_verify($base_string, $decoded_sig, $publickeyid);

        // Release the key resource
        openssl_free_key($publickeyid);

        return $ok == 1;
    }
}
