<?php $__env->startSection('content'); ?>
    <div id="hero-area">
        <div class="overlay"></div>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12 col-lg-9 col-xs-12 text-center">
                    <div class="contents">
                        <h1 class="head-title"><span class="m-red">Best</span> <span class="m-green">Beehive</span> <span class="m-blue">Based</span> <span class="m-purple">Businesses</span></h1>
                        <p class="text-dark">Buy .. Sell .. Let .. Rent .. Hire .. Book</p>
                        <div class="search-bar">
                            <div class="search-inner">
                                <form class="search-form">
                                    <div class="form-group">
                                        <input type="text" name="customword" class="form-control"
                                            placeholder="What are you looking for?">
                                    </div>
                                    <div class="form-group inputwithicon">
                                        <div class="select">
                                            <select>
                                                <option value="" selected disabled>Locations</option>
                                                <?php $__currentLoopData = $counties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $county): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($county->name); ?>"><?php echo e($county->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </select>
                                        </div>
                                        
                                    </div>
                                    <div class="form-group inputwithicon">
                                        <div class="select">
                                            <select>
                                                <option value="" selected disabled>Select Category</option>
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </select>
                                        </div>
                                        
                                    </div>
                                    <button class="btn btn-common" type="button"></i> Search
                                        Now
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <section id="categories">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10 col-md-12 col-xs-12">
                    <div id="categories-icon-slider" class="categories-wrapper owl-carousel owl-theme">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="item">
                                <a href="<?php echo e(route('categoryListings', $category->id)); ?>">
                                    <div class="category-icon-item">
                                        <div class="icon-box">
                                            <div class="icon no-display ">
                                                
                                                <span><i class="<?php echo e($category->icon_name); ?>"></i></span>
                                            </div>
                                            <h4><?php echo e($category->name); ?></h4>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="featured section-padding">
        <div class="container">
            <h1 class="section-title">Latest Adverts</h1>
            <div class="row">
                <?php echo $__env->make('includes.list_item', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </section>


    <section class="featured-lis section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-12 wow fadeIn" data-wow-delay="0.5s">
                    <h3 class="section-title">Featured Adverts</h3>
                    <div id="new-products" class="owl-carousel owl-theme">
                        <?php $__currentLoopData = $featured_ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <div class="item">
                                <div class="product-item">
                                    <div class="carousel-thumb">
                                        <img class="img-fluid"
                                            src="<?php echo e(url('/openGateAds') .
                                                     '/' .
                                                     $ad->photos->where('type', 'main_image')->pluck('image_path')->first()); ?>"
                                            alt="ad photo">
                                        <div class="overlay">
                                            <div>
                                                <a class="btn btn-common" href="#">View Details</a>
                                            </div>
                                        </div>
                                        <div class="btn-product bg-sale">
                                            <a>Featured</a>
                                        </div>
                                        <span class="price">Ksh <?php echo e(number_format($ad->price, 0)); ?></span>
                                    </div>
                                    <div class="product-content">
                                        <h3 class="product-title"><a href="#"><?php echo e($ad->title); ?></a></h3>
                                        <a
                                            href="<?php echo e(route('categoryListings', $ad->category->id)); ?>"><span><?php echo e($ad->category->name); ?></span></a>
                                        <?php if(Auth::check()): ?>
                                            <?php if($user->hasFavorited($ad)): ?>
                                                <div class="icon no-display favorite" data-id="<?php echo e($ad->id); ?>">
                                                    <span><i class="lni-heart"></i></span>
                                                </div>
                                            <?php else: ?>
                                                <div class="icon no-display not-favorite" data-id="<?php echo e($ad->id); ?>">
                                                    <span><i class="lni-heart"></i></span>
                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <div class="icon no-display require-login">
                                                <span><i class="lni-heart"></i></span>
                                            </div>
                                        <?php endif; ?>
                                        <div class="card-text">
                                            <div class="float-left">
                                                <span class="icon-wrap">
                                                    <i class="lni-star-filled"></i>
                                                    <i class="lni-star-filled"></i>
                                                    <i class="lni-star-filled"></i>
                                                    <i class="lni-star-filled"></i>
                                                    <i class="lni-star-filled"></i>
                                                    <i class="lni-star"></i>
                                                </span>
                                                <span class="count-review">
                                                    (12 Review)
                                                </span>
                                            </div>
                                            <div class="float-right">
                                                <a class="address" href="<?php echo e(route('locationListings', $ad->county)); ?>"> - <?php echo e($ad->county); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="works section-padding">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h3 class="section-title">How It Works?</h3>
                </div>
                <div class="col-lg-4 col-md-4 col-xs-12">
                    <div class="works-item">
                        <div class="icon-box my-number">
                            <img src="<?php echo e(asset('assets/img/one.png')); ?>" alt="Step 1">
                        </div>
                        <p>Create an Account</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-xs-12">
                    <div class="works-item">
                        <div class="icon-box my-number">
                            <img src="<?php echo e(asset('assets/img/two.png')); ?>" alt="Step 2">
                        </div>
                        <p>Post Free Ad</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-xs-12">
                    <div class="works-item">
                        <div class="icon-box my-number">
                            <img src="<?php echo e(asset('assets/img/three.png')); ?>" alt="Step 3">
                        </div>
                        <p>Deal Done</p>
                    </div>
                </div>
                <hr class="works-line">
            </div>
        </div>
    </section>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\OpenGateAd\resources\views/pages/index.blade.php ENDPATH**/ ?>