@extends('layouts.site')

@section('title')
BTCotton | Organisation - {{ $trader->organisation_name }}
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Organisation - {{ $trader->organisation_name}}</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Organisations</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-trader" href="{{ route('traders.edit', $trader->id) }}" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Edit Organisation
        </a>

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                {{-- Profile Tab --}}
                                <li class="nav-item">
                                    <a class="nav-link active" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="true"><i class="far fa-building"></i> Profile</a>
                                </li>

                                {{-- Members Tab --}}
                                @if($trader->isFarmerOrganisation())
                                    <li class="nav-item">
                                        <a class="nav-link" id="members-tab" data-toggle="tab" href="#members" role="tab" aria-controls="members" aria-selected="false"><i class="far fa-address-card"></i>  Members</a>
                                    </li>
                                @endif

                                {{-- Contacts Tab --}}
                                <li class="nav-item">
                                    <a class="nav-link" id="contacts-tab" data-toggle="tab" href="#contacts" role="tab" aria-controls="contacts" aria-selected="false"><i class="fas fa-users"></i> Contact Persons</a>
                                </li>

                                {{-- Produce Items Tab --}}
                                @if($trader->isFarmerOrganisation())
                                    <li class="nav-item">
                                        <a class="nav-link" id="produce-items-tab" data-toggle="tab" href="#produce-items" role="tab" aria-controls="contacts" aria-selected="false"><i class="fas fa-seedling"></i> Produce Items</a>
                                    </li>
                                @endif

                                {{-- Contracts Tab --}}
                                @if($trader->isBulkBuyer())
                                    <li class="nav-item">
                                        <a class="nav-link" id="contracts-tab" data-toggle="tab" href="#contracts" role="tab" aria-controls="contracts" aria-selected="false"><i class="far fa-folder-open"></i> Contracts</a>
                                    </li>
                                @endif

                                {{-- Input Items Tab --}}
                                @if($trader->isBulkSeller())
                                    <li class="nav-item">
                                        <a class="nav-link" id="input-items-tab" data-toggle="tab" href="#input-items" role="tab" aria-controls="input-items" aria-selected="false"><i class="fas fa-reply-all"></i> Input Items</a>
                                    </li>
                                @endif

                                {{-- Networks Tab --}}
                                @if($trader->isBulkSeller())
                                    <li class="nav-item">
                                        <a class="nav-link" id="networks-tab" data-toggle="tab" href="#networks" role="tab" aria-controls="networks" aria-selected="false"><i class="fas fa-sitemap"></i> Networks</a>
                                    </li>
                                @endif
                            </ul>
                            <div class="tab-content" id="myTabContent">
                                {{-- Profile Panel --}}
                                <div id="profile" role="tabpanel" aria-labelledby="profile-tab" class="tab-pane fade show active">
                                    <div class="alert alert-info shadow-sm">
                                        <dl class="row">
                                            <dt class="col-md-3">Organisation</dt>
                                            <dd class="col-md-9">{{ $trader->organisation_name }} ({{ $trader->trader_type->name }})</dd>
                                            <dt class="col-md-3">Phone</dt>
                                            <dd class="col-md-9">{{ $trader->phone }}</dd>
                                            <dt class="col-md-3">Email</dt>
                                            <dd class="col-md-9">{{ $trader->email }}</dd>
                                            <dt class="col-md-3">Postal Address</dt>
                                            <dd class="col-md-9">{{ $trader->postal_address }}</dd>
                                            <dt class="col-md-3">Physical Address</dt>
                                            <dd class="col-md-9">{{ $trader->physical_address }}</dd>
                                            <dt class="col-md-3">County</dt>
                                            <dd class="col-md-9">{{ $trader->county }}</dd>
                                            <dt class="col-md-3">Ward</dt>
                                            <dd class="col-md-9">{{ $trader->ward }}</dd>
                                            <dt class="col-md-3">Preferred Regions</dt>
                                            <dd class="col-md-9">{{ $trader->preferred_regions }}</dd>
                                        </dl>
                                    </div>
                                </div>

                                {{-- Members Panel --}}
                                @if($trader->isFarmerOrganisation())
                                    <div id="members" role="tabpanel" aria-labelledby="members-tab" class="tab-pane fade">
                                        <div class="text-right mb-3">
                                            <a id="create-trader-member" href="#" class="btn btn-primary btn-round btn-sm">Add a Member</a>
                                            <hr>
                                        </div>
                                        @if($trader_members->count())
                                            @include('trader-members._index')

                                        @else
                                            @include('layouts._nodata')
                                        @endif

                                    </div>
                                @endif

                                {{-- Contacts Panel --}}
                                <div id="contacts" role="tabpanel" aria-labelledby="contacts-tab" class="tab-pane fade">
                                    <div class="panel panel-default">
                                        <div class="text-right mb-3">
                                            <a id="create-trader-contact" href="#" class="btn btn-primary btn-round btn-sm">Add a Contact Person</a>
                                            <hr>
                                        </div>
                                        @if($trader_contacts->count())
                                            @include('trader-contacts._index')

                                        @else
                                            @include('layouts._nodata')
                                        @endif
                                    </div>
                                </div>

                                {{-- Produce Items Panel --}}
                                @if($trader->isFarmerOrganisation())
                                    <div id="produce-items" role="tabpanel" aria-labelledby="produce-items-tab" class="tab-pane fade">
                                        @if(Auth::user()->isAdmin())
                                            <div class="text-right mb-3">
                                                <a id="create-produce-item" href="#" class="btn btn-primary btn-round btn-sm">Add a Produce Item</a>
                                                <hr>
                                            </div>
                                        @endif

                                        @if($produce_items->count())
                                            @include('produce-items._index')

                                        @else
                                            @include('layouts._nodata')
                                        @endif

                                    </div>
                                @endif

                                {{-- Contracts Panel --}}
                                @if($trader->isBulkBuyer())
                                    <div id="contracts" role="tabpanel" aria-labelledby="contracts-tab" class="tab-pane fade">
                                        <div class="panel panel-default">
                                            @if(Auth::user()->isAdmin())
                                                <div class="text-right mb-3">
                                                    <a id="create-trader-contract" href="#" class="btn btn-primary btn-round btn-sm">Add a Contract</a>
                                                    <hr>
                                                </div>
                                            @endif

                                            @if($trader_contracts->count())
                                                @include('trader-contracts._index')

                                            @else
                                                @include('layouts._nodata')
                                            @endif
                                        </div>
                                    </div>
                                @endif

                                {{-- Input Items Panel --}}
                                @if($trader->isBulkSeller())
                                    <div id="input-items" role="tabpanel" aria-labelledby="input-items-tab" class="tab-pane fade">
                                        @if(Auth::user()->isAdmin())
                                            <div class="text-right mb-3">
                                                <a id="create-input-item" href="#" class="btn btn-primary btn-round btn-sm">Add an Input Item</a>
                                                <hr>
                                            </div>
                                        @endif

                                        @if($input_items->count())
                                            @include('input-items._index')

                                        @else
                                            @include('layouts._nodata')
                                        @endif

                                    </div>
                                @endif

                                {{-- Networks Panel --}}
                                @if($trader->isBulkSeller())
                                    <div id="networks" role="tabpanel" aria-labelledby="networks-tab" class="tab-pane fade">
                                        <div class="panel panel-default">
                                            @if(Auth::user()->isAdmin())
                                                <div class="text-right mb-3">
                                                    <a id="create-trader-network" href="#" class="btn btn-primary btn-round btn-sm">Link an Agrodealer</a>
                                                    <hr>
                                                </div>
                                            @endif

                                            @if($trader_contracts->count())
                                                @include('trader-networks._index')

                                            @else
                                                @include('layouts._nodata')
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Trader Member Modal -->
    @if($trader->isFarmerOrganisation())
        <div class="modal fade" id="trader-members-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="trader-member-modal-title" id="trader-member-modal-title"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="trader-member-form" name="trader-member-form" method="post">
                        @csrf
                        <div class="modal-body">
                            <input type="hidden" name="id" id="trader-member-id">
                            <input type="hidden" name="trader_id" id="trader-member-trader-id" value="{{ $trader->id }}">
                            <input type="hidden" name="user_id" id="trader-member-user-id">
                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                            {{-- <fieldset class="mb-2">
                                <div class="form-group">
                                    <label for="trader-member-user-id">Select User</label>
                                    <input type="hidden" id="trader-member-user-id-hidden" disabled="disabled">
                                    <select id="trader-member-user-id" name="user_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                        <option value="">- Select -</option>
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->fullname }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </fieldset> --}}

                            <div class="form-row">
                                <div class="col form-group">
                                    <label for="trader-member-firstname">First Name*</label>
                                    <input name="firstname" id="trader-member-firstname" type="text" class="form-control {{ $errors->has('firstname') ? 'is-invalid' : '' }}" placeholder="First Name">

                                    @if ($errors->has('firstname'))
                                        <div class="invalid-feedback">
                                            <strong>{{ $errors->first('firstname') }}</strong>
                                        </div>
                                    @endif
                                </div> <!-- form-group end.// -->
                                <div class="col form-group">
                                    <label for="trader-member-lastname">Last Name*</label>
                                    <input name="lastname" id="trader-member-lastname" type="text" class="form-control {{ $errors->has('lastname') ? 'is-invalid' : '' }}" placeholder="Last Name">

                                    @if ($errors->has('lastname'))
                                        <div class="invalid-feedback">
                                            <strong>{{ $errors->first('lastname') }}</strong>
                                        </div>
                                    @endif
                                </div> <!-- form-group end.// -->
                            </div>
                            <div class="form-row">
                                <div class="col form-group">
                                    <label for="trader-member-email">Email*</label>
                                    <input name="email" id="trader-member-email" type="text" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" placeholder="Email">

                                    @if ($errors->has('email'))
                                        <div class="invalid-feedback">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </div>
                                    @endif
                                </div> <!-- form-group end.// -->

                                <div class="col form-group">
                                    <label for="trader-member-phone">Phone Number*</label>
                                    <input name="phone" id="trader-member-phone" type="text" class="form-control {{ $errors->has('phone') ? 'is-invalid' : '' }}" placeholder="Phone Number">

                                    @if ($errors->has('phone'))
                                        <div class="invalid-feedback">
                                            <strong>{{ $errors->first('phone') }}</strong>
                                        </div>
                                    @endif
                                </div> <!-- form-group end.// -->
                            </div>
                            <div class="form-group">
                                <label for="trader-member-active">Active?</label>
                                <select name="active" id="trader-member-active" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <option value="1">Yes</option>
                                    <option value="0">No</option>
                                </select>
                            </div> <!-- form-group end.// -->
                            <hr>
                            <fieldset>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-member-username">Username*</label>
                                        <input name="username" id="trader-member-username" type="text" class="form-control {{ $errors->has('username') ? 'is-invalid' : '' }}" placeholder="Username">

                                        @if ($errors->has('username'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('username') }}</strong>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-member-password">Password*</label>
                                        <input name="password" id="trader-member-password" type="password" class="form-control {{ $errors->has('password') ? 'is-invalid' : '' }}" placeholder="Password">

                                        @if ($errors->has('password'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('password') }}</strong>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col form-group">
                                        <label for="trader-member-confirm-password">Confirm Password*</label>
                                        <input name="confirm_password" id="trader-member-confirm-password" type="password" class="form-control {{ $errors->has('confirm_password') ? 'is-invalid' : '' }}"  placeholder="Confirm Password">

                                        @if ($errors->has('confirm_password'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('confirm_password') }}</strong>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="trader-member-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif

    <!-- Trader Contact Modal -->
    <div class="modal fade" id="trader-contacts-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="trader-contact-modal-title" id="trader-contact-modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="trader-contact-form" name="trader-contact-form" method="post">
                    @csrf
                    <div class="modal-body">
                        @if($trader->isFarmerOrganisation())
                            <fieldset>
                                <div class="form-group">
                                    <label for="trader-contact-user-id">Select a Member</label>
                                    {{-- <input type="hidden" id="trader-contact-user-id-hidden" disabled="disabled"> --}}
                                    <select id="trader-contact-user-id" name="user_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                        <option value="">- Select -</option>
                                        @foreach($trader_members as $member)
                                            <option value="{{ $member->user_id }}">{{ $member->user->fullname }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </fieldset>
                        @endif

                        <div class="form-row">
                            <input type="hidden" name="id" id="trader-contact-id">
                            <input type="hidden" name="trader_id" id="trader-contact-trader-id" value="{{ $trader->id }}">
                            {{-- <input type="hidden" name="is_admin" id="trader-contact-is-admin" value="0"> --}}
                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                            <div class="col form-group">
                                <label for="trader-contact-firstname">First Name*</label>
                                <input name="firstname" id="trader-contact-firstname" type="text" class="form-control" placeholder="First Name">
                            </div> <!-- form-group end.// -->
                            <div class="col form-group">
                                <label for="trader-contact-lastname">Last Name*</label>
                                <input name="lastname" id="trader-contact-lastname" type="text" class="form-control" placeholder="Last Name">
                            </div> <!-- form-group end.// -->
                        </div>
                        <div class="form-row">
                            <div class="col form-group">
                                <label for="trader-contact-email">Email*</label>
                                <input name="email" id="trader-contact-email" type="email" class="form-control" placeholder="Email">
                            </div> <!-- form-group end.// -->
                            <div class="col form-group">
                                <label for="trader-contact-phone">Phone*</label>
                                <input name="phone" id="trader-contact-phone" type="text" class="form-control" placeholder="Phone">
                            </div> <!-- form-group end.// -->
                        </div>
                        <hr>
                        <div class="form-group">
                            <label for="trader-contact-is-admin">Is Primary Contact?</label>
                            <select name="is_admin" id="trader-contact-is-admin" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div> <!-- form-group end.// -->
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="trader-contact-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Produce Item Modal -->
    @if($trader->isFarmerOrganisation())
        <div class="modal fade" id="produce-items-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="produce-item-modal-title" id="produce-item-modal-title"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="produce-item-form" name="produce-item-form" method="post">
                        @csrf
                        <div class="modal-body">
                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                            <input type="hidden" name="id" id="produce-item-id">
                            <input type="hidden" name="trader_id" id="produce-item-trader-id" value="{{ $trader->id }}">
                            <div class="form-group">
                                <label for="produce-item-produce-id">Produce</label>
                                <select id="produce-item-produce-id" name="produce_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    @foreach($produces as $produce)
                                        <option value="{{ $produce->id }}">{{ $produce->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="produce-item-produce-unit-id">Produce Unit</label>
                                <select id="produce-item-produce-unit-id" name="produce_unit_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    @foreach($produce_units as $produce_unit)
                                        <option value="{{ $produce_unit->id }}">{{ $produce_unit->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="produce-item-quality">Quality</label>
                                <input type="text" name="quality" id="produce-item-quality" value="" class="form-control" placeholder="Quality">
                            </div>
                            <div class="row">
                            <div class="form-group col-md-6">
                                <label for="produce-item-price-per-unit">Price per Unit</label>
                                <input type="text" name="price_per_unit" id="produce-item-price-per-unit" value="" class="form-control" placeholder="Price per unit">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="produce-item-tonnage">Tonnage (in Kgs)</label>
                                <input type="text" name="tonnage" id="produce-item-tonnage" value="" class="form-control" placeholder="Tonnage (in Kgs)">
                            </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="produce-item-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif

    <!-- Trader Contract Modal -->
    @if($trader->isBulkBuyer())
        <div class="modal fade" id="trader-contracts-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="trader-contract-modal-title" id="trader-contract-modal-title">Add Contract - {{ $trader->organisation_name }}</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="trader-contract-form" name="trader-contract-form" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                            <input type="hidden" name="id" id="trader-contract-id">
                            <input type="hidden" name="trader_id" id="trader-contract-trader-id" value="{{ $trader->id }}">
                            <input type="hidden" name="old_contract_file" id="trader-contract-old-file">
                            {{-- <div class="form-group">
                                <label for="trader-contract-user-id">Name</label>
                                <input type="hidden" id="trader-contract-user-id-hidden" disabled="disabled">
                                <input type="text" name="name" id="trader-contract-name" class="form-control">
                            </div> --}}
                            <div class="form-group">
                                <label for="trader-contract-name">Name</label>
                                <input type="text" name="name" id="trader-contract-name" value="" class="form-control" placeholder="Contract Name">
                            </div>
                            <div class="form-group">
                                <label for="trader-contract-file">Contract Document</label>
                                <input type="file" name="contract_file" id="trader-contract-file" class="form-control">
                            </div>
                            <hr>
                            <fieldset>
                                <legend>Contract Details</legend>
                                <div class="form-group row">
                                    <div class="col-md-6">
                                        <label for="trader-contract-produce-id">Produce</label>
                                        <select id="trader-contract-produce-id" name="produce_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            @foreach($produces as $produce)
                                                <option value="{{ $produce->id }}">{{ $produce->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="trader-contract-tonnage">Tonnage (in Kgs)</label>
                                        <input type="text" name="tonnage" id="trader-contract-tonnage" value="" class="form-control" placeholder="Tonnage (in Kgs)">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-md-6">
                                        <label for="trader-contract-produce-unit-id">Produce Unit</label>
                                        <select id="trader-contract-produce-unit-id" name="produce_unit_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            @foreach($produce_units as $produce_unit)
                                                <option value="{{ $produce_unit->id }}">{{ $produce_unit->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="trader-contract-price-per-unit">Price per Unit</label>
                                        <input type="text" name="price_per_unit" id="trader-contract-price-per-unit" value="" class="form-control" placeholder="Price per Unit">
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="trader-contract-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif

    <!-- Input Item Modal -->
    @if($trader->isBulkSeller())
        <div class="modal fade" id="input-items-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="input-item-modal-title" id="input-item-modal-title"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="input-item-form" name="input-item-form" method="post">
                        @csrf
                        <div class="modal-body">
                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                            <input type="hidden" name="id" id="input-item-id">
                            <input type="hidden" name="trader_id" id="input-item-trader-id" value="{{ $trader->id }}">
                            <div class="form-group">
                                <label for="input-item-name">Name</label>
                                <input type="text" name="name" id="input-item-name" value="" class="form-control" placeholder="Name">
                            </div>
                            <div class="form-group">
                                <label for="input-item-input-id">Input</label>
                                <select id="input-item-input-id" name="input_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    @foreach($inputs as $input)
                                        <option value="{{ $input->id }}">{{ $input->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="input-item-input-unit-id">Input Unit</label>
                                <select id="input-item-input-unit-id" name="input_unit_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    @foreach($input_units as $input_unit)
                                        <option value="{{ $input_unit->id }}">{{ $input_unit->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="row">
                            <div class="form-group col-md-6">
                                <label for="input-item-price-per-unit">Price per Unit</label>
                                <input type="text" name="price_per_unit" id="input-item-price-per-unit" value="" class="form-control" placeholder="Price per Unit">
                            </div>
                            <div class="form-group col-md-6">

                                <label for="input-item-listed">Listed?</label>
                                <select name="listed" id="input-listed" class="form-control">
                                    <option value="">- Select -</option>
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="input-item-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif

    <!-- Trader Network Modal -->
    @if($trader->isBulkBuyer())
        <div class="modal fade" id="trader-networks-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="trader-network-modal-title" id="trader-network-modal-title">Add Network - {{ $trader->organisation_name }}</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="trader-network-form" name="trader-network-form" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                            <input type="hidden" name="id" id="trader-network-id">
                            <input type="hidden" name="trader_id" id="trader-network-trader-id" value="{{ $trader->id }}">
                            {{-- <div class="form-group">
                                <label for="trader-network-user-id">Name</label>
                                <input type="hidden" id="trader-network-user-id-hidden" disabled="disabled">
                                <input type="text" name="name" id="trader-network-name" class="form-control">
                            </div> --}}
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label for="trader-network-type">Type</label>
                                    <select id="trader-network-type" name="type" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                        <option value="">- Select -</option>
                                        <option value="national">National</option>
                                        <option value="regional">Regional</option>
                                        <option value="last-mile">Last-mile</option>
                                    </select>
                                </div>
                                <div class="col-md-6 region hide">
                                    <label for="trader-network-region-id">Region</label>
                                    <select id="trader-network-region-id" name="region_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                        <option value="">- Select -</option>
                                        @foreach($regions as $region)
                                            <option value="{{ $region->id }}">{{ $region->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6 county hide">
                                    <label for="trader-network-county-id">County</label>
                                    <select id="trader-network-county-id" name="county_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                        <option value="">- Select -</option>
                                        @foreach($counties as $county)
                                            <option value="{{ $county->id }}">{{ $county->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="trader-network-description">Description</label>
                                <textarea name="description" id="trader-network-description" class="form-control"></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="trader-network-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif
@endsection

@section('scripts')
    <script>
        // $(document).ready(function(){
        //     $.ajaxSetup({
        //         headers: {
        //             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        //         }
        //     });

        //     $('#btn_upload').click(function(){

        //         var fd = new FormData();
        //         var files = $('#file')[0].files[0];
        //         fd.append('file',files);
        //         //var name=$("#edit_name").val();
        //         // var csrf="{{ csrf_token() }}";

        //         $.ajax({
        //         url: '{{ url("/trader_editcontract") }}',
        //         type: 'post',
        //         data:fd,
        //         contentType: false,
        //         processData: false,
        //         success: function(response){
        //             alert(response);
        //         }
        //         });
        //     });
        // });

        function removeRow(removeNum) {
            $('#rowCount'+removeNum).remove();
        }

        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#blah')
                        .attr('src', e.target.result)
                        .width(120)
                        .height(120);
                };

                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

    <script>
        // Trader Members JS
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#trader-members-crud-modal').on('shown.bs.modal', function() {
                // $('#trader-member-user-id').select2({
                //     dropdownParent: $('#trader-members-crud-modal')
                // });
            });

            // $('#trader-member-user-id').on('select2:select', function(e) {
            //     var selected = e.params.data;
            //     console.log(selected);

            //     $.ajax({
            //         url: '/users/get-user/' + selected.id,
            //         dataType: 'json',
            //         type: "GET",
            //         success: function (data) {
            //             console.log(data);

            //             $('#trader-member-firstname').val(data.firstname);
            //             $('#trader-member-lastname').val(data.lastname);
            //             $('#trader-member-email').val(data.email);
            //             $('#trader-member-phone').val(data.phone);
            //             $('#trader-member-username').val(data.username);
            //         },
            //         error: function (data) {
            //             console.log('Error:', data);
            //         }
            //     });
            // });

            $('#trader-members-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // create trader-member
            $('body').on('click', '#create-trader-member', function(e) {
                e.preventDefault();

                $('#trader-member-modal-save').val("create-trader-member");
                $('#trader-member-form').trigger("reset");
                $('#trader-member-id').val('');
                // $('#trader-member-user-id').prop('name', 'user_id').val('').trigger('change');
                // $('#trader-member-user-id').prop('disabled', false);
                // $('#trader-member-user-id-hidden').prop('name', '').prop('disabled', true);
                $('#trader-member-user-id').val('');
                $('#trader-member-firstname').val('');
                $('#trader-member-lastname').val('');
                $('#trader-member-email').val('');
                $('#trader-member-phone').val('');
                $('#trader-member-username').val('');
                $('#trader-member-password').val('');
                $('#trader-member-confirm-password').val('');
                $('#trader-member-active').val('');
                $('#trader-member-modal-title').html("Add a Member");
                $('#trader-members-crud-modal').modal('show');
            });

            // edit trader-member
            $('body').on('click', '#edit-trader-member', function (e) {
                e.preventDefault();

                var trader_member_id = $(this).data('id');
                console.log("trader_member_id: " + trader_member_id);

                $.get('/trader-members/' + trader_member_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#trader-member-modal-title').html("Edit Member");
                    $('#trader-member-modal-save').val("edit-trader-member");

                    $('#trader-member-id').val(data.id);
                    // $('#trader-member-user-id').val(data.user_id).trigger('change');
                    // $('#trader-member-user-id').prop('disabled', true)
                    //     .prop('name', '');
                    // $('#trader-member-user-id-hidden').prop('disabled', false)
                    //     .prop('name', 'user_id')
                    //     .val(data.user_id);
                    $('#trader-member-user-id').val(data.user_id);
                    $('#trader-member-firstname').val(data.user.firstname);
                    $('#trader-member-lastname').val(data.user.lastname);
                    $('#trader-member-email').val(data.user.email);
                    $('#trader-member-phone').val(data.user.phone);
                    $('#trader-member-username').val(data.user.username);
                    $('#trader-member-password').val('');
                    $('#trader-member-confirm-password').val('');
                    $('#trader-member-active').val(data.active);
                    $('#trader-members-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#trader-member-modal-save').html('Save');
                })
            });

            // delete trader-member
            $('body').on('click', '#delete-trader-member', function (e) {
                e.preventDefault();

                var trader_member_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if(confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-members/' + trader_member_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_member_id_" + trader_member_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // store trader-member (after create or edit)
            if ($("#trader-member-form").length > 0) {
                $("#trader-member-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-member-form').serialize();
                        var actionType = $('#trader-member-modal-save').val();
                        $('#trader-member-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-members/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);

                                var active = data.active == 1 ? '<i class="fa fa-check"></i>' : '';
                                var trader_member = '<tr id="trader_member_id_' + data.id + '"><td><a href="#">' + data.user.firstname + ' ' + data.user.lastname + '</a></td>';
                                    trader_member += '<td>'+ data.user.username +'</td><td>' + data.user.email + '</td><td>' + data.user.phone + '</td><td class="text-center">'+ active +'</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader_member += '<button id="edit-trader-member" type="button" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</button>';
                                    trader_member += '<button id="delete-trader-member" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     trader-member
                                    // ]);

                                if (actionType == "create-trader-member") {
                                    $('#trader-member-list').prepend(trader_member);
                                } else {
                                    $("#trader_member_id_" + data.id).replaceWith(trader_member);
                                }

                                $('#trader-member-modal-save').html('Save');
                                $('#trader-members-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#trader-member-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    <script>
        // Trader Contacts JS
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#trader-contacts-crud-modal').on('shown.bs.modal', function() {
                $('#trader-contact-name').trigger('focus');

                $('#trader-contact-user-id').select2({
                    dropdownParent: $('#trader-contacts-crud-modal')
                });
            });

            $('#trader-contact-user-id').on('select2:select', function(e) {
                var selected = e.params.data;

                $.ajax({
                    url: '/users/get-user/' + selected.id,
                    dataType: 'json',
                    type: "GET",
                    success: function (data) {
                        $('#trader-contact-firstname').val(data.firstname);
                        $('#trader-contact-lastname').val(data.lastname);
                        $('#trader-contact-email').val(data.email);
                        $('#trader-contact-phone').val(data.phone);
                    },
                    error: function (data) {
                        console.log('Error:', data);
                    }
                });
            });

            $('#trader-contacts-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // create trader-contact
            $('body').on('click', '#create-trader-contact', function(e) {
                e.preventDefault();

                $('#trader-contact-modal-save').val("create-trader-contact");
                $('#trader-contact-form').trigger("reset");

                $('#trader-contact-id').val('');
                $('#trader-contact-user-id').val('').trigger('change');
                $('#trader-contact-firstname').val('');
                $('#trader-contact-lastname').val('');
                $('#trader-contact-email').val('');
                $('#trader-contact-phone').val('');
                // $('#trader-contact-user-id').prop('name', 'user_id').val('').trigger('change');
                // $('#trader-contact-user-id').prop('disabled', false);
                // $('#trader-contact-user-id-hidden').prop('name', '').prop('disabled', true);
                $('#trader-contact-modal-title').html("Add Contact Person");
                $('#trader-contacts-crud-modal').modal('show');
            });

            // edit trader-contact
            $('body').on('click', '#edit-trader-contact', function (e) {
                e.preventDefault();

                var trader_contact_id = $(this).data('id');

                $.get('/trader-contacts/' + trader_contact_id +'/edit-ajax', function (data) {
                    $('#trader-contact-modal-title').html("Edit Contact Person");
                    $('#trader-contact-modal-save').val("edit-trader-contact");

                    $('#trader-contact-id').val(data.id);
                    $('#trader-contact-user-id').val(data.user_id);
                    $('#trader-contact-firstname').val(data.firstname);
                    $('#trader-contact-lastname').val(data.lastname);
                    $('#trader-contact-email').val(data.email);
                    $('#trader-contact-phone').val(data.phone);
                    $('#trader-contact-is-admin').val(data.is_admin);
                    // $('#trader-contact-user-id').prop('disabled', true).prop('name', '');
                    // $('#trader-contact-user-id-hidden').prop('disabled', false).prop('name', 'user_id').val(data.user_id);
                    $('#trader-contacts-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#trader-contact-modal-save').html('Save');
                })
            });

            // delete trader-contact
            $('body').on('click', '#delete-trader-contact', function (e) {
                e.preventDefault();

                var trader_contact_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if(confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-contacts/' + trader_contact_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_contact_id_" + trader_contact_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // store trader-contact (after create or edit)
            if ($("#trader-contact-form").length > 0) {
                $("#trader-contact-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-contact-form').serialize();
                        var actionType = $('#trader-contact-modal-save').val();
                        $('#trader-contact-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-contacts/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                // TODO: Add code to remove fa-check icon from all td.is-admin

                                let is_admin = (data.is_admin == 1) ? '<i class="fa fa-check"></i>' : '';
                                let trader_contact = '<tr id="trader_contact_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.firstname + ' ' + data.lastname + '</a></td>';
                                    trader_contact += '<td>' + data.email + '</td><td>' + data.phone + '</td><td class="text-center is-admin">'+ is_admin +'</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader_contact += '<a id="edit-trader-contact" href="#" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    trader_contact += '<button id="delete-trader-contact" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // TODO: REMOVE
                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     trader-contact
                                    // ]);

                                if (actionType == "create-trader-contact") {
                                    $('#trader-contact-list').prepend(trader_contact);
                                } else {
                                    $("#trader_contact_id_" + data.id).replaceWith(trader_contact);
                                }

                                $('#trader-contact-modal-save').html('Save');
                                $('#trader-contacts-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#trader-contact-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    <script>
        // Produce Item JS
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // onload modal
            $('#produce-items-crud-modal').on('shown.bs.modal', function() {
                $('#produce-item-name').trigger('focus');

                $('#produce-item-category_id').select2({
                    dropdownParent: $('#produce-items-crud-modal')
                });
            });

            // datatable
            $('#produce-items-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // create produce-item
            $('#create-produce-item').click(function(e) {
                e.preventDefault();

                $('#produce-item-modal-save').val("create-produce-item");
                $('#produce-item-modal-title').html("Add Produce Item");

                $('#produce-item-form').trigger("reset");
                $('#produce-item-id').val('');
                $('#produce-item-produce-id').val('').trigger('change');
                $('#produce-item-produce-unit-id').val('').trigger('change');
                $('#produce-item-quality').val('');
                $('#produce-item-price-per-unit').val('');
                $('#produce-item-tonnage').val('');

                $('#produce-items-crud-modal').modal('show');
            });

            // edit produce-item
            $('body').on('click', '#edit-produce-item', function (e) {
                e.preventDefault();

                var produce_item_id = $(this).data('id');

                $.get('/produce-items/' + produce_item_id +'/edit-ajax', function (data) {
                    $('#produce-item-modal-title').html("Edit Produce Item");
                    $('#produce-item-modal-save').val("edit-produce-item");

                    $('#produce-item-id').val(data.id);
                    $('#produce-item-name').val(data.name);
                    $('#produce-item-produce-id').val(data.produce_id).trigger('change');
                    $('#produce-item-produce-unit-id').val(data.produce_unit_id).trigger('change');
                    $('#produce-item-price-per-unit').val(data.price_per_unit);
                    $('#produce-item-quality').val(data.quality);
                    $('#produce-item-tonnage').val(data.tonnage);

                    $('#produce-items-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#produce-item-modal-save').html('Save');
                })
            });

            // delete produce-item
            $('body').on('click', '#delete-produce-item', function (e) {
                e.preventDefault();

                var produce_item_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/produce-items/' + produce_item_id + '/delete-ajax',
                        success: function (data) {
                            $("#produce_item_id_" + produce_item_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // store produce-item (after create or edit)
            if ($("#produce-item-form").length > 0) {
                $("#produce-item-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#produce-item-form').serialize();
                        var actionType = $('#produce-item-modal-save').val();
                        $('#produce-item-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/produce-items/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {

                                var produce_item = '<tr id="produce_item_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.produce.name + '</a></td>';
                                    produce_item += '<td>' + data.produce_unit.name + '</td><td>' + data.price_per_unit + '</td><td>' + data.quality + '</td><td>' + data.tonnage + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    produce_item += '<a id="edit-produce-item" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    produce_item += '<button id="delete-produce-item" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     produce
                                    // ]);

                                if (actionType == "create-produce-item") {
                                    console.log(produce_item);
                                    $('#produce-item-list').prepend(produce_item);
                                } else {
                                    $("#produce_item_id_" + data.id).replaceWith(produce_item);
                                }

                                $('#produce-item-modal-save').html('Save');
                                $('#produce-items-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#produce-item-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    <script>
        function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
            try {
                decimalCount = Math.abs(decimalCount);
                decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

                const negativeSign = amount < 0 ? "-" : "";

                let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
                let j = (i.length > 3) ? i.length % 3 : 0;

                return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
            } catch (e) {
                console.log(e)
            }
        }

        // Trader Contracts JS
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#trader-contracts-crud-modal').on('shown.bs.modal', function() {
                $('#trader-contract-produce-id').select2({
                    dropdownParent: $('#trader-contracts-crud-modal')
                });

                $('#trader-contract-name').trigger('focus');
            });

            $('#trader-contracts-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // create contract
            $('body').on('click', '#create-trader-contract', function(e) {
                e.preventDefault();

                $('#trader-contract-modal-title').html("Add Contract");
                $('#trader-contract-modal-save').val("create-trader-contract");

                $('#trader-contract-form').trigger("reset");
                $('#trader-contract-id').val('');
                $('#trader-contract-name').val('');
                $('#trader-contract-produce-id').val('').trigger('change');
                $('#trader-contract-produce-unit-id').val('').trigger('change');
                $('#trader-contract-price-per-unit').val('');
                $('#trader-contract-tonnage').val('');

                $('#trader-contracts-crud-modal').modal('show');
            });

            // edit contract
            $('body').on('click', '#edit-trader-contract', function (e) {
                e.preventDefault();

                var trader_contract_id = $(this).data('id');

                $.get('/trader-contracts/' + trader_contract_id +'/edit-ajax', function (data) {
                    $('#trader-contract-modal-title').html("Edit Contract");
                    $('#trader-contract-modal-save').val("edit-trader-contract");

                    $('#trader-contract-id').val(data.id);
                    $('#trader-contract-old-file').val(data.contract_file);
                    $('#trader-contract-name').val(data.name);
                    $('#trader-contract-produce-id').val(data.produce_id).trigger('change');
                    $('#trader-contract-produce-unit-id').val(data.produce_unit_id).trigger('change');
                    $('#trader-contract-price-per-unit').val(formatMoney(data.price_per_unit));
                    $('#trader-contract-tonnage').val(data.tonnage);

                    $('#trader-contracts-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#trader-contract-modal-save').html('Save');
                })
            });

            // delete contract
            $('body').on('click', '#delete-trader-contract', function (e) {
                e.preventDefault();

                var trader_contract_id = $(this).data("id");
                var confirmDelete = confirm("Are You sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-contracts/' + trader_contract_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_contract_id_" + trader_contract_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // store contract (after create or edit)
            $("#trader-contract-form").on('submit', (function(e) {
                e.preventDefault();

                $(this).validate({
                    submitHandler: function(form) {
                        // formData = $('#trader-contract-form').serialize();
                        // let formData = new FormData($(form)[0]);

                        // let formData = new FormData();
                        // formData.append('file', file);

                        var myForm = $("#trader-contract-form")[0];
                        var formData = new FormData(myForm);

                        let actionType = $('#trader-contract-modal-save').val();
                        $('#trader-contract-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-contracts/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            contentType: false,
                            cache: false,
                            processData: false,
                            success: function (data) {
                                let site_path = $('meta[name="base_url"]').attr('content');

                                let trader_contract = '<tr id="trader_contract_id_' + data.id + '"><td class="details-control" data-id="'+ data.id +'"></td>'
                                    trader_contract += '<td><a href="'+ data.url +'">' + data.name + '</a>'
                                    trader_contract += '<br><small><i class="far fa-file-pdf"></i> Contract Document [<a href="'+ site_path +'/public/trader-contracts/'+ data.contract_file +'" target="_blank">Download</a>]</small>';
                                    trader_contract += '<br><small>Produce: '+ data.produce.name +'</small>';
                                    trader_contract += '<br><small>Unit: '+ data.produce_unit.name +'</small></td>';
                                    trader_contract += '<td>' + data.price_per_unit + '</td><td>' + data.tonnage + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader_contract += '<a id="edit-trader-contract" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    trader_contract += '<button id="delete-trader-contract" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     region
                                    // ]);

                                if (actionType == "create-trader-contract") {
                                    $('#trader-contract-list').prepend(trader_contract);
                                } else {
                                    $("#trader_contract_id_" + data.id).replaceWith(trader_contract);
                                }

                                $('#trader-contract-modal-save').html('Save');
                                $('#trader-contracts-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#trader-contract-modal-save').html('Save');
                            }
                        });
                    }
                });
            }));

            $('#trader-contracts-list tbody').on('click', 'td.details-control', function () {
                console.log('here');
                var oTable = $('#trader-contracts-list').DataTable();
                var tr = $(this).closest('tr');
                var row = oTable.row( tr );

                if ( row.child.isShown() ) {
                    // This row is already open - close it
                    row.child.hide();
                    tr.removeClass('shown');
                } else {
                    // Open this row
                    row.child( format($(this).data("id")) ).show();
                    tr.addClass('shown');
                }
            });
        });

        // Show Trader Contract Details JS
        // this.format = function (id) {
        //     return $.ajax({
        //         type: "GET",
        //         context: this,  // <---- context property to set "this" in the callbacks
        //         url: "'/trader-contracts/'+ id +'/get-details'",
        //         success: function (data) {
        //             let contract_details = '<table class="table table-bordered" cellpadding="0" cellspacing="0" border="0" style="width: 100%;">';
        //             contract_details += '<thead><tr><th>Produce Item</th><th>Tonnage (in Kgs)</th><th>Price per Unit</th></tr></thead>';

        //             data.forEach(datum => {
        //                 contract_details += '<tr>';
        //                 contract_details += '<td>'+ datum.produce_item_id +'</td>';
        //                 contract_details += '<td>'+ datum.produce_tonnage +'</td>';
        //                 contract_details += '<td>'+ datum.price_per_unit +'</td>';
        //                 contract_details += '</tr>';
        //             });

        //             contract_details += '</table>';
        //             console.log(contract_details);

        //             this = contract_details;
        //         },
        //         error: function (jqXHR, textStatus, errorThrown) {
        //             // console.warn(xhr.responseText)
        //             console.log(JSON.stringify(jqXHR));
        //             console.log("AJAX error: " + textStatus + ' : ' + errorThrown);

        //             this = null;
        //         }
        //     });
        // }
    </script>

    <script>
        // Input Item JS
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // onload modal
            $('#input-items-crud-modal').on('shown.bs.modal', function() {
                $('#input-item-name').trigger('focus');

                $('#input-item-input-id').select2({
                    dropdownParent: $('#input-items-crud-modal')
                });
            });

            // datatable
            $('#input-items-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // create input-item
            $('#create-input-item').click(function(e) {
                e.preventDefault();

                $('#input-item-modal-save').val("create-input-item");
                $('#input-item-modal-title').html("Add Input Item");

                $('#input-item-form').trigger("reset");
                $('#input-item-id').val('');
                $('#input-item-name').val('');
                $('#input-item-input-id').val('').trigger('change');
                $('#input-item-input-unit-id').val('').trigger('change');
                $('#input-item-price-per-unit').val('');
                $('#input-item-listed').val('').trigger('change');

                $('#input-items-crud-modal').modal('show');
            });

            // edit input-item
            $('body').on('click', '#edit-input-item', function (e) {
                e.preventDefault();

                var input_item_id = $(this).data('id');

                $.get('/input-items/' + input_item_id +'/edit-ajax', function (data) {
                    $('#input-item-modal-title').html("Edit Input Item");
                    $('#input-item-modal-save').val("edit-input-item");

                    $('#input-item-id').val(data.id);
                    $('#input-item-name').val(data.name);
                    $('#input-item-input-id').val(data.input_id).trigger('change');
                    $('#input-item-input-unit-id').val(data.input_unit_id).trigger('change');
                    $('#input-item-price-per-unit').val(data.price_per_unit);
                    $('#input-item-listed').val(data.listed).trigger('change');

                    $('#input-items-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#input-item-modal-save').html('Save');
                })
            });

            // delete input-item
            $('body').on('click', '#delete-input-item', function (e) {
                e.preventDefault();

                var input_item_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/input-items/' + input_item_id + '/delete-ajax',
                        success: function (data) {
                            $("#input_item_id_" + input_item_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // store input-item (after create or edit)
            if ($("#input-item-form").length > 0) {
                $("#input-item-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#input-item-form').serialize();
                        var actionType = $('#input-item-modal-save').val();
                        $('#input-item-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/input-items/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                var listed = data.listed == 1 ? '<i class="fa fa-check">' : '';

                                var input_item = '<tr id="input_item_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.name + '</a>';
                                    input_item += '<br><b>Input:</b> '+ data.input.name;
                                    input_item += '<br><b>Unit:</b> '+ data.input_unit.name +'</small></td>';
                                    input_item += '<td>' + data.price_per_unit + '</td><td>' + listed + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    input_item += '<a id="edit-input-item" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    input_item += '<button id="delete-input-item" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     input
                                    // ]);

                                if (actionType == "create-input-item") {
                                    console.log(input_item);
                                    $('#input-item-list').prepend(input_item);
                                } else {
                                    $("#input_item_id_" + data.id).replaceWith(input_item);
                                }

                                $('#input-item-modal-save').html('Save');
                                $('#input-items-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#input-item-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    <script>
        // Trader Networks JS
        $(document).ready(function() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#trader-networks-crud-modal').on('shown.bs.modal', function() {
                $('#trader-network-region-id').select2({
                    dropdownParent: $('#trader-networks-crud-modal')
                });

                $('#trader-network-county-id').select2({
                    dropdownParent: $('#trader-networks-crud-modal')
                });
            });

            $('#trader-networks-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // create network
            $('body').on('click', '#create-trader-network', function(e) {
                e.preventDefault();

                $('#trader-network-modal-title').html("Add Network");
                $('#trader-network-modal-save').val("create-trader-network");

                $('#trader-network-form').trigger("reset");
                $('#trader-network-id').val('');
                $('#trader-network-type').val('').trigger('change');
                $('#trader-network-region-id').val('').trigger('change');
                $('#trader-network-county-id').val('').trigger('change');
                $('#trader-network-description').val('');

                $('#trader-networks-crud-modal').modal('show');
            });

            // edit network
            $('body').on('click', '#edit-trader-network', function (e) {
                e.preventDefault();

                var trader_network_id = $(this).data('id');

                $.get('/trader-networks/' + trader_network_id +'/edit-ajax', function (data) {
                    $('#trader-network-modal-title').html("Edit Network");
                    $('#trader-network-modal-save').val("edit-trader-network");

                    $('#trader-network-id').val(data.id);
                    $('#trader-network-type').val(data.type).trigger('change');
                    $('#trader-network-region-id').val(data.region_id).trigger('change');
                    $('#trader-network-county-id').val(data.county_id).trigger('change');
                    $('#trader-network-description').val(data.description);

                    $('#trader-networks-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#trader-network-modal-save').html('Save');
                })
            });

            // delete network
            $('body').on('click', '#delete-trader-network', function (e) {
                e.preventDefault();

                var trader_network_id = $(this).data("id");
                var confirmDelete = confirm("Are You sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-networks/' + trader_network_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_network_id_" + trader_network_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // store network (after create or edit)
            $("#trader-network-form").on('submit', (function(e) {
                e.preventDefault();

                $(this).validate({
                    submitHandler: function(form) {
                        var myForm = $("#trader-network-form")[0];
                        var formData = new FormData(myForm);

                        let actionType = $('#trader-network-modal-save').val();
                        $('#trader-network-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-networks/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            contentType: false,
                            cache: false,
                            processData: false,
                            success: function (data) {
                                let site_path = $('meta[name="base_url"]').attr('content');

                                let trader_network = '<tr id="trader_network_id_' + data.id + '"><td>' + data.trader.organisation_name
                                    trader_network += '<br><small>Type: '+ data.type +'</small>';
                                    trader_network += (data.type == 'Regional') ? '<br><small>Region: '+ data.region.name +'</small>' : '';
                                    trader_network += (data.type == 'Last-mile') ? '<br><small>County: '+ data.county.name +'</small>' : '';
                                    trader_network += '</td>';
                                    trader_network += '<td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader_network += '<a id="edit-trader-network" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    trader_network += '<button id="delete-trader-network" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                if (actionType == "create-trader-network") {
                                    $('#trader-network-list').prepend(trader_network);
                                } else {
                                    $("#trader_network_id_" + data.id).replaceWith(trader_network);
                                }

                                $('#trader-network-modal-save').html('Save');
                                $('#trader-networks-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#trader-network-modal-save').html('Save');
                            }
                        });
                    }
                });
            }));
        });
    </script>
@endsection
