@extends('layouts.site')
<style type="text/css">
    #buyer_type_category{
        display: none;
    }
</style>

@section('title')
    BTCotton | Organisations
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Organisations</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Organisations</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-trader" href="{{ route('traders.create') }}" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Add Organisation
        </a>

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    @include ('_partials.filter-traders')

                    <div class="text-right mb-3 border-bottom pb-3">
                        <a id="traders-export" href="{{ route('traders.export') }}" class="btn btn-primary btn-border btn-round btn-sm">
                            <i class="far fa-file-excel"></i> Export Excel
                        </a>
                        <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panel">
                            <i class="fas fa-filter"></i> Filter
                        </a>
                    </div>

                    <div id="filter-msg" class="d-none">
                        <div class="alert alert-info shadow-sm mb-0" role="alert">
                            <p class="mb-0"><i class="fas fa-info-circle"></i> This is a filtered view. <span id="filters"></span></p>
                        </div>
                        <hr>
                    </div>

                    @if($traders->count())
                        <div class="table-responsive">
                            <table id="traders-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Region</th>
                                        <th>County</th>
                                        <th>Contact Person</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Region</th>
                                        <th>County</th>
                                        <th>Contact Person</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="trader-list">
                                    @foreach($traders as $trader)
                                        <tr id="trader_id_{{ $trader->id }}">
                                            <td><a href="{{ $trader->url }}">{{ $trader->organisation_name }}</a></td>
                                            <td>{{ $trader->trader_type->name }}</td>
                                            <td>{{ $trader->email }}</td>
                                            <td>{{ $trader->phone }}</td>
                                            <td>{{ isset($trader->region) ? $trader->region->name : '' }}</td>
                                            <td>{{ isset($trader->county) ? $trader->county->name : '' }}</td>
                                            <td>{{ $trader->user->fullname }}</td>
                                            <td class="text-right">
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-trader" href="{{ route('traders.edit', $trader->id) }}" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $trader->id }}">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-trader" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $trader->id }}">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="trader-form" name="trader-form" method="post">
                    @csrf

                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                        <input type="hidden" name="id" id="trader-id">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-organisation-name">Organisation Name*</label>
                                        <input type="text" name="organisation_name" id="trader-organisation-name" value="" class="form-control" placeholder="Organisation Name" autofocus>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-type-id">Organisation Type*</label>
                                        <select id="trader-type-id" name="type_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            @foreach($trader_types as $trader_type)
                                                <option value="{{ $trader_type->id }}">{{ $trader_type->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="form-row" id="buyer_type_category">
                                    <div class="col form-group">
                                        <label for="buyer-type-id">Buyer Type*</label>            
                                        <select id="buyer-type-id" name="buyer_type" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                                                    <option value="">- Select -</option>                                            
                                                                        <option value="1">Ginner</option>
                                                                        <option value="2">Spinner</option>
                                                                
                                        </select>
                                        @if ($errors->has('buyer-type-id'))
                                            <div class="invalid-feedback">
                                                <strong>{{ $errors->first('buyer-type-id') }}</strong>
                                            </div>
                                        @endif
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-region-id">Region*</label><br>
                                        <select name="region_id" id="trader-region-id" class="form-control">
                                            <option value="">- Select -</option>
                                            @foreach ($regions as $region)
                                                <option value="{{ $region->id }}">{{ $region->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-county-id">County*</label><br>
                                        <select name="county_id" id="trader-county-id" class="form-control">
                                            <option value="">- Select -</option>
                                            @foreach ($counties as $county)
                                                <option value="{{ $county->id }}">{{ $county->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col form-group">
                                        <label for="trader-ward">Ward</label><br>
                                        <input type="text" name="ward" id="trader-ward" class="form-control" placeholder="Ward">
                                    </div>
                                </div>
                                {{-- <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-preferred-regions">Regions*</label><br>
                                        <select name="preferred_regions" id="trader-preferred-regions" class="form-control" multiple>
                                            <option>- Select -</option>
                                            @foreach ($regions as $key => $value)
                                                <option value="{{ $key }}">{{ $value->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div> --}}
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-email">Email*</label>
                                        <input name="email" id="trader-email" type="email" class="form-control" placeholder="Email">
                                    </div>

                                    <div class="col form-group">
                                        <label for="trader-phone">Phone Number</label>
                                        <input name="phone" id="trader-phone" type="text" class="form-control" placeholder="Phone Number">
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-postal-address">Postal Address</label>
                                        <textarea name="postal_address" id="trader-postal-address" class="form-control" placeholder="Postal Address"></textarea>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-account-status">Account Status</label>
                                        <select name="account_status" id="trader-account-status" class="form-control">
                                            <option>- Select -</option>
                                                <option value="1">Active</option>
                                                <option value="0">Inactive</option>
                                          
                                         </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                {{-- <fieldset {{ (request()->is('*edit')) ? 'disabled' : '' }}> --}}
                                <fieldset id="trader-admin-user">
                                    <legend>Admin Account</legend>

                                    <div class="panel panel-default">
                                        <div class="form-row">
                                            <div class="col form-group">
                                                <label for="trader-user-firstname">First Name*</label>
                                                <input name="user_firstname" id="trader-user-firstname" type="text" class="form-control" placeholder="First Name">
                                            </div> <!-- form-group end.// -->
                                            <div class="col form-group">
                                                <label for="trader-user-lastname">Last Name*</label>
                                                <input name="user_lastname" id="trader-user-lastname" type="text" class="form-control" placeholder="Last Name">
                                            </div> <!-- form-group end.// -->
                                        </div>
                                        <div class="form-row">
                                            <div class="col form-group">
                                                <label for="trader-user-email">Email*</label>
                                                <input name="user_email" id="trader-user-email" type="text" class="form-control" placeholder="Email">
                                            </div> <!-- form-group end.// -->

                                            <div class="col form-group">
                                                <label for="trader-user-phone">Phone Number*</label>
                                                <input name="user_phone" id="trader-user-phone" type="text" class="form-control" placeholder="Phone Number">
                                            </div> <!-- form-group end.// -->
                                        </div>
                                        <hr>
                                        <div class="form-row">
                                            <div class="col form-group">
                                                <label for="trader-user-username">Username*</label>
                                                <input name="user_username" id="trader-user-username" type="text" class="form-control" placeholder="Username">
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="col form-group">
                                                <label for="trader-user-password">Password*</label>
                                                <input name="user_password" id="trader-user-password" type="password" class="form-control" placeholder="Password">
                                            </div>
                                            <div class="col form-group">
                                                <label for="trader-user-password-confirm">Confirm Password*</label>
                                                <input name="user_password_confirm" id="trader-user-password-confirm" type="password" class="form-control"  placeholder="Confirm Password">
                                            </div>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal -->
    {{-- <div class="modal fade" id="contractModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel">Add Contract</h4>
            </div>
            <div class="modal-body">
                    <form class="form-horizontal" role="form" name="add_contract" id="add_contract" action="" method="POST">
                        <div id="contract_fields">
                            <input type="hidden" name="trader-id" value="" id="trader-id"/>
                            <input type="file" id="exampleInputFile" name="exampleInputFile[]" class="exampleInputFile">
                        </div>
                    </form>
            </div>
            <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" name="Save"  id="edit_contract_method" style="margin-bottom: 8px;" >Add</button>
                </div>
            </div>
        </div>
    </div> --}}
    <!--end of contract modal -->

    <!-- Activate Modal -->
    {{-- <div class="modal fade" id="activateModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-eye"></i> Activate {{ request()->filled('name') ? ucfirst(request()->name) : 'Organisation' }}
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    @include ('layouts._messages')

                    <form class="d-inline" method="post" action="{{ route('traders.activate', $trader->id) }}">
                        @csrf
                        @method('POST')
                        <input type="hidden" name="trader_id" id="activate-trader_id" value="">
                        <input type="hidden" name="activation_type" id="activate-activation_type" value="Activation">
                        <div class="form-group">
                            <label for="activate-comments">Activation Notes</label>
                            <textarea type="text" name="comments" id="activate-comments" class="form-control mb-3 {{ $errors->has('commnents') ? 'is-invalid' : '' }}">{{ old('comments' ?? '') }}</textarea>

                            <button type="submit" title="" class="btn btn-primary">
                                Activate {{ request()->filled('name') ? ucfirst(request()->name) : 'Organisation' }}
                            </button>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn-sm" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div> --}}

    <!-- Deactivate Modal -->
    {{-- <div class="modal fade" id="deactivateModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-eye-slash"></i> Deactivate {{ request()->filled('name') ? ucfirst(request()->name) : 'Organisation' }}
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    @include ('layouts._messages')

                    <form class="d-inline" method="post" action="{{ route('traders.deactivate', $trader->id) }}">
                        @csrf
                        @method('POST')
                        <input type="hidden" name="trader_id" id="deactivate-trader_id" value="">
                        <input type="hidden" name="activation_type" id="deactivate-activation_type" value="Deactivation">
                        <div class="form-group">
                            <label for="deactivate-comments">Deactivation Notes</label>
                            <textarea type="text" name="comments" id="deactivate-comments" class="form-control mb-3 {{ $errors->has('commnents') ? 'is-invalid' : '' }}">{{ old('comments' ?? '') }}</textarea>

                            <button type="submit" title="" class="btn btn-primary">
                                Deactivate {{ request()->filled('name') ? ucfirst(request()->name) : 'Organisation' }}
                            </button>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn-sm" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div> --}}
@endsection

@section('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-url-parser/2.3.1/purl.min.js"></script>
    <script>
        // $(document).ready(function() {

        //     // $(document).on("click", "#activateTrader", function () {
        //     //     var ids = $(this).data('id');
        //     //     $("#activateModal #activate-trader_id").val(ids);
        //     // });

        //     // $(document).on("click", "#deactivateTrader", function () {
        //     //     var ids = $(this).data('id');
        //     //     $("#deactivateModal #deactivate-trader_id").val(ids);
        //     // });

        //     // //get the modal values on the contract
        //     // $(".editContractMethod").click(function() {
        //     //     var trader_id = $(this).data('trader-id');
        //     //     $("div#contract_fields input[name=trader-id]").val(id);
        //     // });

        // });

        $(document).ready(function () {

       
            $('#trader-type-id').on('change',function(){                       
                       
                          var el = document.getElementById('trader-type-id');
                          
                          var selectedText = el.options[el.selectedIndex].text;                        
  
                          if(selectedText=="BTCotton Buyer"){
                           
                              $("#buyer_type_category").show();
                          }
                          else if(selectedText!="BTCotton Buyer"){
                              $("#buyer_type_category").hide();                             
                          }
                      
            });
   
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#traders-list').DataTable({
                responsive: true,
                scrollX: true,
                fixedColumns: true,
                scrollCollapse: true,
            });

            //onload modal
            $('#crud-modal').on('shown.bs.modal', function() {
                $('#trader-organisation_name').trigger('focus');

                $('#trader-type-id').select2({
                    dropdownParent: $('#crud-modal')
                });

                $('#trader-region-id').select2({
                    dropdownParent: $('#crud-modal')
                });

                $('#trader-county-id').select2({
                    dropdownParent: $('#crud-modal')
                });
            });

            // create
            $('body').on('click', '#create-trader', function(e) {
                e.preventDefault();

                $('#modal-save').val("create-trader");
                $('#trader-form').trigger("reset");
                $('#trader-id').val('');
                $('#trader-type-id').val('').trigger('change');
                $('#trader-region-id').val('').trigger('change');
                $('#trader-county-id').val('').trigger('change');
                $('#trader-email').val('');
                $('#trader-phone').val('');
                $('#trader-postal-address').val('');
                $('#trader-account-status').val('');
                $('#trader-admin-user').attr('disabled', false), // enable entire fieldset
                $('#trader-user-firstname').val('');
                $('#trader-user-lastname').val('');
                $('#trader-user-email').val('');
                $('#trader-user-phone').val('');
                $('#trader-user-username').val('');
                $('#trader-user-password').val('');
                $('#trader-user-password-confirm').val('');
                // $('#trader-preferred-regions').val('').trigger('change');
                $('#modal-title').html("Add Organisation");
                $('#crud-modal').modal('show');
            });

            // edit
            $('body').on('click', '#edit-trader', function (e) {
                e.preventDefault();

                var trader_id = $(this).data('id');

                $.get('traders/' + trader_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit Organisation");
                    $('#modal-save').val("edit-trader");

                    $('#trader-id').val(data.id);
                    $('#trader-organisation-name').val(data.organisation_name);
                    $('#trader-type-id').val(data.type_id).trigger('change');
                    $('#trader-region-id').val(data.region_id).trigger('change');
                    $('#trader-county-id').val(data.county_id).trigger('change');
                    $('#trader-email').val(data.email);
                    $('#trader-phone').val(data.phone);
                    $('#trader-postal-address').val(data.postal_address);
                    //$('#trader-account-status').val(data.status);
                    // $('#trader-preferred-regions').val(data.preferred_regions).trigger('change');
                    $('#trader-admin-user').attr('disabled', true), // enable entire fieldset
                    $('#trader-user-firstname').val(data.user.firstname);
                    $('#trader-user-lastname').val(data.user.lastname);
                    $('#trader-user-email').val(data.user.email);
                    $('#trader-user-phone').val(data.user.phone);
                    $('#trader-user-username').val(data.user.username);
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-trader', function (e) {
                e.preventDefault();

                var trader_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    let table = $('#traders-list').DataTable();

                    $.ajax({
                        type: "DELETE",
                        url: 'traders/' + trader_id + '/delete-ajax',
                        success: function (data) {
                            table.row( $("#trader_id_" + trader_id) ).remove().draw();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // submit
            if ($("#trader-form").length > 0) {
                $("#trader-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/traders/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);
                                let fullname = data.user.firstname + ' ' + data.user.lastname;
                                let trader = '<tr id="trader_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.organisation_name + '</a></td>';
                                    trader += '<td>' + data.trader_type.name + '</td><td>' + data.email + '</td><td>' + data.phone + '</td><td>' + data.region.name + '</td><td>' + data.county.name + '</td><td>' + fullname + '</td>';
                                    trader += '<td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader += '<a id="edit-trader" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    trader += '<button id="delete-trader" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     trader
                                    // ]);

                                if (actionType == "create-trader") {
                                    $('#trader-list').prepend(trader);
                                } else {
                                    $("#trader_id_" + data.id).replaceWith(trader);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    <script type="text/javascript">
        function hasQueryString() {
            // get the current URL
            var currentUrl = window.location.href;
            // regex pattern for detecting ? character
            var pattern = new RegExp(/\?.+=.*/g);
            return pattern.test(currentUrl);
        }

        $( document ).ready(function() {
            if(hasQueryString()) {
                var urlParams = new URLSearchParams(location.search);
                let exportURL = $('#traders-export').attr('href');
                exportURL += '?' + urlParams.toString();
                $('#traders-export').attr('href', exportURL);

                $('#filter-panel').collapse("show");
                $("#filter-msg").removeClass('d-none');

                $('#filter-name').val(urlParams.get('name'));
                $('#filter-type').val(urlParams.get('type')).trigger('change');
                $('#filter-region').val(urlParams.get('region')).trigger('change');
                $('#filter-county').val(urlParams.get('county')).trigger('change');
            }
        });
    </script>
@endsection
