-- phpMyAdmin SQL Dump
-- version 4.9.0.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost
-- Generation Time: Jun 03, 2020 at 04:22 PM
-- Server version: 10.4.6-MariaDB
-- PHP Version: 7.2.22

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `twalisha_chamilo`
--

-- --------------------------------------------------------

--
-- Table structure for table `trading_additional_seasonal_produces`
--

CREATE TABLE `trading_additional_seasonal_produces` (
  `additional_id` bigint(20) UNSIGNED NOT NULL,
  `season_produce_id` bigint(20) UNSIGNED NOT NULL,
  `other_details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_administrators`
--

CREATE TABLE `trading_administrators` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_contract_details`
--

CREATE TABLE `trading_contract_details` (
  `id` int(10) UNSIGNED NOT NULL,
  `contract_id` int(10) UNSIGNED NOT NULL,
  `produce_item_id` int(10) UNSIGNED NOT NULL,
  `tonnage` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_counties`
--

CREATE TABLE `trading_counties` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_credits`
--

CREATE TABLE `trading_credits` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(11) NOT NULL,
  `input_order_item_id` int(10) UNSIGNED NOT NULL,
  `requested_amount` decimal(13,4) NOT NULL,
  `credited_amount` decimal(13,4) DEFAULT NULL,
  `payable_amount` decimal(13,4) DEFAULT NULL,
  `balance` decimal(13,4) DEFAULT NULL,
  `period` int(11) DEFAULT NULL,
  `approved` int(11) NOT NULL DEFAULT 0,
  `cleared` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_credit_clearings`
--

CREATE TABLE `trading_credit_clearings` (
  `id` int(10) UNSIGNED NOT NULL,
  `credit_id` int(10) UNSIGNED NOT NULL,
  `amount` decimal(13,4) UNSIGNED NOT NULL,
  `source` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_credit_transactions`
--

CREATE TABLE `trading_credit_transactions` (
  `id` int(10) UNSIGNED NOT NULL,
  `credit_id` int(10) UNSIGNED NOT NULL,
  `amount` decimal(13,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_crop_calendars`
--

CREATE TABLE `trading_crop_calendars` (
  `crop_calendar_id` bigint(20) UNSIGNED NOT NULL,
  `event_type` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `specific_activity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_time` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `comments` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `farmer_id` int(10) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_crop_settings`
--

CREATE TABLE `trading_crop_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `crop` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_yield` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `variety` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `region` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `planting_method` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost_of_production` double(10,2) DEFAULT NULL,
  `market_price` double(10,2) DEFAULT NULL,
  `profit` double(10,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_deliveries`
--

CREATE TABLE `trading_deliveries` (
  `id` int(10) UNSIGNED NOT NULL,
  `driver_id` int(10) UNSIGNED DEFAULT NULL,
  `vehicle_id` int(10) UNSIGNED DEFAULT NULL,
  `produce_order_id` int(10) UNSIGNED DEFAULT NULL,
  `delivery_request_id` int(10) UNSIGNED DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Triggers `trading_deliveries`
--
DELIMITER $$
CREATE TRIGGER `releaseActors` AFTER UPDATE ON `trading_deliveries` FOR EACH ROW IF NEW.status = 2
        THEN UPDATE trading_vehicles SET trading_vehicles.status = 0
        WHERE trading_vehicles.id = NEW.vehicle_id;
        UPDATE trading_drivers SET trading_drivers.status = 0
        WHERE trading_drivers.id = NEW.driver_id;
        END IF
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `trading_delivery_acknowledgements`
--

CREATE TABLE `trading_delivery_acknowledgements` (
  `id` int(10) UNSIGNED NOT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delivery_id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `state_of_arrival` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_delivery_requests`
--

CREATE TABLE `trading_delivery_requests` (
  `id` int(10) UNSIGNED NOT NULL,
  `produce_order_id` int(10) UNSIGNED DEFAULT NULL,
  `transporter_id` int(10) UNSIGNED DEFAULT NULL,
  `picking_time` datetime NOT NULL,
  `delivery_time` datetime NOT NULL,
  `from_id` int(11) DEFAULT NULL,
  `to_id` int(11) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_drivers`
--

CREATE TABLE `trading_drivers` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `firstname` varchar(65) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname` varchar(65) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(65) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `licence_no` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `driver_class` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `experience` int(10) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_events`
--

CREATE TABLE `trading_events` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `end` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `classNames` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `trading_farmers`
--

CREATE TABLE `trading_farmers` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(11) NOT NULL,
  `middlename` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `national_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mpesa_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `education_level` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `acreage` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `acreage_farmed` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activities` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activities_crops` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activities_livestock` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `input_spending` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preferred_learning_language` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preferred_agrodealer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preferred_inputs` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_owned` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `computer_access` tinyint(1) DEFAULT 0,
  `computer_access_location` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internet_access` tinyint(1) DEFAULT 0,
  `internet_access_location` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_history` tinyint(1) DEFAULT 0,
  `credit_history_outstanding` tinyint(1) DEFAULT 0,
  `credit_history_outstanding_details` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_needs` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_farmer_busines_plans`
--

CREATE TABLE `trading_farmer_busines_plans` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `crop` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_yield` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `variety` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `market_price` double(10,2) NOT NULL,
  `profit` double(10,2) NOT NULL,
  `farmer_id` int(10) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_farmer_produce_aggregation`
--

CREATE TABLE `trading_farmer_produce_aggregation` (
  `id` int(10) UNSIGNED NOT NULL,
  `farmer_id` int(11) NOT NULL,
  `produce_item_id` int(10) UNSIGNED NOT NULL,
  `quantity` int(10) UNSIGNED NOT NULL,
  `price_per_unit` decimal(13,4) NOT NULL,
  `aggregated_by` int(11) NOT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT 0,
  `approved_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_farmer_soil_healths`
--

CREATE TABLE `trading_farmer_soil_healths` (
  `soil_health_id` bigint(20) UNSIGNED NOT NULL,
  `geolocation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `physical` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `chemical` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `biological` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `biometric` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `farmer_id` int(10) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_input`
--

CREATE TABLE `trading_input` (
  `id` int(10) UNSIGNED NOT NULL,
  `category_id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `listed` tinyint(1) NOT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_input_categories`
--

CREATE TABLE `trading_input_categories` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int(10) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_input_delivery_confirms`
--

CREATE TABLE `trading_input_delivery_confirms` (
  `id` int(10) UNSIGNED NOT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `input_order_items_release_id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `state_of_arrival` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_input_items`
--

CREATE TABLE `trading_input_items` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `input_id` int(10) UNSIGNED NOT NULL,
  `input_unit_id` int(10) UNSIGNED NOT NULL,
  `price_per_unit` double(8,2) NOT NULL,
  `listed` tinyint(1) NOT NULL DEFAULT 1,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_input_orders`
--

CREATE TABLE `trading_input_orders` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT 0,
  `total` double(8,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_input_order_items`
--

CREATE TABLE `trading_input_order_items` (
  `id` int(10) UNSIGNED NOT NULL,
  `order_id` int(10) UNSIGNED NOT NULL,
  `farmer_id` int(11) NOT NULL,
  `input_item_id` int(10) UNSIGNED NOT NULL,
  `quantity` int(11) NOT NULL,
  `expected_date` datetime NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `directed_to` int(10) UNSIGNED DEFAULT NULL,
  `financing` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` double(8,2) NOT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Triggers `trading_input_order_items`
--
DELIMITER $$
CREATE TRIGGER `addCreditReq` AFTER INSERT ON `trading_input_order_items` FOR EACH ROW IF NEW.financing = "credit"
        THEN
        INSERT INTO trading_credits SET
        trading_credits.user_id = NEW.farmer_id,
        trading_credits.input_order_item_id = NEW.id,
        trading_credits.requested_amount = NEW.price,
        trading_credits.created_at = NEW.created_at;
        END IF
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `updateWallet` AFTER UPDATE ON `trading_input_order_items` FOR EACH ROW IF NEW.approved = 2 
        THEN UPDATE trading_user_wallets SET
        trading_user_wallets.balance = trading_user_wallets.balance-NEW.price
        WHERE trading_user_wallets.user_id = NEW.farmer_id;
        END IF
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `trading_input_order_items_forwarded`
--

CREATE TABLE `trading_input_order_items_forwarded` (
  `id` int(10) UNSIGNED NOT NULL,
  `input_order_item_id` int(10) UNSIGNED NOT NULL,
  `forwarded_by` int(10) UNSIGNED NOT NULL,
  `forwarded_to` int(10) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_input_order_items_releases`
--

CREATE TABLE `trading_input_order_items_releases` (
  `id` int(10) UNSIGNED NOT NULL,
  `recipient` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `means` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` datetime NOT NULL,
  `order_id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_input_releases`
--

CREATE TABLE `trading_input_releases` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `input_order_item_id` int(10) UNSIGNED NOT NULL,
  `picked_by` varchar(65) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_no` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_input_units`
--

CREATE TABLE `trading_input_units` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abbreviation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_invoices`
--

CREATE TABLE `trading_invoices` (
  `id` int(10) UNSIGNED NOT NULL,
  `input_item_id` int(10) UNSIGNED DEFAULT NULL,
  `produce_order_id` int(10) UNSIGNED DEFAULT NULL,
  `number` int(11) DEFAULT NULL,
  `direction` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total` decimal(13,4) UNSIGNED DEFAULT NULL,
  `balance` decimal(13,4) UNSIGNED DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `directed_to` int(10) UNSIGNED DEFAULT NULL,
  `posted_by` int(11) NOT NULL,
  `date` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_invoice_payments`
--

CREATE TABLE `trading_invoice_payments` (
  `id` int(10) UNSIGNED NOT NULL,
  `invoice_id` int(10) UNSIGNED NOT NULL,
  `mode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(13,4) UNSIGNED DEFAULT NULL,
  `reference` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_i_v_r_s`
--

CREATE TABLE `trading_i_v_r_s` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `audio` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `farmer_id` int(10) UNSIGNED NOT NULL,
  `agent_id` int(10) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_livestocks`
--

CREATE TABLE `trading_livestocks` (
  `livestock_id` bigint(20) UNSIGNED NOT NULL,
  `animal` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `breed` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sex` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weight` double(10,2) NOT NULL,
  `age` double(10,2) NOT NULL,
  `disease_history` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `purpose` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `intake` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `yields` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tag_number` int(10) UNSIGNED NOT NULL,
  `agent_id` int(10) UNSIGNED NOT NULL,
  `farmer_id` int(10) UNSIGNED NOT NULL,
  `parent_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_messages`
--

CREATE TABLE `trading_messages` (
  `id` int(10) UNSIGNED NOT NULL,
  `sender_id` int(10) UNSIGNED NOT NULL,
  `recipient_id` int(10) UNSIGNED NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `channel` enum('SMS','EMAIL','INTERNAL') COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int(10) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_migrations`
--

CREATE TABLE `trading_migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_pictures`
--

CREATE TABLE `trading_pictures` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `soil_health_id` bigint(20) UNSIGNED NOT NULL,
  `picture_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_produce`
--

CREATE TABLE `trading_produce` (
  `id` int(10) UNSIGNED NOT NULL,
  `category_id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `listed` tinyint(1) NOT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_produce_categories`
--

CREATE TABLE `trading_produce_categories` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(10) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_produce_collections`
--

CREATE TABLE `trading_produce_collections` (
  `id` int(10) UNSIGNED NOT NULL,
  `contract_detail_id` int(10) UNSIGNED NOT NULL,
  `quantity` double(13,4) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `collected_by` int(11) NOT NULL,
  `approved_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_produce_items`
--

CREATE TABLE `trading_produce_items` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `produce_id` int(10) UNSIGNED NOT NULL,
  `produce_unit_id` int(10) UNSIGNED NOT NULL,
  `price_per_unit` decimal(13,4) NOT NULL DEFAULT 0.0000,
  `tonnage` int(11) NOT NULL,
  `quality` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT 1,
  `balance` decimal(13,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_produce_orders`
--

CREATE TABLE `trading_produce_orders` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT 0,
  `approved_by` int(11) DEFAULT NULL,
  `total` double(13,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_produce_order_items`
--

CREATE TABLE `trading_produce_order_items` (
  `id` int(10) UNSIGNED NOT NULL,
  `produce_order_id` int(10) UNSIGNED NOT NULL,
  `contract_id` int(10) UNSIGNED NOT NULL,
  `price_per_unit` decimal(13,4) NOT NULL,
  `quantity` int(11) NOT NULL,
  `expected_date` datetime DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_produce_units`
--

CREATE TABLE `trading_produce_units` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abbreviation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_production_costs`
--

CREATE TABLE `trading_production_costs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `input` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost` double(10,2) NOT NULL,
  `details` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `plan_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_regions`
--

CREATE TABLE `trading_regions` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_region_trader`
--

CREATE TABLE `trading_region_trader` (
  `id` int(10) UNSIGNED NOT NULL,
  `region_id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_seasons`
--

CREATE TABLE `trading_seasons` (
  `season_id` bigint(20) UNSIGNED NOT NULL,
  `season` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `year` int(10) UNSIGNED NOT NULL,
  `farmer_id` int(10) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_season_produces`
--

CREATE TABLE `trading_season_produces` (
  `season_produce_id` bigint(20) UNSIGNED NOT NULL,
  `produce_item_id` int(10) UNSIGNED NOT NULL,
  `season_id` bigint(20) UNSIGNED NOT NULL,
  `quality` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recommended_seed` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fertilizer` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pesticides` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sowing_date` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sowing_area` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `yield_estimation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `est_harvestdate` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_stocks`
--

CREATE TABLE `trading_stocks` (
  `id` int(10) UNSIGNED NOT NULL,
  `produce_item_id` int(10) UNSIGNED NOT NULL,
  `farmer_id` int(11) NOT NULL,
  `price` double(8,2) NOT NULL,
  `amount` double(8,2) NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_traders`
--

CREATE TABLE `trading_traders` (
  `id` int(10) UNSIGNED NOT NULL,
  `organisation_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(11) NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `physical_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitude` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `region_id` int(10) UNSIGNED DEFAULT NULL,
  `county_id` int(10) UNSIGNED DEFAULT NULL,
  `ward` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preferred_regions` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tonnage_per_year` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `destination_markets` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `special_terms` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_trader_activation_logs`
--

CREATE TABLE `trading_trader_activation_logs` (
  `id` int(10) UNSIGNED NOT NULL,
  `action_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comments` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` int(10) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_trader_agrodealers`
--

CREATE TABLE `trading_trader_agrodealers` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `trade_volume` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `input_program` tinyint(1) NOT NULL DEFAULT 0,
  `input_program_join` tinyint(1) NOT NULL DEFAULT 0,
  `assets` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_needs` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_owned` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `computer_access` tinyint(1) NOT NULL DEFAULT 0,
  `computer_access_location` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internet_access` tinyint(1) NOT NULL DEFAULT 0,
  `internet_access_location` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_trader_contacts`
--

CREATE TABLE `trading_trader_contacts` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `firstname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `is_admin` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_trader_contracts`
--

CREATE TABLE `trading_trader_contracts` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contract_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `produce_id` int(10) UNSIGNED NOT NULL,
  `produce_unit_id` int(10) UNSIGNED NOT NULL,
  `price_per_unit` decimal(13,4) NOT NULL,
  `tonnage` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_trader_farmer_organisations`
--

CREATE TABLE `trading_trader_farmer_organisations` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `input_buying` tinyint(1) NOT NULL DEFAULT 0,
  `input_buying_volume` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `input_buying_value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `input_buying_reason` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `input_buying_preference` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `produce_selling` tinyint(1) NOT NULL DEFAULT 0,
  `produce_selling_volume` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `produce_selling_reason` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `produce_selling_contracts` tinyint(1) NOT NULL DEFAULT 0,
  `produce_selling_preference` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_trader_input_sellers`
--

CREATE TABLE `trading_trader_input_sellers` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `extension_program` tinyint(1) NOT NULL DEFAULT 0,
  `credit_providers` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_trader_local_aggregators`
--

CREATE TABLE `trading_trader_local_aggregators` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `storage_capacity` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assets` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `computer_access` tinyint(1) NOT NULL DEFAULT 0,
  `computer_access_location` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internet_access` tinyint(1) NOT NULL DEFAULT 0,
  `internet_access_location` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_needs` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_trader_members`
--

CREATE TABLE `trading_trader_members` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(11) NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `type` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_trader_networks`
--

CREATE TABLE `trading_trader_networks` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `agrodealer_id` int(10) UNSIGNED NOT NULL,
  `type` enum('national','regional','last-mile') COLLATE utf8mb4_unicode_ci NOT NULL,
  `region_id` int(10) UNSIGNED DEFAULT NULL,
  `county_id` int(10) UNSIGNED DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_trader_settings`
--

CREATE TABLE `trading_trader_settings` (
  `id` int(10) UNSIGNED NOT NULL,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `locked` double NOT NULL,
  `credit_limit` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_trader_type`
--

CREATE TABLE `trading_trader_type` (
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_user_wallets`
--

CREATE TABLE `trading_user_wallets` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(11) NOT NULL,
  `balance` decimal(13,4) NOT NULL DEFAULT 0.0000,
  `float_bal` decimal(13,4) DEFAULT 0.0000,
  `locked_amount` decimal(13,4) DEFAULT 0.0000,
  `credit_limit` decimal(13,4) DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_user_wallet_transactions`
--

CREATE TABLE `trading_user_wallet_transactions` (
  `id` int(10) UNSIGNED NOT NULL,
  `amount` decimal(13,4) NOT NULL,
  `hash` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `user_wallet_id` int(10) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `trading_vehicles`
--

CREATE TABLE `trading_vehicles` (
  `id` int(10) UNSIGNED NOT NULL,
  `make` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tonnage` double(13,4) NOT NULL,
  `plate` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `trader_id` int(10) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

CREATE TABLE `user` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `username` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `username_canonical` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `email_canonical` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `locked` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `expired` tinyint(1) NOT NULL,
  `credentials_expired` tinyint(1) NOT NULL,
  `credentials_expire_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `lastname` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `firstname` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `salt` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `confirmation_token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password_requested_at` datetime DEFAULT NULL,
  `roles` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `profile_completed` tinyint(1) DEFAULT NULL,
  `auth_source` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `official_code` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `picture_uri` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `creator_id` int(11) DEFAULT NULL,
  `competences` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `diplomas` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `openarea` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `teach` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `productions` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `registration_date` datetime NOT NULL,
  `expiration_date` datetime DEFAULT NULL,
  `active` tinyint(1) NOT NULL,
  `openid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `theme` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hr_dept_id` smallint(6) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `trading_additional_seasonal_produces`
--
ALTER TABLE `trading_additional_seasonal_produces`
  ADD PRIMARY KEY (`additional_id`),
  ADD KEY `trading_additional_seasonal_produces_season_produce_id_foreign` (`season_produce_id`);

--
-- Indexes for table `trading_administrators`
--
ALTER TABLE `trading_administrators`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trading_contract_details`
--
ALTER TABLE `trading_contract_details`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_contract_details_contract_id_foreign` (`contract_id`),
  ADD KEY `trading_contract_details_produce_item_id_foreign` (`produce_item_id`);

--
-- Indexes for table `trading_counties`
--
ALTER TABLE `trading_counties`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trading_credits`
--
ALTER TABLE `trading_credits`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_credits_user_id_foreign` (`user_id`),
  ADD KEY `trading_credits_input_order_item_id_foreign` (`input_order_item_id`);

--
-- Indexes for table `trading_credit_clearings`
--
ALTER TABLE `trading_credit_clearings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_credits_id_foreign` (`credit_id`);

--
-- Indexes for table `trading_credit_transactions`
--
ALTER TABLE `trading_credit_transactions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_credits_credits_id_foreign` (`credit_id`);

--
-- Indexes for table `trading_crop_calendars`
--
ALTER TABLE `trading_crop_calendars`
  ADD PRIMARY KEY (`crop_calendar_id`),
  ADD KEY `trading_crop_calendars_farmer_id_foreign` (`farmer_id`);

--
-- Indexes for table `trading_crop_settings`
--
ALTER TABLE `trading_crop_settings`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trading_deliveries`
--
ALTER TABLE `trading_deliveries`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_driver_id_foreign` (`driver_id`),
  ADD KEY `trading_vehicle_id_foreign` (`vehicle_id`),
  ADD KEY `trading_delivery_produce_order_id_foreign` (`produce_order_id`),
  ADD KEY `trading_deliveries_request_id_foreign` (`delivery_request_id`);

--
-- Indexes for table `trading_delivery_acknowledgements`
--
ALTER TABLE `trading_delivery_acknowledgements`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_acknowledging_trader_id_foreign` (`trader_id`),
  ADD KEY `trading_acknowledging_delivery_id_foreign` (`delivery_id`);

--
-- Indexes for table `trading_delivery_requests`
--
ALTER TABLE `trading_delivery_requests`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_delivery_requests_produce_order_id_foreign` (`produce_order_id`),
  ADD KEY `trading_delivery_requests_trader_id_foreign` (`transporter_id`);

--
-- Indexes for table `trading_drivers`
--
ALTER TABLE `trading_drivers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_trader_driver_trader_id_foreign` (`trader_id`),
  ADD KEY `trading_trader_driver_user_id_foreign` (`user_id`);

--
-- Indexes for table `trading_events`
--
ALTER TABLE `trading_events`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trading_farmers`
--
ALTER TABLE `trading_farmers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_farmers_user_id_foreign` (`user_id`);

--
-- Indexes for table `trading_farmer_busines_plans`
--
ALTER TABLE `trading_farmer_busines_plans`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_farmer_busines_plans_farmer_id_foreign` (`farmer_id`);

--
-- Indexes for table `trading_farmer_produce_aggregation`
--
ALTER TABLE `trading_farmer_produce_aggregation`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_farmer_produce_aggregation_farmer_id_foreign` (`farmer_id`),
  ADD KEY `trading_farmer_produce_aggregation_produce_item_id_foreign` (`produce_item_id`),
  ADD KEY `trading_farmer_produce_aggregation_aggregated_by_foreign` (`aggregated_by`),
  ADD KEY `trading_farmer_produce_aggregation_approved_by_foreign` (`approved_by`);

--
-- Indexes for table `trading_farmer_soil_healths`
--
ALTER TABLE `trading_farmer_soil_healths`
  ADD PRIMARY KEY (`soil_health_id`),
  ADD KEY `trading_farmer_soil_healths_farmer_id_foreign` (`farmer_id`);

--
-- Indexes for table `trading_input`
--
ALTER TABLE `trading_input`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_input_category_id_foreign` (`category_id`);

--
-- Indexes for table `trading_input_categories`
--
ALTER TABLE `trading_input_categories`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_input_parent_id_foreign` (`parent_id`);

--
-- Indexes for table `trading_input_delivery_confirms`
--
ALTER TABLE `trading_input_delivery_confirms`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_input_delivery_confirms_trader_id_foreign` (`trader_id`),
  ADD KEY `trading_input_delivery_confirms_release_id_foreign` (`input_order_items_release_id`);

--
-- Indexes for table `trading_input_items`
--
ALTER TABLE `trading_input_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_input_items_trader_id_foreign` (`trader_id`),
  ADD KEY `trading_input_items_input_id_foreign` (`input_id`),
  ADD KEY `trading_input_items_input_unit_id_foreign` (`input_unit_id`);

--
-- Indexes for table `trading_input_orders`
--
ALTER TABLE `trading_input_orders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_input_orders_trader_id_foreign` (`trader_id`);

--
-- Indexes for table `trading_input_order_items`
--
ALTER TABLE `trading_input_order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_input_order_items_order_id_foreign` (`order_id`),
  ADD KEY `trading_input_order_items_input_id_foreign` (`input_item_id`),
  ADD KEY `trading_input_order_items_farmer_id_foreign` (`farmer_id`),
  ADD KEY `trading_input_order_trader_id_foreign` (`directed_to`);

--
-- Indexes for table `trading_input_order_items_forwarded`
--
ALTER TABLE `trading_input_order_items_forwarded`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_input_order_items_forwarded_input_order_item_id_foreign` (`input_order_item_id`);

--
-- Indexes for table `trading_input_order_items_releases`
--
ALTER TABLE `trading_input_order_items_releases`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_input_order_items_releases_order_id_foreign` (`order_id`),
  ADD KEY `trading_input_order_items_releases_trader_id_foreign` (`trader_id`);

--
-- Indexes for table `trading_input_releases`
--
ALTER TABLE `trading_input_releases`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_input_order_item_id_foreign` (`input_order_item_id`);

--
-- Indexes for table `trading_input_units`
--
ALTER TABLE `trading_input_units`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trading_invoices`
--
ALTER TABLE `trading_invoices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_invoices_input_item_id_foreign` (`input_item_id`),
  ADD KEY `trading_invoices_produce_order_id_foreign` (`produce_order_id`),
  ADD KEY `trading_invoices_directed_to_foreign` (`directed_to`);

--
-- Indexes for table `trading_invoice_payments`
--
ALTER TABLE `trading_invoice_payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_invoice_payments_invoice_id_foreign` (`invoice_id`);

--
-- Indexes for table `trading_i_v_r_s`
--
ALTER TABLE `trading_i_v_r_s`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_i_v_r_s_farmer_id_foreign` (`farmer_id`);

--
-- Indexes for table `trading_livestocks`
--
ALTER TABLE `trading_livestocks`
  ADD PRIMARY KEY (`livestock_id`),
  ADD KEY `trading_livestocks_farmer_id_foreign` (`farmer_id`),
  ADD KEY `trading_livestocks_parent_id_foreign` (`parent_id`);

--
-- Indexes for table `trading_messages`
--
ALTER TABLE `trading_messages`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trading_migrations`
--
ALTER TABLE `trading_migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trading_pictures`
--
ALTER TABLE `trading_pictures`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_pictures_soil_health_id_foreign` (`soil_health_id`);

--
-- Indexes for table `trading_produce`
--
ALTER TABLE `trading_produce`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_produce_category_id_foreign` (`category_id`);

--
-- Indexes for table `trading_produce_categories`
--
ALTER TABLE `trading_produce_categories`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_produce_categories_parent_id_foreign` (`parent_id`);

--
-- Indexes for table `trading_produce_collections`
--
ALTER TABLE `trading_produce_collections`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_produce_collections_contract_detail_id_foreign` (`contract_detail_id`),
  ADD KEY `trading_produce_collections_collected_by_foreign` (`collected_by`),
  ADD KEY `trading_produce_collections_approved_by_foreign` (`approved_by`);

--
-- Indexes for table `trading_produce_items`
--
ALTER TABLE `trading_produce_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_produce_items_trader_id_foreign` (`trader_id`),
  ADD KEY `trading_produce_items_produce_id_foreign` (`produce_id`),
  ADD KEY `trading_produce_items_produce_unit_id_foreign` (`produce_unit_id`);

--
-- Indexes for table `trading_produce_orders`
--
ALTER TABLE `trading_produce_orders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_produce_orders_trader_id_foreign` (`trader_id`),
  ADD KEY `trading_produce_orders_approved_by_foreign` (`approved_by`);

--
-- Indexes for table `trading_produce_order_items`
--
ALTER TABLE `trading_produce_order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_produce_order_items_produce_order_id_foreign` (`produce_order_id`),
  ADD KEY `trading_produce_order_items_contract_id_foreign` (`contract_id`);

--
-- Indexes for table `trading_produce_units`
--
ALTER TABLE `trading_produce_units`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trading_production_costs`
--
ALTER TABLE `trading_production_costs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_production_costs_plan_id_foreign` (`plan_id`);

--
-- Indexes for table `trading_regions`
--
ALTER TABLE `trading_regions`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trading_region_trader`
--
ALTER TABLE `trading_region_trader`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_region_trader_region_id_foreign` (`region_id`),
  ADD KEY `trading_region_trader_trader_id_foreign` (`trader_id`);

--
-- Indexes for table `trading_seasons`
--
ALTER TABLE `trading_seasons`
  ADD PRIMARY KEY (`season_id`),
  ADD KEY `trading_seasons_farmer_id_foreign` (`farmer_id`);

--
-- Indexes for table `trading_season_produces`
--
ALTER TABLE `trading_season_produces`
  ADD PRIMARY KEY (`season_produce_id`),
  ADD KEY `trading_season_produces_produce_item_id_foreign` (`produce_item_id`),
  ADD KEY `trading_season_produces_season_id_foreign` (`season_id`);

--
-- Indexes for table `trading_stocks`
--
ALTER TABLE `trading_stocks`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_stocks_farmer_id_foreign` (`farmer_id`),
  ADD KEY `trading_stocks_produce_item_id_foreign` (`produce_item_id`);

--
-- Indexes for table `trading_traders`
--
ALTER TABLE `trading_traders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_trader_user_id_foreign` (`user_id`),
  ADD KEY `trading_trader_type_id_foreign` (`type_id`);

--
-- Indexes for table `trading_trader_activation_logs`
--
ALTER TABLE `trading_trader_activation_logs`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trading_trader_agrodealers`
--
ALTER TABLE `trading_trader_agrodealers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_trader_agrodealers_trader_id_foreign` (`trader_id`);

--
-- Indexes for table `trading_trader_contacts`
--
ALTER TABLE `trading_trader_contacts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_trader_contacts_trader_id_foreign` (`trader_id`),
  ADD KEY `trading_trader_contacts_user_id_foreign` (`user_id`);

--
-- Indexes for table `trading_trader_contracts`
--
ALTER TABLE `trading_trader_contracts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_trader_contracts_trader_id_foreign` (`trader_id`),
  ADD KEY `trading_trader_contracts_produce_id_foreign` (`produce_id`),
  ADD KEY `trading_trader_contracts_produce_unit_id_foreign` (`produce_unit_id`);

--
-- Indexes for table `trading_trader_farmer_organisations`
--
ALTER TABLE `trading_trader_farmer_organisations`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_trader_farmer_organisations_trader_id_foreign` (`trader_id`);

--
-- Indexes for table `trading_trader_input_sellers`
--
ALTER TABLE `trading_trader_input_sellers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_trader_input_sellers_trader_id_foreign` (`trader_id`);

--
-- Indexes for table `trading_trader_local_aggregators`
--
ALTER TABLE `trading_trader_local_aggregators`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_trader_local_aggregators_trader_id_foreign` (`trader_id`);

--
-- Indexes for table `trading_trader_members`
--
ALTER TABLE `trading_trader_members`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_trader_members_user_id_foreign` (`user_id`),
  ADD KEY `trading_trader_members_trader_id_foreign` (`trader_id`);

--
-- Indexes for table `trading_trader_networks`
--
ALTER TABLE `trading_trader_networks`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `trading_trader_networks_trader_id_agrodealer_id_unique` (`trader_id`,`agrodealer_id`),
  ADD KEY `trading_trader_networks_agrodealer_id_foreign` (`agrodealer_id`),
  ADD KEY `trading_trader_networks_region_id_foreign` (`region_id`),
  ADD KEY `trading_trader_networks_county_id_foreign` (`county_id`);

--
-- Indexes for table `trading_trader_settings`
--
ALTER TABLE `trading_trader_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_trader_settings_trader_id_foreign` (`trader_id`);

--
-- Indexes for table `trading_trader_type`
--
ALTER TABLE `trading_trader_type`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `trading_user_wallets`
--
ALTER TABLE `trading_user_wallets`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_user_wallets_user_id_foreign` (`user_id`);

--
-- Indexes for table `trading_user_wallet_transactions`
--
ALTER TABLE `trading_user_wallet_transactions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_user_wallet_transactions_user_wallet_id_foreign` (`user_wallet_id`);

--
-- Indexes for table `trading_vehicles`
--
ALTER TABLE `trading_vehicles`
  ADD PRIMARY KEY (`id`),
  ADD KEY `trading_vehicle_trader_id_foreign` (`trader_id`);

--
-- Indexes for table `user`
--
ALTER TABLE `user`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `UNIQ_8D93D649F85E0677` (`username`),
  ADD KEY `idx_user_uid` (`user_id`),
  ADD KEY `status` (`status`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `trading_additional_seasonal_produces`
--
ALTER TABLE `trading_additional_seasonal_produces`
  MODIFY `additional_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_administrators`
--
ALTER TABLE `trading_administrators`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_contract_details`
--
ALTER TABLE `trading_contract_details`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_counties`
--
ALTER TABLE `trading_counties`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_credits`
--
ALTER TABLE `trading_credits`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_credit_clearings`
--
ALTER TABLE `trading_credit_clearings`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_credit_transactions`
--
ALTER TABLE `trading_credit_transactions`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_crop_calendars`
--
ALTER TABLE `trading_crop_calendars`
  MODIFY `crop_calendar_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_crop_settings`
--
ALTER TABLE `trading_crop_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_deliveries`
--
ALTER TABLE `trading_deliveries`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_delivery_acknowledgements`
--
ALTER TABLE `trading_delivery_acknowledgements`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_delivery_requests`
--
ALTER TABLE `trading_delivery_requests`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_drivers`
--
ALTER TABLE `trading_drivers`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_events`
--
ALTER TABLE `trading_events`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_farmers`
--
ALTER TABLE `trading_farmers`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_farmer_busines_plans`
--
ALTER TABLE `trading_farmer_busines_plans`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_farmer_produce_aggregation`
--
ALTER TABLE `trading_farmer_produce_aggregation`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_farmer_soil_healths`
--
ALTER TABLE `trading_farmer_soil_healths`
  MODIFY `soil_health_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_input`
--
ALTER TABLE `trading_input`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_input_categories`
--
ALTER TABLE `trading_input_categories`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_input_delivery_confirms`
--
ALTER TABLE `trading_input_delivery_confirms`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_input_items`
--
ALTER TABLE `trading_input_items`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_input_orders`
--
ALTER TABLE `trading_input_orders`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_input_order_items`
--
ALTER TABLE `trading_input_order_items`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_input_order_items_forwarded`
--
ALTER TABLE `trading_input_order_items_forwarded`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_input_order_items_releases`
--
ALTER TABLE `trading_input_order_items_releases`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_input_releases`
--
ALTER TABLE `trading_input_releases`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_input_units`
--
ALTER TABLE `trading_input_units`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_invoices`
--
ALTER TABLE `trading_invoices`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_invoice_payments`
--
ALTER TABLE `trading_invoice_payments`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_i_v_r_s`
--
ALTER TABLE `trading_i_v_r_s`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_livestocks`
--
ALTER TABLE `trading_livestocks`
  MODIFY `livestock_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_messages`
--
ALTER TABLE `trading_messages`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_migrations`
--
ALTER TABLE `trading_migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_pictures`
--
ALTER TABLE `trading_pictures`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_produce`
--
ALTER TABLE `trading_produce`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_produce_categories`
--
ALTER TABLE `trading_produce_categories`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_produce_collections`
--
ALTER TABLE `trading_produce_collections`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_produce_items`
--
ALTER TABLE `trading_produce_items`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_produce_orders`
--
ALTER TABLE `trading_produce_orders`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_produce_order_items`
--
ALTER TABLE `trading_produce_order_items`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_produce_units`
--
ALTER TABLE `trading_produce_units`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_production_costs`
--
ALTER TABLE `trading_production_costs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_regions`
--
ALTER TABLE `trading_regions`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_region_trader`
--
ALTER TABLE `trading_region_trader`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_seasons`
--
ALTER TABLE `trading_seasons`
  MODIFY `season_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_season_produces`
--
ALTER TABLE `trading_season_produces`
  MODIFY `season_produce_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_stocks`
--
ALTER TABLE `trading_stocks`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_traders`
--
ALTER TABLE `trading_traders`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_trader_activation_logs`
--
ALTER TABLE `trading_trader_activation_logs`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_trader_agrodealers`
--
ALTER TABLE `trading_trader_agrodealers`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_trader_contacts`
--
ALTER TABLE `trading_trader_contacts`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_trader_contracts`
--
ALTER TABLE `trading_trader_contracts`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_trader_farmer_organisations`
--
ALTER TABLE `trading_trader_farmer_organisations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_trader_input_sellers`
--
ALTER TABLE `trading_trader_input_sellers`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_trader_local_aggregators`
--
ALTER TABLE `trading_trader_local_aggregators`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_trader_members`
--
ALTER TABLE `trading_trader_members`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_trader_networks`
--
ALTER TABLE `trading_trader_networks`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_trader_type`
--
ALTER TABLE `trading_trader_type`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_user_wallets`
--
ALTER TABLE `trading_user_wallets`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_user_wallet_transactions`
--
ALTER TABLE `trading_user_wallet_transactions`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `trading_vehicles`
--
ALTER TABLE `trading_vehicles`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user`
--
ALTER TABLE `user`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `trading_additional_seasonal_produces`
--
ALTER TABLE `trading_additional_seasonal_produces`
  ADD CONSTRAINT `trading_additional_seasonal_produces_season_produce_id_foreign` FOREIGN KEY (`season_produce_id`) REFERENCES `trading_season_produces` (`season_produce_id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_contract_details`
--
ALTER TABLE `trading_contract_details`
  ADD CONSTRAINT `trading_contract_details_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `trading_trader_contracts` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_contract_details_produce_item_id_foreign` FOREIGN KEY (`produce_item_id`) REFERENCES `trading_produce_items` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_credits`
--
ALTER TABLE `trading_credits`
  ADD CONSTRAINT `trading_credits_input_order_item_id_foreign` FOREIGN KEY (`input_order_item_id`) REFERENCES `trading_input_order_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_credits_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `trading_credit_clearings`
--
ALTER TABLE `trading_credit_clearings`
  ADD CONSTRAINT `trading_credits_id_foreign` FOREIGN KEY (`credit_id`) REFERENCES `trading_credits` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `trading_credit_transactions`
--
ALTER TABLE `trading_credit_transactions`
  ADD CONSTRAINT `trading_credits_credits_id_foreign` FOREIGN KEY (`credit_id`) REFERENCES `trading_credits` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `trading_crop_calendars`
--
ALTER TABLE `trading_crop_calendars`
  ADD CONSTRAINT `trading_crop_calendars_farmer_id_foreign` FOREIGN KEY (`farmer_id`) REFERENCES `trading_farmers` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_deliveries`
--
ALTER TABLE `trading_deliveries`
  ADD CONSTRAINT `trading_deliveries_request_id_foreign` FOREIGN KEY (`delivery_request_id`) REFERENCES `trading_delivery_requests` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_delivery_produce_order_id_foreign` FOREIGN KEY (`produce_order_id`) REFERENCES `trading_produce_orders` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_driver_id_foreign` FOREIGN KEY (`driver_id`) REFERENCES `trading_drivers` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_vehicle_id_foreign` FOREIGN KEY (`vehicle_id`) REFERENCES `trading_vehicles` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_delivery_acknowledgements`
--
ALTER TABLE `trading_delivery_acknowledgements`
  ADD CONSTRAINT `trading_acknowledging_delivery_id_foreign` FOREIGN KEY (`delivery_id`) REFERENCES `trading_deliveries` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_acknowledging_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_delivery_requests`
--
ALTER TABLE `trading_delivery_requests`
  ADD CONSTRAINT `trading_delivery_requests_produce_order_id_foreign` FOREIGN KEY (`produce_order_id`) REFERENCES `trading_produce_orders` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_delivery_requests_trader_id_foreign` FOREIGN KEY (`transporter_id`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_drivers`
--
ALTER TABLE `trading_drivers`
  ADD CONSTRAINT `trading_trader_driver_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_trader_driver_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_farmers`
--
ALTER TABLE `trading_farmers`
  ADD CONSTRAINT `trading_farmers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_farmer_busines_plans`
--
ALTER TABLE `trading_farmer_busines_plans`
  ADD CONSTRAINT `trading_farmer_busines_plans_farmer_id_foreign` FOREIGN KEY (`farmer_id`) REFERENCES `trading_farmers` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_farmer_produce_aggregation`
--
ALTER TABLE `trading_farmer_produce_aggregation`
  ADD CONSTRAINT `trading_farmer_produce_aggregation_aggregated_by_foreign` FOREIGN KEY (`aggregated_by`) REFERENCES `user` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_farmer_produce_aggregation_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `user` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_farmer_produce_aggregation_farmer_id_foreign` FOREIGN KEY (`farmer_id`) REFERENCES `user` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_farmer_produce_aggregation_produce_item_id_foreign` FOREIGN KEY (`produce_item_id`) REFERENCES `trading_produce_items` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_farmer_soil_healths`
--
ALTER TABLE `trading_farmer_soil_healths`
  ADD CONSTRAINT `trading_farmer_soil_healths_farmer_id_foreign` FOREIGN KEY (`farmer_id`) REFERENCES `trading_farmers` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_input`
--
ALTER TABLE `trading_input`
  ADD CONSTRAINT `trading_input_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `trading_input_categories` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_input_categories`
--
ALTER TABLE `trading_input_categories`
  ADD CONSTRAINT `trading_input_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `trading_input_categories` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_input_delivery_confirms`
--
ALTER TABLE `trading_input_delivery_confirms`
  ADD CONSTRAINT `trading_input_delivery_confirms_release_id_foreign` FOREIGN KEY (`input_order_items_release_id`) REFERENCES `trading_input_order_items_releases` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_input_delivery_confirms_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_input_items`
--
ALTER TABLE `trading_input_items`
  ADD CONSTRAINT `trading_input_items_input_id_foreign` FOREIGN KEY (`input_id`) REFERENCES `trading_input` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `trading_input_items_input_unit_id_foreign` FOREIGN KEY (`input_unit_id`) REFERENCES `trading_input_units` (`id`),
  ADD CONSTRAINT `trading_input_items_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `trading_input_orders`
--
ALTER TABLE `trading_input_orders`
  ADD CONSTRAINT `trading_input_orders_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_input_order_items`
--
ALTER TABLE `trading_input_order_items`
  ADD CONSTRAINT `trading_input_order_items_farmer_id_foreign` FOREIGN KEY (`farmer_id`) REFERENCES `user` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_input_order_items_input_id_foreign` FOREIGN KEY (`input_item_id`) REFERENCES `trading_input_items` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_input_order_items_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `trading_input_orders` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_input_order_trader_id_foreign` FOREIGN KEY (`directed_to`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_input_order_items_forwarded`
--
ALTER TABLE `trading_input_order_items_forwarded`
  ADD CONSTRAINT `trading_input_order_items_forwarded_input_order_item_id_foreign` FOREIGN KEY (`input_order_item_id`) REFERENCES `trading_input_order_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `trading_input_order_items_releases`
--
ALTER TABLE `trading_input_order_items_releases`
  ADD CONSTRAINT `trading_input_order_items_releases_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `trading_input_orders` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_input_order_items_releases_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_input_releases`
--
ALTER TABLE `trading_input_releases`
  ADD CONSTRAINT `trading_input_order_item_id_foreign` FOREIGN KEY (`input_order_item_id`) REFERENCES `trading_input_order_items` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_invoices`
--
ALTER TABLE `trading_invoices`
  ADD CONSTRAINT `trading_invoices_directed_to_foreign` FOREIGN KEY (`directed_to`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_invoices_input_item_id_foreign` FOREIGN KEY (`input_item_id`) REFERENCES `trading_input_order_items` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_invoices_produce_order_id_foreign` FOREIGN KEY (`produce_order_id`) REFERENCES `trading_produce_orders` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_invoice_payments`
--
ALTER TABLE `trading_invoice_payments`
  ADD CONSTRAINT `trading_invoice_payments_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `trading_invoices` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_i_v_r_s`
--
ALTER TABLE `trading_i_v_r_s`
  ADD CONSTRAINT `trading_i_v_r_s_farmer_id_foreign` FOREIGN KEY (`farmer_id`) REFERENCES `trading_farmers` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_livestocks`
--
ALTER TABLE `trading_livestocks`
  ADD CONSTRAINT `trading_livestocks_farmer_id_foreign` FOREIGN KEY (`farmer_id`) REFERENCES `trading_farmers` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_livestocks_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `trading_livestocks` (`livestock_id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_pictures`
--
ALTER TABLE `trading_pictures`
  ADD CONSTRAINT `trading_pictures_soil_health_id_foreign` FOREIGN KEY (`soil_health_id`) REFERENCES `trading_farmer_soil_healths` (`soil_health_id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_produce`
--
ALTER TABLE `trading_produce`
  ADD CONSTRAINT `trading_produce_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `trading_produce_categories` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_produce_categories`
--
ALTER TABLE `trading_produce_categories`
  ADD CONSTRAINT `trading_produce_categories_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `trading_produce_categories` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_produce_collections`
--
ALTER TABLE `trading_produce_collections`
  ADD CONSTRAINT `trading_produce_collections_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `user` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_produce_collections_collected_by_foreign` FOREIGN KEY (`collected_by`) REFERENCES `user` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_produce_collections_contract_detail_id_foreign` FOREIGN KEY (`contract_detail_id`) REFERENCES `trading_contract_details` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_produce_items`
--
ALTER TABLE `trading_produce_items`
  ADD CONSTRAINT `trading_produce_items_produce_id_foreign` FOREIGN KEY (`produce_id`) REFERENCES `trading_produce` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `trading_produce_items_produce_unit_id_foreign` FOREIGN KEY (`produce_unit_id`) REFERENCES `trading_produce_units` (`id`),
  ADD CONSTRAINT `trading_produce_items_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `trading_produce_orders`
--
ALTER TABLE `trading_produce_orders`
  ADD CONSTRAINT `trading_produce_orders_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `user` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_produce_orders_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_produce_order_items`
--
ALTER TABLE `trading_produce_order_items`
  ADD CONSTRAINT `trading_produce_order_items_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `trading_trader_contracts` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_produce_order_items_produce_order_id_foreign` FOREIGN KEY (`produce_order_id`) REFERENCES `trading_produce_orders` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_production_costs`
--
ALTER TABLE `trading_production_costs`
  ADD CONSTRAINT `trading_production_costs_plan_id_foreign` FOREIGN KEY (`plan_id`) REFERENCES `trading_farmer_busines_plans` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_region_trader`
--
ALTER TABLE `trading_region_trader`
  ADD CONSTRAINT `trading_region_trader_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `trading_regions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `trading_region_trader_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `trading_seasons`
--
ALTER TABLE `trading_seasons`
  ADD CONSTRAINT `trading_seasons_farmer_id_foreign` FOREIGN KEY (`farmer_id`) REFERENCES `trading_farmers` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_season_produces`
--
ALTER TABLE `trading_season_produces`
  ADD CONSTRAINT `trading_season_produces_produce_item_id_foreign` FOREIGN KEY (`produce_item_id`) REFERENCES `trading_produce_items` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_season_produces_season_id_foreign` FOREIGN KEY (`season_id`) REFERENCES `trading_seasons` (`season_id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_stocks`
--
ALTER TABLE `trading_stocks`
  ADD CONSTRAINT `trading_stocks_farmer_id_foreign` FOREIGN KEY (`farmer_id`) REFERENCES `user` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_stocks_produce_item_id_foreign` FOREIGN KEY (`produce_item_id`) REFERENCES `trading_produce_items` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_trader_agrodealers`
--
ALTER TABLE `trading_trader_agrodealers`
  ADD CONSTRAINT `trading_trader_agrodealers_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `trading_trader_contacts`
--
ALTER TABLE `trading_trader_contacts`
  ADD CONSTRAINT `trading_trader_contacts_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_trader_contacts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `trading_trader_contracts`
--
ALTER TABLE `trading_trader_contracts`
  ADD CONSTRAINT `trading_trader_contracts_produce_id_foreign` FOREIGN KEY (`produce_id`) REFERENCES `trading_produce` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_trader_contracts_produce_unit_id_foreign` FOREIGN KEY (`produce_unit_id`) REFERENCES `trading_produce_units` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_trader_contracts_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_trader_farmer_organisations`
--
ALTER TABLE `trading_trader_farmer_organisations`
  ADD CONSTRAINT `trading_trader_farmer_organisations_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `trading_trader_input_sellers`
--
ALTER TABLE `trading_trader_input_sellers`
  ADD CONSTRAINT `trading_trader_input_sellers_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `trading_trader_local_aggregators`
--
ALTER TABLE `trading_trader_local_aggregators`
  ADD CONSTRAINT `trading_trader_local_aggregators_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `trading_trader_members`
--
ALTER TABLE `trading_trader_members`
  ADD CONSTRAINT `trading_trader_members_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_trader_members_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_trader_networks`
--
ALTER TABLE `trading_trader_networks`
  ADD CONSTRAINT `trading_trader_networks_agrodealer_id_foreign` FOREIGN KEY (`agrodealer_id`) REFERENCES `trading_traders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_trader_networks_county_id_foreign` FOREIGN KEY (`county_id`) REFERENCES `trading_counties` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_trader_networks_region_id_foreign` FOREIGN KEY (`region_id`) REFERENCES `trading_regions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `trading_trader_networks_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `trading_trader_settings`
--
ALTER TABLE `trading_trader_settings`
  ADD CONSTRAINT `trading_trader_settings_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `trading_user_wallets`
--
ALTER TABLE `trading_user_wallets`
  ADD CONSTRAINT `trading_user_wallets_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_user_wallet_transactions`
--
ALTER TABLE `trading_user_wallet_transactions`
  ADD CONSTRAINT `trading_user_wallet_transactions_user_wallet_id_foreign` FOREIGN KEY (`user_wallet_id`) REFERENCES `trading_user_wallets` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `trading_vehicles`
--
ALTER TABLE `trading_vehicles`
  ADD CONSTRAINT `trading_vehicle_trader_id_foreign` FOREIGN KEY (`trader_id`) REFERENCES `trading_traders` (`id`) ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
