<?php
    if(Auth::user()->isAdmin()) {
        $layout = 'layouts.admin';
    } elseif(Auth::user()->getRelatedTrader()->isBulkSeller()) {
        $layout = 'layouts.s';
    } elseif(Auth::user()->getRelatedTrader()->isBulkBuyer()) {
        $layout = 'layouts.b';
    } elseif(Auth::user()->getRelatedTrader()->isAgroDealer()) {
        $layout = 'layouts.ad';
    } elseif(Auth::user()->getRelatedTrader()->isTransporter()) {
        $layout = 'layouts.t';
    } elseif(Auth::user()->getRelatedTrader()->isFarmerOrganisation()) {
        $layout = 'layouts.fo';
    }
?>


<?php $__env->startSection('title'); ?>
    Twalisha Trading | Organisation Settings - <?php echo e($trader->organisation_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Organisation Settings- <?php echo e($trader->organisation_name); ?></h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#"><?php echo e($trader->organisation_name); ?> Settings</a>
            </li>
            
        </ul>

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                
                                <li class="nav-item">
                                    <a class="nav-link active" id="locked_savings-tab" data-toggle="tab" href="#lockedsavings" role="tab" aria-controls="profile" aria-selected="true"><i class="far fa-building"></i> Locked Savings</a>
                                </li>

                                
                                <li class="nav-item">
                                    <a class="nav-link" id="credit_limit-tab" data-toggle="tab" href="#creditlimit" role="tab" aria-controls="contacts" aria-selected="false"><i class="fas fa-users"></i> Credit Limit</a>
                                </li>


                            </ul>
                            <div class="tab-content" id="myTabContent">
                                
                                <div id="lockedsavings" role="tabpanel" aria-labelledby="locked_savings-tab" class="tab-pane fade show active">
                                    <form  action="<?php echo e(url('/lockedlimit/'.$mysettings[0]['id'])); ?>" method="post" >
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <label for="locked">Lockings (%)</label>
                                            <input type="text" name="locked" id="locked" value="<?php echo e($mysettings[0]['locked']); ?>" class="form-control <?php echo e($errors->has('locked') ? 'is-invalid' : ''); ?>" placeholder="Lockings %" readonly>

                                            <?php if($errors->has('locked')): ?>
                                                <div class="invalid-feedback">
                                                    <strong><?php echo e($errors->first('locked')); ?></strong>
                                                </div>
                                            <?php endif; ?>
                                        </div>

                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary btn-lg">Save</button>
                                        </div>
                                    </form>
                                </div>
                                
                                <div id="creditlimit" role="tabpanel" aria-labelledby="credit_limit-tab" class="tab-pane fade show active">
                                    <form action="<?php echo e(url('/creditlimit/'.$mysettings[0]['id'])); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <label for="credit_limit">Credit Limit (%)</label>
                                            <input type="text" name="credit_limit" id="credit_limit" value="<?php echo e($mysettings[0]['credit_limit']); ?>" class="form-control <?php echo e($errors->has('credit_limit') ? 'is-invalid' : ''); ?>" placeholder="Credit Limit %" readonly>

                                            <?php if($errors->has('credit_limit')): ?>
                                                <div class="invalid-feedback">
                                                    <strong><?php echo e($errors->first('credit_limit')); ?></strong>
                                                </div>
                                            <?php endif; ?>
                                        </div>

                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary btn-lg">Save</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        // $(document).ready(function(){
        //     $.ajaxSetup({
        //         headers: {
        //             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        //         }
        //     });

        //     $('#btn_upload').click(function(){

        //         var fd = new FormData();
        //         var files = $('#file')[0].files[0];
        //         fd.append('file',files);
        //         //var name=$("#edit_name").val();
        //         // var csrf="<?php echo e(csrf_token()); ?>";

        //         $.ajax({
        //         url: '<?php echo e(url("/trader_editcontract")); ?>',
        //         type: 'post',
        //         data:fd,
        //         contentType: false,
        //         processData: false,
        //         success: function(response){
        //             alert(response);
        //         }
        //         });
        //     });
        // });

        function removeRow(removeNum) {
            $('#rowCount'+removeNum).remove();
        }

        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#blah')
                        .attr('src', e.target.result)
                        .width(120)
                        .height(120);
                };

                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

    <script>
        // Trader Contacts JS
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#trader-contacts-crud-modal').on('shown.bs.modal', function() {
                $('#trader-contact-name').trigger('focus');

                $('#trader-contact-user-id').select2({
                    dropdownParent: $('#trader-contacts-crud-modal')
                });
            });

            $('#trader-contact-user-id').on('select2:select', function(e) {
                var selected = e.params.data;

                $.ajax({
                    url: '/users/get-user/' + selected.id,
                    dataType: 'json',
                    type: "GET",
                    success: function (data) {
                        $('#trader-contact-firstname').val(data.firstname);
                        $('#trader-contact-lastname').val(data.lastname);
                        $('#trader-contact-email').val(data.email);
                        $('#trader-contact-phone').val(data.phone);
                    },
                    error: function (data) {
                        console.log('Error:', data);
                    }
                });
            });

            $('#trader-contacts-list').DataTable({
                // "pageLength": 5,
            });

            // create trader-contact
            $('body').on('click', '#create-trader-contact', function(e) {
                e.preventDefault();

                $('#trader-contact-modal-save').val("create-trader-contact");
                $('#trader-contact-form').trigger("reset");

                $('#trader-contact-id').val('');
                $('#trader-contact-user-id').val('').trigger('change');
                $('#trader-contact-firstname').val('');
                $('#trader-contact-lastname').val('');
                $('#trader-contact-email').val('');
                $('#trader-contact-phone').val('');
                // $('#trader-contact-user-id').prop('name', 'user_id').val('').trigger('change');
                // $('#trader-contact-user-id').prop('disabled', false);
                // $('#trader-contact-user-id-hidden').prop('name', '').prop('disabled', true);
                $('#trader-contact-modal-title').html("Add Contact Person");
                $('#trader-contacts-crud-modal').modal('show');
            });

            // edit trader-contact
            $('body').on('click', '#edit-trader-contact', function (e) {
                e.preventDefault();

                var trader_contact_id = $(this).data('id');

                $.get('/trader-contacts/' + trader_contact_id +'/edit-ajax', function (data) {
                    $('#trader-contact-modal-title').html("Edit Contact Person");
                    $('#trader-contact-modal-save').val("edit-trader-contact");

                    $('#trader-contact-id').val(data.id);
                    $('#trader-contact-user-id').val(data.user_id);
                    $('#trader-contact-firstname').val(data.firstname);
                    $('#trader-contact-lastname').val(data.lastname);
                    $('#trader-contact-email').val(data.email);
                    $('#trader-contact-phone').val(data.phone);
                    $('#trader-contact-is-admin').val(data.is_admin);
                    // $('#trader-contact-user-id').prop('disabled', true).prop('name', '');
                    // $('#trader-contact-user-id-hidden').prop('disabled', false).prop('name', 'user_id').val(data.user_id);
                    $('#trader-contacts-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#trader-contact-modal-save').html('Save');
                })
            });

            // delete trader-contact
            $('body').on('click', '#delete-trader-contact', function (e) {
                e.preventDefault();

                var trader_contact_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if(confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-contacts/' + trader_contact_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_contact_id_" + trader_contact_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // store trader-contact (after create or edit)
            if ($("#trader-contact-form").length > 0) {
                $("#trader-contact-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-contact-form').serialize();
                        var actionType = $('#trader-contact-modal-save').val();
                        $('#trader-contact-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-contacts/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                // TODO: Add code to remove fa-check icon from all td.is-admin

                                let is_admin = (data.is_admin == 1) ? '<i class="fa fa-check"></i>' : '';
                                let trader_contact = '<tr id="trader_contact_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.firstname + ' ' + data.lastname + '</a></td>';
                                    trader_contact += '<td>' + data.email + '</td><td>' + data.phone + '</td><td class="text-center is-admin">'+ is_admin +'</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader_contact += '<a id="edit-trader-contact" href="#" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    trader_contact += '<button id="delete-trader-contact" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // TODO: REMOVE
                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     trader-contact
                                    // ]);

                                if (actionType == "create-trader-contact") {
                                    $('#trader-contact-list').prepend(trader_contact);
                                } else {
                                    $("#trader_contact_id_" + data.id).replaceWith(trader_contact);
                                }

                                $('#trader-contact-modal-save').html('Save');
                                $('#trader-contacts-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#trader-contact-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    <script>
        // Trader Members JS
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#trader-members-crud-modal').on('shown.bs.modal', function() {
                // $('#trader-member-user-id').select2({
                //     dropdownParent: $('#trader-members-crud-modal')
                // });
            });

            // $('#trader-member-user-id').on('select2:select', function(e) {
            //     var selected = e.params.data;
            //     console.log(selected);

            //     $.ajax({
            //         url: '/users/get-user/' + selected.id,
            //         dataType: 'json',
            //         type: "GET",
            //         success: function (data) {
            //             console.log(data);

            //             $('#trader-member-firstname').val(data.firstname);
            //             $('#trader-member-lastname').val(data.lastname);
            //             $('#trader-member-email').val(data.email);
            //             $('#trader-member-phone').val(data.phone);
            //             $('#trader-member-username').val(data.username);
            //         },
            //         error: function (data) {
            //             console.log('Error:', data);
            //         }
            //     });
            // });

            $('#trader-members-list').DataTable({
                // "pageLength": 5,
            });

            // create trader-member
            $('body').on('click', '#create-trader-member', function(e) {
                e.preventDefault();

                $('#trader-member-modal-save').val("create-trader-member");
                $('#trader-member-form').trigger("reset");
                $('#trader-member-id').val('');
                // $('#trader-member-user-id').prop('name', 'user_id').val('').trigger('change');
                // $('#trader-member-user-id').prop('disabled', false);
                // $('#trader-member-user-id-hidden').prop('name', '').prop('disabled', true);
                $('#trader-member-user-id').val('');
                $('#trader-member-firstname').val('');
                $('#trader-member-lastname').val('');
                $('#trader-member-email').val('');
                $('#trader-member-phone').val('');
                $('#trader-member-username').val('');
                $('#trader-member-password').val('');
                $('#trader-member-password-confirm').val('');
                $('#trader-member-modal-title').html("Add a Member");
                $('#trader-members-crud-modal').modal('show');
            });

            // edit trader-member
            $('body').on('click', '#edit-trader-member', function (e) {
                e.preventDefault();

                var trader_member_id = $(this).data('id');
                console.log("trader_member_id: " + trader_member_id);

                $.get('/trader-members/' + trader_member_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#trader-member-modal-title').html("Edit Member");
                    $('#trader-member-modal-save').val("edit-trader-member");

                    $('#trader-member-id').val(data.id);
                    // $('#trader-member-user-id').val(data.user_id).trigger('change');
                    // $('#trader-member-user-id').prop('disabled', true)
                    //     .prop('name', '');
                    // $('#trader-member-user-id-hidden').prop('disabled', false)
                    //     .prop('name', 'user_id')
                    //     .val(data.user_id);
                    $('#trader-member-user-id').val(data.user_id);
                    $('#trader-member-firstname').val(data.user.firstname);
                    $('#trader-member-lastname').val(data.user.lastname);
                    $('#trader-member-email').val(data.user.email);
                    $('#trader-member-phone').val(data.user.phone);
                    $('#trader-member-username').val(data.user.username);
                    $('#trader-member-password').val('');
                    $('#trader-member-password-confirm').val('');
                    $('#trader-members-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#trader-member-modal-save').html('Save');
                })
            });

            // delete trader-member
            $('body').on('click', '#delete-trader-member', function (e) {
                e.preventDefault();

                var trader_member_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if(confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-members/' + trader_member_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_member_id_" + trader_member_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // store trader-member (after create or edit)
            if ($("#trader-member-form").length > 0) {
                $("#trader-member-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-member-form').serialize();
                        var actionType = $('#trader-member-modal-save').val();
                        $('#trader-member-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-members/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);

                                var is_admin = data.is_admin == 1 ? '<i class="fa fa-check"></i>' : '';
                                var trader_member = '<tr id="trader_member_id_' + data.id + '"><td><a href="#">' + data.user.firstname + ' ' + data.user.lastname + '</a></td>';
                                    trader_member += '<td>'+ data.user.username +'</td><td>' + data.user.email + '</td><td>' + data.user.phone + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader_member += '<button id="edit-trader-member" type="button" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</button>';
                                    trader_member += '<button id="delete-trader-member" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     trader-member
                                    // ]);

                                if (actionType == "create-trader-member") {
                                    $('#trader-member-list').prepend(trader_member);
                                } else {
                                    $("#trader_member_id_" + data.id).replaceWith(trader_member);
                                }

                                $('#trader-member-modal-save').html('Save');
                                $('#trader-members-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#trader-member-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    <script>
        // Produce Item JS
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // onload modal
            $('#produce-items-crud-modal').on('shown.bs.modal', function() {
                $('#produce-item-name').trigger('focus');

                $('#produce-item-category_id').select2({
                    dropdownParent: $('#produce-items-crud-modal')
                });
            });

            // datatable
            $('#produce-items-list').DataTable({
                // "pageLength": 5,
            });

            // create produce-item
            $('#create-produce-item').click(function(e) {
                e.preventDefault();

                $('#produce-item-modal-save').val("create-produce-item");
                $('#produce-item-form').trigger("reset");
                $('#produce-item-id').val('');
                $('#produce-item-produce-id').val('').trigger('change');
                $('#produce-item-produce-unit-id').val('').trigger('change');
                $('#produce-item-quality').val('');
                $('#produce-item-price-per-unit').val('');
                $('#produce-item-tonnage').val('');

                $('#produce-item-modal-title').html("Add Produce Item");
                $('#produce-items-crud-modal').modal('show');
            });

            // edit produce-item
            $('body').on('click', '#edit-produce-item', function (e) {
                e.preventDefault();

                var produce_item_id = $(this).data('id');

                $.get('/produce-items/' + produce_item_id +'/edit-ajax', function (data) {
                    $('#produce-item-modal-title').html("Edit Produce Item");
                    $('#produce-item-modal-save').val("edit-produce-item");

                    $('#produce-item-id').val(data.id);
                    $('#produce-item-name').val(data.name);
                    $('#produce-item-produce-id').val(data.produce_id).trigger('change');
                    $('#produce-item-produce-unit-id').val(data.produce_unit_id).trigger('change');
                    $('#produce-item-price-per-unit').val(data.price_per_unit);
                    $('#produce-item-quality').val(data.quality);
                    $('#produce-item-tonnage').val(data.tonnage);
                    $('#produce-items-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#produce-item-modal-save').html('Save');
                })
            });

            // delete produce-item
            $('body').on('click', '#delete-produce-item', function (e) {
                e.preventDefault();

                var produce_item_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/produce-items/' + produce_item_id + '/delete-ajax',
                        success: function (data) {
                            $("#produce_item_id_" + produce_item_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // store produce-item (after create or edit)
            if ($("#produce-item-form").length > 0) {
                $("#produce-item-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#produce-item-form').serialize();
                        var actionType = $('#produce-item-modal-save').val();
                        $('#produce-item-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/produce-items/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {

                                var produce_item = '<tr id="produce_item_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.produce.name + '</a></td>';
                                    produce_item += '<td>' + data.produce_unit.name + '</td><td>' + data.price_per_unit + '</td><td>' + data.quality + '</td><td>' + data.tonnage + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    produce_item += '<a id="edit-produce-item" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    produce_item += '<button id="delete-produce-item" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     produce
                                    // ]);

                                if (actionType == "create-produce-item") {
                                    console.log(produce_item);
                                    $('#produce-item-list').prepend(produce_item);
                                } else {
                                    $("#produce_item_id_" + data.id).replaceWith(produce_item);
                                }

                                $('#produce-item-modal-save').html('Save');
                                $('#produce-items-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#produce-item-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    <script>
        // Trader Contracts JS
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#trader-contracts-crud-modal').on('shown.bs.modal', function() {
                $('#trader-contract-name').trigger('focus');
            });

            $('#trader-contracts-list').DataTable({
                // "pageLength": 5,
            });

            // create contract
            $('body').on('click', '#create-trader-contract', function(e) {
                e.preventDefault();

                $('#trader-contract-modal-save').val("create-trader-contract");
                $('#trader-contract-form').trigger("reset");
                $('#trader-contract-id').val('');
                $('#trader-contract-modal-title').html("Add Contract");
                $('#trader-contracts-crud-modal').modal('show');
            });

            // edit contract
            $('body').on('click', '#edit-trader-contract', function (e) {
                e.preventDefault();

                var trader_contract_id = $(this).data('id');

                $.get('/trader-contracts/' + trader_contract_id +'/edit-ajax', function (data) {
                    $('#trader-contract-modal-title').html("Edit Contract");
                    $('#trader-contract-modal-save').val("edit-trader-contract");

                    $('#trader-contract-id').val(data.id);
                    $('#trader-contract-name').val(data.name);
                    $('#trader-contract-file').val('');
                    $('#trader-contract-old-file').val(data.contract_file);
                    $('#trader-contracts-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#trader-contract-modal-save').html('Save');
                })
            });

            // delete contract
            $('body').on('click', '#delete-trader-contract', function (e) {
                e.preventDefault();

                var trader_contract_id = $(this).data("id");
                var confirmDelete = confirm("Are You sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-contracts/' + trader_contract_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_contract_id_" + trader_contract_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // store contract (after create or edit)
            $("#trader-contract-form").on('submit', (function(e) {
                e.preventDefault();

                $(this).validate({
                    submitHandler: function(form) {
                        // formData = $('#trader-contract-form').serialize();
                        // let formData = new FormData($(form)[0]);

                        // let formData = new FormData();
                        // formData.append('file', file);

                        var myForm = $("#trader-contract-form")[0];
                        var formData = new FormData(myForm);

                        let actionType = $('#trader-contract-modal-save').val();
                        $('#trader-contract-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-contracts/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            contentType: false,
                            cache: false,
                            processData: false,
                            success: function (data) {
                                console.log(data);

                                let trader_contract = '<tr id="trader_contract_id_' + data.id + '"><td class="details-control" data-id="'+ data.id +'"></td><td><a href="'+ data.url +'">' + data.name + '</a></td>';
                                    trader_contract += '<td>' + data.contract_file + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader_contract += '<a id="edit-trader-contract" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    trader_contract += '<button id="delete-trader-contract" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     region
                                    // ]);

                                if (actionType == "create-trader-contract") {
                                    $('#trader-contract-list').prepend(trader_contract);
                                } else {
                                    $("#trader_contract_id_" + data.id).replaceWith(trader_contract);
                                }

                                $('#trader-contract-modal-save').html('Save');
                                $('#trader-contracts-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#trader-contract-modal-save').html('Save');
                            }
                        });
                    }
                });
            }));

            $('#trader-contracts-list tbody').on('click', 'td.details-control', function () {
                console.log('here');
                var oTable = $('#trader-contracts-list').DataTable();
                var tr = $(this).closest('tr');
                var row = oTable.row( tr );

                if ( row.child.isShown() ) {
                    // This row is already open - close it
                    row.child.hide();
                    tr.removeClass('shown');
                } else {
                    // Open this row
                    row.child( format($(this).data("id")) ).show();
                    tr.addClass('shown');
                }
            });
        });

        // Show Trader Contract Details JS
        // this.format = function (id) {
        //     return $.ajax({
        //         type: "GET",
        //         context: this,  // <---- context property to set "this" in the callbacks
        //         url: "'/trader-contracts/'+ id +'/get-details'",
        //         success: function (data) {
        //             let contract_details = '<table class="table table-bordered" cellpadding="0" cellspacing="0" border="0" style="width: 100%;">';
        //             contract_details += '<thead><tr><th>Produce Item</th><th>Tonnage (in Kgs)</th><th>Price per Unit</th></tr></thead>';

        //             data.forEach(datum => {
        //                 contract_details += '<tr>';
        //                 contract_details += '<td>'+ datum.produce_item_id +'</td>';
        //                 contract_details += '<td>'+ datum.produce_tonnage +'</td>';
        //                 contract_details += '<td>'+ datum.price_per_unit +'</td>';
        //                 contract_details += '</tr>';
        //             });

        //             contract_details += '</table>';
        //             console.log(contract_details);

        //             this = contract_details;
        //         },
        //         error: function (jqXHR, textStatus, errorThrown) {
        //             // console.warn(xhr.responseText)
        //             console.log(JSON.stringify(jqXHR));
        //             console.log("AJAX error: " + textStatus + ' : ' + errorThrown);

        //             this = null;
        //         }
        //     });
        // }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/fo_settings/show.blade.php ENDPATH**/ ?>