<?php
if(Auth::user()->isAdmin())
{
  $layout = 'layouts.admin'; 
}
 elseif(Auth::user()->getRelatedTrader()->isBulkSeller())
 {
  $layout = 'layouts.s'; 
 }
 elseif(Auth::user()->getRelatedTrader()->isBulkBuyer())
 {
  $layout = 'layouts.b'; 
 }
 elseif(Auth::user()->getRelatedTrader()->isAgroDealer())
  {
  $layout = 'layouts.ad';
  }
  elseif(Auth::user()->getRelatedTrader()->isTransporter())
  {
  $layout = 'layouts.t';
  }
  elseif(Auth::user()->getRelatedTrader()->isFarmerOrganisation())
  {
  $layout = 'layouts.fo';
  }
  ?>


<?php $__env->startSection('title'); ?>
    Twalisha Trading | Edit Organisation
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Edit Organisation</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Organisations</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(route('traders.index')); ?>" class="btn btn-white btn-border btn-round ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <form action="<?php echo e(route('traders.update', $trader->id)); ?>" method="post">
                        <?php echo method_field('PUT'); ?>
                        <?php echo $__env->make("_partials.form-register", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <div class="row">
                            <div class="col-12">
                                <hr>
                                <button type="submit" class="btn btn-primary btn-round btn-md">Update Organisation</button>
                                <small style="padding: .65rem 1.4rem;"></small>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#trader-preferred-regions').select2();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/traders/edit.blade.php ENDPATH**/ ?>