<?php echo csrf_field(); ?>
<div class="form-group">
    <label for="region-name">Name</label>
    <input type="text" name="name" id="region-name" value="<?php echo e(old('name', $region->name ?? '')); ?>" class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" placeholder="Region Name">

    <?php if($errors->has('name')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('name')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <label for="region-description">Description</label>
    <textarea name="description" id="region-description" class="form-control <?php echo e($errors->has('description') ? 'is-invalid' : ''); ?>" rows="10"><?php echo e(old('description', $region->description ?? '')); ?></textarea>

    <?php if($errors->has('description')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('description')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg"><?php echo e($buttonText); ?></button>
</div>
<?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/regions/_form.blade.php ENDPATH**/ ?>