<?php $__env->startSection('title'); ?>
    Twalisha Trading | Farmer Credits
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Farmer Credits - <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($user->fullname); ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Credits</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmer Credits</a>
            </li>
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Requested Amount (KSh)</th>
                                        <th>Credited Amount (KSh)</th>
                                        <th>Payable Amount (KSh)</th>
                                        <th>Balance (KSh)</th>
                                        <th>Status</th>
                                        <th>Cleared</th>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                        </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $credits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="">
                                            <td><a href=""><?php echo e($credit->id); ?></a></td>
                                            <td><?php if($credit->requested_amount): ?>
                                            <?php echo e(Str::limit($credit->requested_amount,-2,'.')); ?>

                                            <?php endif; ?></td>
                                            <td>
                                            <?php if($credit->credited_amount): ?>
                                            <?php echo e((100*$credit->payable_amount)/(100+$credit->interest)); ?>

                                            <?php endif; ?></td>
                                            <td><?php if($credit->payable_amount): ?>
                                            <?php echo e(Str::limit($credit->payable_amount,-2,'.')); ?>

                                            <?php endif; ?></td>
                                            <td><?php if($credit->balance): ?>
                                            <?php echo e(Str::limit($credit->balance,-2,'.')); ?>

                                            <?php endif; ?></td>
                                            <td>
                                                <?php if($credit->approved == 0): ?>
                                                    <span class="badge badge-black">Pending</span>
                                                <?php elseif($credit->approved == 1): ?>
                                                    <span class="badge badge-danger">Declined</span>
                                                <?php elseif($credit->approved == 2): ?>
                                                    <span class="badge badge-warning">In Process</span>
                                                <?php elseif($credit->approved == 3): ?>
                                                    <span class="badge badge-success">Approved</span>
                                                <?php endif; ?>
                                            </td>
                                             <td>
                                             <?php if($credit->cleared == 2): ?>
                                             Confirmed
                                            <?php elseif($credit->cleared == 1): ?>
                                             <i class="fa fa-check"></i>
                                             <?php else: ?>
                                             Pending
                                             <?php endif; ?></td>

                                            <td><?php echo e(Str::limit($credit->created_at,10,'.')); ?></td>
                                            <td>
                                            <?php if($credit->cleared == 1): ?>
                                            <form action="<?php echo e(route('farmer-credits.store')); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" value="<?php echo e($credit->id); ?>" name="credit_id">
                                            <button type="submit" onsubmit="return confirm('Confirm Pay?')" name="confirm" class="btn btn-success btn-sm" title="Confirm Payment">
                                                            <i class="fa fa-check"></i> Confirm Pay
                                                        </button>
                                            </form>
                                            <?php endif; ?>
                                            <button type="button" class="btn btn-info btn-sm" title="Payments" data-original-title="Payments" data-id=""data-toggle="modal" data-target="#modal-viewPay-<?php echo e($credit->id); ?>">
                                                            <i class="fa fa-file-o"></i> Payments
                                                        </button>

                                            </td>
                                    </tr>

                                        <!--Modal view payment-->
                                    <div class="modal fade" id="modal-viewPay-<?php echo e($credit->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">View Payment History | Request Ref#<?php echo e($credit->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>

                                                        <div class="modal-body">
                                                        <div class="row">
                                                        <?php if($credit->cleared == 0): ?>
                                                        <div class="col-sm-3">
                                                        <h5>Amount (KSh)</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>TransactionID</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>Date</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>Action</h5>
                                                        </div>
                                                        <form action="<?php echo e(route('farmer-credits.store')); ?>" method="post">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="col-sm-3">
                                                        <input class="form-control" type="text" name="amount" required>
                                                        <input value="<?php echo e($credit->id); ?>" name="credit_id" type="hidden">
                                                        <input value="<?php echo e($credit->balance); ?>" name="balance" type="hidden">
                                                        <input value="<?php echo e($credit->credited_amount); ?>" name="credited_amt" type="hidden">
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <input class="form-control" name="source" required type="text" placeholder="e.g. Cash,Cheque">
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <input class="form-control" required type="date">
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <button class="form-control btn btn-primary" name="pay" type="submit"><i class="fa fa-save"></i> Save</button>
                                                        </div>
                                                        </form>
                                                        <br>
                                                        <?php endif; ?>
                                                        <div class="col-sm-3">
                                                        <h5>#ID</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>Amount (KSh)</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>TransactionID</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>Date</h5>
                                                        </div>

                                                        <?php $__currentLoopData = $credit->creditClearing; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-sm-3">
                                                        <?php echo e($payments->id); ?>

                                                        </div>
                                                        <div class="col-sm-3">
                                                        <?php echo e($payments->amount); ?>

                                                        </div>
                                                        <div class="col-sm-3">
                                                        <?php echo e($payments->source); ?>

                                                        </div>
                                                        <div class="col-sm-3">
                                                        <?php echo e(Str::limit($payments->created_at,10,'')); ?>

                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                        </div>
                                                        <div class="modal-footer">

                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!--/end modal view payment-->
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Requested Amount (KSh)</th>
                                        <th>Credited Amount (KSh)</th>
                                        <th>Payable Amount (KSh)</th>
                                        <th>Balance (KSh)</th>
                                        <th>Status</th>
                                        <th>Cleared</th>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                </div>
                </div>
            </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/farmer-credits/edit.blade.php ENDPATH**/ ?>