<?php $__env->startSection('title'); ?>
    Twalisha Trading | Organisation Types
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Organisation Types</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Organisation Types</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-trader-type" href="<?php echo e(route('trader-types.create')); ?>" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Add Organisation Type
        </a>

        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($trader_types->count()): ?>
                        <div class="table-responsive">
                            <table id="trader-types-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="trader-type-list">
                                    <?php $__currentLoopData = $trader_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="trader_type_id_<?php echo e($trader_type->id); ?>">
                                            <td><a href="<?php echo e($trader_type->url); ?>"><?php echo e($trader_type->name); ?></a></td>
                                            
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-trader-type" href="<?php echo e(route('trader-types.edit', $trader_type->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($trader_type->id); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-trader-type" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($trader_type->id); ?>">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="trader-type-form" name="trader-type-form" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <input type="hidden" name="id" id="trader-type-id">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <div class="form-group">
                            <label for="trader-type-name">Name</label>
                            <input type="text" name="name" id="trader-type-name" value="" class="form-control" placeholder="Name" autofocus>
                        </div>
                        <div class="form-group">
                            <label for="trader-type-description">Description</label>
                            <textarea name="description" id="trader-type-description" class="form-control" disabled></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#trader-types-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            $('#create-trader-type').click(function(e) {
                e.preventDefault();

                $('#modal-save').val("create-trader-type");
                $('#trader-type-form').trigger("reset");
                $('#trader-type-id').val('');
                $('#modal-title').html("Add Organisation Type");
                $('#crud-modal').modal('show');
            });

            /* When click edit */
            $('body').on('click', '#edit-trader-type', function (e) {
                e.preventDefault();

                var trader_type_id = $(this).data('id');

                $.get('/trader-types/' + trader_type_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit Organisation Type");
                    $('#modal-save').val("edit-trader-type");

                    $('#trader-type-id').val(data.id);
                    $('#trader-type-name').val(data.name);
                    // $('#trader-type-description').val(data.description);
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            //delete
            $('body').on('click', '#delete-trader-type', function (e) {
                e.preventDefault();

                var trader_type_id = $(this).data("id");
                var confirmDelete = confirm("Are You sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-types/' + trader_type_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_type_id_" + trader_type_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            if ($("#trader-type-form").length > 0) {
                $("#trader-type-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-type-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-types/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                var trader_type = '<tr id="trader_type_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.name + '</a></td>';
                                    trader_type += '<td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader_type += '<a id="edit-trader-type" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    trader_type += '<button id="delete-trader-type" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     trader_type
                                    // ]);

                                if (actionType == "create-trader-type") {
                                    $('#trader-type-list').prepend(trader_type);
                                } else {
                                    $("#trader_type_id_" + data.id).replaceWith(trader_type);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/trader-types/index.blade.php ENDPATH**/ ?>