<?php $__env->startSection('title'); ?>
    BTCotton | Login
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title" style="color:white;font-weight:bold">Login</h4>
        <h5 class="op-7 mb-2"><text style="color:white">Don't have an account? </text><a href="<?php echo e(url('register_user')); ?>" style="color:white;font-weight:bold">Sign up</a></h5>
  
        <h5 class="op-7 mb-2"><text style="color:white">Don't have an account? </text><a href="<?php echo e(url('register_user_no_organization')); ?>" style="color:white;font-weight:bold">Sign up without an Organization</a></h5>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="col-md-7">
    <div class="card">
        <div class="card-body">
            <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <form action="<?php echo e(route('login')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="login-form">
                    <div class="form-group">
                        <label for="login-username">Username</label>
                        <input name="username" id="login-username" type="text" class="form-control <?php echo e($errors->has('password') ? 'is-invalid' : ''); ?>" placeholder="Username">

                        <?php if($errors->has('username')): ?>
                            <div class="invalid-feedback">
                                <strong><?php echo e($errors->first('username')); ?></strong>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="login-password">Password</label>
                        <input id="login-password" name="password" type="password" class="form-control <?php echo e($errors->has('password') ? 'is-invalid' : ''); ?>" placeholder="Password">

                        <?php if($errors->has('password')): ?>
                            <div class="invalid-feedback">
                                <strong><?php echo e($errors->first('password')); ?></strong>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group">
                    <input type="submit" class="btn btn-warning btnLogin" value="Login" style="color:white;font-weight:bold">
                    <a href="#" class="btn btn-link">Forgotten your password?</a>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            $("#login-seller").click(function () {
                if ($(this).is(":checked")) {
                    $(".seller-fields").show();
                } else {
                    $(".seller-fields").hide();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.noauth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/auth/login.blade.php ENDPATH**/ ?>