<?php $__env->startSection('title'); ?>
    Twalisha Trading | Produce Order - <?php echo e('ID: ' . $produce_order->id); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Produce Order - <?php echo e('ID: ' . $produce_order->id); ?></h4>
        

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Produce Order</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="edit-produce-order" href="#" class="btn btn-primary btn-round btn-sm">
            <span class="btn-label"><i class="fa fa-plus"></i></span> Update Produce Order
        </a>

        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <p>
                        <b>Produce Order ID:</b> <?php echo e($produce_order->id); ?>

                        <br><b>Organisation:</b> <?php echo e($produce_order->trader->organisation_name); ?>

                        <br><b>No of Items:</b> <?php echo e($produce_order->produce_order_items->count()); ?>

                        <br><b>Total:</b> <?php echo e('KES ' . number_format($produce_order->total, 2)); ?>

                        <br><b>Approved:</b> <?php echo e($produce_order->approved ? 'Yes' : 'No'); ?>

                    </p>
                    <hr>

                    <?php if($produce_order->produce_order_items->count()): ?>
                        <?php echo $__env->make('produce-order-items._index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/produce-orders/show.blade.php ENDPATH**/ ?>