<?php $__env->startSection('title'); ?>
    Twalisha Trading | Farmer Credits
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Farmer Credits</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmer Credits</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <h5 class="text-right"></h5>



                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <?php if(Auth()->user()->isAdmin()): ?>
                                        <th>Farmer Organization</th>
                                        <th>Contact Person</th>
                                        <th>Contact</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                        <?php else: ?>
                                        <th>Farmer</th>
                                        <th>Phone</th>
                                        <th>Credit Limit (KSh)</th>
                                        <th>Actions</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                   <?php if(Auth()->user()->isAdmin()): ?>
                                   <?php if($traders->count()): ?>
                                    <?php $__currentLoopData = $traders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="">

                                            <td><a href="<?php echo e(route('farmer-credits.show', $trader->id)); ?>"><?php echo e($trader->organisation_name); ?></a></td>
                                            <td><?php echo e($trader->user->fullname); ?></td>
                                            <td><?php echo e($trader->user->phone); ?></td>
                                            <td>
                                                <?php if($trader->status === 1): ?>
                                                    <span class="badge badge-success">Active</span>
                                                <?php elseif($trader->status === 0): ?>
                                                    <span class="badge badge-danger">Inactive</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><a class="btn btn-sm btn-success" href="<?php echo e(route('farmer-credits.show', $trader->id)); ?>">View Farmers
                                                </a></td>
                                        </tr>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                     <?php else: ?>
                                     <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                     <?php endif; ?>
                                    <?php else: ?>
                                    <?php if($farmers->count()): ?>
                                    <?php $__currentLoopData = $farmers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><a href="<?php echo e(route('farmer-credits.show', $farmer->user->id)); ?>"><?php echo e($farmer->user->fullname); ?></a></td>
                                            <td><?php echo e($farmer->user->phone); ?></td>
                                            <td><?php echo e($farmer->user->wallet->credit_limit); ?></td>
                                            <td><a class="btn btn-sm btn-success" href="<?php echo e(route('farmer-credits.show', $farmer->user->id)); ?>">View Credits
                                                </a></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endif; ?>
                                    <?php endif; ?>


                                </tbody>
                                <tfoot>
                                    <tr>
                                    <?php if(Auth()->user()->isAdmin()): ?>
                                        <th>Farmer Organization</th>
                                        <th>Contact Person</th>
                                        <th>Contact</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    <?php else: ?>
                                    <th>Farmer</th>
                                    <th>Phone</th>
                                    <th>Credit Limit (KSh)</th>
                                    <th>Actions</th>
                                    <?php endif; ?>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                </div>
                </div>
            </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/farmer-credits/index.blade.php ENDPATH**/ ?>