<div class="table-responsive">
    <table id="trader-contacts-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Primary</th>
                <th class="text-center" style="width: 10%">Action</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Primary</th>
                <th class="text-center">Action</th>
            </tr>
        </tfoot>
        <tbody id="trader-contact-list">
            <?php $__currentLoopData = $trader_contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr id="trader_contact_id_<?php echo e($contact->id); ?>">
                    <td><a href="<?php echo e($contact->url); ?>"><?php echo e($contact->fullname); ?></a></td>
                    <td><?php echo e($contact->email); ?></td>
                    <td><?php echo e($contact->phone); ?></td>
                    <td class="text-center is-admin">
                        <?php if($contact->is_admin == 1): ?>
                            <i class="fa fa-check"></i>
                        <?php endif; ?>
                    </td>
                    <td>
                        <div class="btn-group form-actions" role="group" aria-label="Actions">
                            <a id="edit-trader-contact" href="<?php echo e(route('trader-contacts.edit', $contact->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($contact->id); ?>">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <button id="delete-trader-contact" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($contact->id); ?>">
                                <i class="far fa-trash-alt"></i> Delete
                            </button>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/trader-contacts/_index.blade.php ENDPATH**/ ?>