<?php $__env->startSection('title'); ?>
    Twalisha Trading | Input Order Items
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
    <h4 class="page-title">Input Order Items | Order for <?php echo e($order->inputOrder->organisation_name); ?> #Ref: <?php echo e($order->id); ?></h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Orders</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Order Items</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
    <a href="#" class="btn btn-primary btn-round btn-sm" data-toggle="modal" data-target="#modal-default">
            <span class="btn-label"><i class="fa fa-plus"></i></span> Add Input Order Items
        </a>
        <a href="<?php echo e(route('input_orders.index')); ?>" class="btn btn-white btn-border btn-round ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <h5 class="text-right"><strong>Input Order ID:</strong> <?php echo e($order->id); ?></h5>

                    <form action="<?php echo e(route('input_orders.update', $order->id)); ?>" method="post">
                        <?php echo method_field('PUT'); ?>
                        <input name="category_id" type="hidden" value="<?php echo e($order->id); ?>"/>

                    </form>
                    <?php if($items->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Input</th>
                                        <th>Quantity</th>
                                        <th>Price[Kes.]</th>
                                        <th>Status</th>
                                        <th>Expected On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="">
                                            <td><a href=""><?php echo e($item->id); ?></a></td>
                                            <td><?php echo e($item->farmer->fullname); ?></td>
                                            <td><?php echo e($item->input->name); ?></td>
                                            <td><?php echo e($item->quantity); ?> <?php echo e($item->input->input_unit->abbreviation); ?></td>
                                            <td><?php echo e($item->price); ?></td>
                                            <td>
                                            <?php if($item->approved == 0): ?>
                                            <l>Pending Financing</l>
                                            <?php elseif($item->approved == 1): ?>
                                             <l>In process</l>
                                             <?php elseif($item->approved == 2): ?>
                                             <l>Done</l>
                                             <?php endif; ?>
                                            </td>
                                            <td><?php echo e(Str::limit($item->expected_date,10,'.')); ?></td>
                                            <td class="text-right">
                                                <form action="<?php echo e(route('input_orders.update', $item->id)); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                                <input type="hidden" name="approved" value="1">
                                                <?php if($item->approved == 0): ?>
                                                    <button type="submit" name="approveitem" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Approve" data-original-title="Approve" data-id="">
                                                        <i class="fa fa-edit"></i> Approve
                                                    </button>
                                                    <button type="button" class="btn btn-primary btn-sm" data-original-title="Edit" data-id="" data-toggle="modal" data-target="#modal-edit-<?php echo e($item->id); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </button>

                                                    
                                                </form>
                                                <?php elseif($item->approved < 2): ?>
                                                <form action="<?php echo e(route('input_orders.destroy', $item->id)); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <input type="hidden" name="user_id" value="<?php echo e($item->farmer->id); ?>">
                                                <input type="hidden" name="price" value="<?php echo e($item->price); ?>">
                                                <input type="hidden" name="financing" value="<?php echo e($item->financing); ?>">
                                                    <button id="delete-input" name="deleteitem" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="">
                                                        <i class="far fa-trash-alt"></i> Cancel
                                                    </button>
                                                </form>
                                                <?php endif; ?>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Input</th>
                                        <th>Quantity</th>
                                        <th>Price</th>
                                        <th>Status</th>
                                        <th>Expected On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="modal-default" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title">Add Input Order Item</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="input-order-form" name="input-order-form" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="input-order-item-id">
                        <input type="hidden" name="order_id" id="input-order-item-order-id" value="<?php echo e($order->id); ?>">
                        <input type="hidden" name="approved" id="input-order-item-approved" value="0">
                        <input type="hidden" name="directed_to" id="input-order-item-directed-to">
                        <input type="hidden" name="total" id="input-order-item-total" value="0">
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label for="trader-id">Farmer</label>
                                <select id="input-order-item-farmer-id" name="farmer_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option  value="">- Select -</option>
                                    <?php $__currentLoopData = $farmers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($farmer->user_id); ?>" data-credit="<?php echo e($farmer->user->wallet->credit_limit); ?>" data-price="<?php echo e($farmer->user->wallet->float_bal); ?>"><?php echo e($farmer->user->lastname); ?> <?php echo e($farmer->user->firstname); ?>- <?php echo e($farmer->user->phone); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-6">
                                <label for="input-order-item-input-id">Input to Purchase</label>
                                <select id="input-order-item-input-id" name="input_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <?php $__currentLoopData = $inputs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $input): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($input->id); ?>"><?php echo e($input->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="input-order-input-item-id">Supplier</label>
                                <select name="input_item_id" id="input-order-input-item-id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-6">
                                <label for="input-order-item-quantity">Quantity <span id="input-order-selected-quantity"></span></label>
                                <input type="number" id="input-order-item-quantity" onkeyup="sum();" name="quantity" class="form-control" >
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="input-order-item-price">Total Price</label>
                                <input type="hidden" name="price1" id="input-order-item-price" class="form-control">
                                <input type="number" onkeyup="sum();" id="price1" name="price" class="form-control" value="0" readonly>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label for="input-order-item-financing">Financing</label>
                                <select id="input-order-item-financing" name="financing" class="form-control select2" >
                                    <option value="">- Select Mode -</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label for="input-order-item-expected-date">Expected Date</label>
                                <input type="date" name="expected_date" id="input-order-item-expected-date" class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-12">
                                <label for="input-order-item-description">Description</label>
                                <textarea name="description" id="input-order-item-description" class="form-control"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="input-order-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
            try {
                decimalCount = Math.abs(decimalCount);
                decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

                const negativeSign = amount < 0 ? "-" : "";

                let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
                let j = (i.length > 3) ? i.length % 3 : 0;

                return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
            } catch (e) {
                console.log(e)
            }
        }

        function sum() {
            var txtFirstNumberValue = document.getElementById('input-order-item-quantity').value;
            var txtSecondNumberValue = document.getElementById('input-order-item-price').value;
            if (txtFirstNumberValue == "")
                txtFirstNumberValue = 0;
            if (txtSecondNumberValue == "")
                txtSecondNumberValue = 0;

            var result = parseInt(txtFirstNumberValue) * parseInt(txtSecondNumberValue);
            if (!isNaN(result)) {
                document.getElementById('price1').value = result;
            }
        }

        $('#input-order-input').on('change', function(){
            var price = $(this).children('option:selected').data('price');
            $('#price').val(price);
        });

    //wallet bal
        // $('#wallet_id').on('change', function(){
        //     var float = $(this).children('option:selected').data('float');
        //     var credit = $(this).children('option:selected').data('credit');
        //     $('#input_order_financing').empty();
        //     $('#input_order_financing').append("<option value=''>-Select Mode-</option><option value='wallet'>Wallet [" + float + "]</option><option value='credit'>Credit[" +credit+ "]</option>");
        $('#input-order-item-farmer-id').on('change', function(){
            var price = $(this).children('option:selected').data('price');
            var credit = $(this).children('option:selected').data('credit');
            $('#input-order-item-financing').empty();
            $('#input-order-item-financing').append("<option value=''>-Select Mode-</option><option value='wallet'>Wallet [KSh " + formatMoney(price) + "]</option><option value='credit'>Credit[ Ksh "+formatMoney(credit) +"]</option>");
        });

    //input seller
        $('#input-order-input').on('change', function() {
            var  id = $(this).children('option:selected').data('seller-id');
            var  org = $(this).children('option:selected').data('seller');
            $('#input-order-input-item-id').empty();
            $('#input-order-input-item-id').append("<option value=''>-Select Input Seller-</option><option value='" +id+ "'>" + org + "</option>");
        });

        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#modal-default').on('shown.bs.modal', function() {
                $('#input-order-item-input-id, #input-order-input-item-id').select2({
                    dropdownParent: $('#modal-default')
                });
            });

            $('#inputs-list').DataTable({
                // "pageLength": 5,
            });

            $('#create-input-order-item').click(function(e) {
                e.preventDefault();

                $('#input-order-modal-save').val("create-input-order-item");
                $('#input-order-form').trigger("reset");
                $('#input-order-item-id').val('');
                $('#input-order-item-farmer-id').val('').trigger('change');
                $('#input-order-item-input-id').val('').trigger('change');
                $('#input-order-input-item-id').val('').trigger('change');
                $('#input-order-item-quantity').val('');
                $('#input-order-item-price').val('');
                $('#input-order-item-financing').val('').trigger('change');
                $('#input-order-item-expected-date').val('');
                $('#input-order-item-description').val('');

                $('#input-order-modal-title').html("Add Input Order Item");
                $('#input-order-crud-modal').modal('show');
            });

            $('body').on("select2:select","#input-order-item-input-id", function(e) {
                let input_item_select = $('#input-order-input-item-id');
                input_item_select
                    .empty()
                    .append(
                        $('<option />')  // Create new <option> element
                            .text("- Select -") // Set textContent
                            .prop('selected', true)
                    );

                var selected = e.params.data;

                $.ajax({
                    url: '/input_orders/get-input-items/' + selected.id,
                    dataType: 'json',
                    type: "GET",
                    success: function (data) {
                        $('#input-order-selected-quantity').text('');
                        $('#input-order-item-quantity').val('');
                        $('#input-order-item-price').val('');
                        $('#price1').val('');

                        $.each(data, function (key, datum) {
                            console.log(datum.input);
                            input_item_select
                                .append($('<option />')  // Create new <option> element
                                .val(datum.id)            // Set value as "Hello"
                                .text(datum.name+' - '+datum.trader.organisation_name+' ('+datum.input_unit.abbreviation+')') // Set textContent as "Hello"
                                .data({                  // Set multiple data-* attributes
                                    price: datum.price_per_unit,
                                    units: datum.input_unit.name,
                                    trader_id: datum.trader_id
                                })
                            );
                        })
                    },
                    error: function (data) {
                        console.log('Error:', data);
                    }
                });
            });

            $('body').on("select2:select","#input-order-input-item-id", function(e) {
                $('#input-order-item-price').val('');
                $('#input-order-selected-quantity').text('');

                let price = $(this).find(':selected').data('price');
                let units = $(this).find(':selected').data('units');
                let trader_id = $(this).find(':selected').data('trader_id');

                if(price !== undefined) $('#input-order-item-price').val(price);
                if(units !== undefined) $('#input-order-selected-quantity').text('('+units+')');
                if(trader_id !== undefined) $('#input-order-item-directed-to').val(trader_id);

                if($('#input-order-item-quantity').val()) {
                    $('#input-order-item-quantity').trigger("keyup");
                }
            });

            // store input-order (after create or edit)
            if ($("#input-order-form").length > 0) {
                console.log('Here');
                $("#input-order-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#input-order-form').serialize();
                        var actionType = $('#input-order-modal-save').val();
                        $('#input-order-modal-save').html('Saving...');
                        console.log(formData);
                        $.ajax({
                            data: formData,
                            url: '/input_orders/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);

                                var active = data.active == 1 ? '<i class="fa fa-check"></i>' : '';
                                var input_order_item = '<tr id="input_order_item_id_' + data.id + '"><td>' + data.farmer.fullname + '</td>';
                                    input_order_item += '<td>'+ data.input.name +'</td><td>' + data.quantity + '</td><td>' + data.price + '</td><td>' + data.approved + '</td><td class="text-right"></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     input-order
                                    // ]);

                                if (actionType == "create-input-order-item") {
                                    $('#input-order-list').prepend(input_order_item);
                                } else {
                                    $("#input_order_item_id_" + data.id).replaceWith(input_order_item);
                                }

                                $('#input-order-modal-save').html('Save');
                                $('#input-orders-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#input-order-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make( (Auth::user()->isAdmin()) ? 'layouts.admin' : 'layouts.fo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/input_orders/details.blade.php ENDPATH**/ ?>