<?php $__env->startSection('title'); ?>
    Twalisha Trading | User - <?php echo e($user->fullname); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e($user->fullname); ?> - Profile</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route('users.index')); ?>">Users</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-4">
            <div class="card card-profile">
                
                <div class="card-header">
                <div class="profile-picture">
                        <div class="avatar avatar-xl">
                            <img src="<?php echo e(asset('img/profile.jpg')); ?>" alt="..." class="avatar-img rounded-circle">
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="user-profile text-center">
                        <div class="name"><?php echo e($user->fullname); ?></div>
                        <div class="job">
                            <p><b>Username:</b> <?php echo e($user->username); ?>

                            <br><b>Email:</b> <?php echo e($user->email); ?>

                            <br><b>Phone:</b> <?php echo e($user->phone); ?></p>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="row user-stats text-center">
                        <div class="col">
                            <div class="number">KSh <?php echo e($user->balance ? number_format(round($user->balance, 2)) : number_format(0)); ?></div>
                            <div class="title">Wallet Balance</div>
                        </div>
                        <div class="col">
                            <div class="number">KSh <?php echo e($user->locked_amount ? number_format(round($user->locked_amount, 2)) : number_format(0)); ?></div>
                            <div class="title">Locked Amount</div>
                        </div>
                    </div>
                    <div class="row user-stats text-center">
                        <div class="col">
                            <div class="number"><?php echo e($user->aggregations->sum('quantity')); ?> Kgs</div>
                            <div class="title">Aggregations</div>
                        </div>
                        <div class="col">
                            <div class="number">KSh <?php echo e($user->credit_limit ? number_format(round($user->credit_limit, 2)) : number_format(0)); ?></div>
                            <div class="title">Credit Limit</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <div class="card-head-row">
                        <div class="card-title">Profile</div>
                        <div class="card-tools">
                            <a href="<?php echo e(route('profile', $user->id)); ?>" class="btn btn-info btn-round btn-sm mr-2">
                                <i class="fa fa-edit"></i>
                                Update Profile
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <dl class="dl-horizontal row">
                        <dt class="col-md-6 mb-3 text-right">First Name</dt>
                            <dd class="col-md-6 mb-3"><?php echo e($user->firstname); ?></dd>
                        <dt class="col-md-6 mb-3 text-right">Last Name</dt>
                            <dd class="col-md-6 mb-3"><?php echo e($user->lastname); ?></dd>
                        <dt class="col-md-6 mb-3 text-right">Email</dt>
                            <dd class="col-md-6 mb-3"><?php echo e($user->email); ?></dd>
                        <dt class="col-md-6 mb-3 text-right">Phone Number</dt>
                            <dd class="col-md-6 mb-3"><?php echo e($user->phone); ?></dd>
                        <dt class="col-md-6 mb-3 text-right">Address</dt>
                            <dd class="col-md-6 mb-3"><?php echo e($user->address); ?></dd>
                        <?php if($user->farmer_profile): ?>
                            <dt class="col-md-6 mb-3 text-right">Middle Name</dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->middlename); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">M-Pesa Number</dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->mpesa_number); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">National ID</dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->national_id); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Education Level</dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->education_level); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Acreage</dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->acreage); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Acreage Farmed</dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->acreage_farmed); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Input Spending <br><small>Estimated spending per season in KSh</small>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->input_spending); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Preferred Learning Language</dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->preferred_learning_language); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Preferred Agrodealer
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->preferred_agrodealer); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Computer Access <br><small>Do you have access to a computer?</small></dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->computer_access == 1 ? 'Yes' : 'No'); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Computer Location <br><small>Where do you access your computer from?</small>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->computer_access_location); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Internet Access <br><small>Do you have access to the Internet?</small></dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->internet_access == 1 ? 'Yes' : 'No'); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Internet Location <br><small>Where do you access your computer from?</small></dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->internet_access_location); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Credit History <br><small>Have you borrowed for farming purposes in the past?</small></dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->credit_history == 1 ? 'Yes' : 'No'); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Outstanding Credit <br><small>Do you have an outstanding loan?</small></dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->credit_history_outstanding == 1 ? 'Yes' : 'No'); ?></dd>
                            <dt class="col-md-6 mb-3 text-right">Outstanding Credit <br><small>Information about any outstanding credit</small></dt>
                                <dd class="col-md-6 mb-3"><?php echo e($user->farmer_profile->credit_history_outstanding_details); ?></dd>
                        <?php endif; ?>
                    </dl>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/users/edit.blade.php ENDPATH**/ ?>