<?php $__env->startSection('title'); ?>
    Twalisha Trading | Inputs
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Inputs</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Inputs</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-input" href="<?php echo e(route('inputs.create')); ?>" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Add Inputs
        </a>

        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($inputs->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Category</th>
                                        <th>Description</th>
                                        <th>Listed?</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Category</th>
                                        <th>Description</th>
                                        <th>Listed?</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $inputs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $input): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="input_id_<?php echo e($input->id); ?>">
                                            <td><a href="<?php echo e($input->url); ?>"><?php echo e($input->name); ?></a></td>
                                            <td><?php echo e($input->category->name); ?></td>
                                            <td><?php echo e(Str::limit($input->description, '100')); ?></td>
                                            <td><?php echo e(($input->listed == 1) ? 'Yes' : 'No'); ?></td>
                                            <td class="text-right">
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-input" href="<?php echo e(route('inputs.edit', $input->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($input->id); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-input" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($input->id); ?>">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</td>
</tr>
    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="input-form" name="input-form" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="input-id">
                        <div class="form-group">
                            <label for="input-name">Name</label>
                            <input type="text" name="name" id="input-name" value="" class="form-control" placeholder="Name" autofocus>
                        </div>
                        <div class="form-group">
                            <label for="input-category-id">Category</label>
                            <select id="input-category-id" name="category_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                <?php $__currentLoopData = $input_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="input-description">Description</label>
                            <textarea name="description" id="input-description" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="input-listed">Listed?</label>
                            <select id="input-listed" name="listed" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            //onclick add
            $('#create-input').click(function(e) {
                e.preventDefault();

                $('#modal-save').val("create-input");
                $('#input-form').trigger("reset");
                $('#input-id').val('');
                $('#modal-title').html("Add Input");
                $('#crud-modal').modal('show');
            });

            // onclick edit
            $('body').on('click', '#edit-input', function (e) {
                e.preventDefault();

                var input_id = $(this).data('id');

                $.get('inputs/' + input_id +'/edit-ajax', function (data) {
                    $('#modal-title').html("Edit Input");
                    $('#modal-save').val("edit-input");

                    $('#input-id').val(data.id);
                    $('#input-name').val(data.name);
                    $('#input-category_id').val(data.category_id).trigger('change');
                    $('#input-description').val(data.description);
                    $('#input-listed').val(data.listed).trigger('change');
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            //onclick delete
            $('body').on('click', '#delete-input', function (e) {
                e.preventDefault();

                var input_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: 'inputs/' + input_id + '/delete-ajax',
                        success: function (data) {
                            $("#input_id_" + input_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            //onload modal
            $('#crud-modal').on('shown.bs.modal', function() {
                $('#input-name').trigger('focus');

                $('#input-category_id').select2({
                    dropdownParent: $('#crud-modal')
                });
            });

            //onsubmit
            if ($("#input-form").length > 0) {
                $("#input-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#input-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/inputs/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);

                                var long_description = data.description;
                                if (long_description) var short_description = long_description.substring(0, 100);
                                var listed = data.listed == 1 ? 'Yes' : 'No';

                                var input = '<tr id="input_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.name + '</a></td>';
                                    input += '<td>' + data.category_name + '</td><td>' + short_description + '</td><td>' + listed + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    input += '<a id="edit-input" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    input += '<button id="delete-input" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     input
                                    // ]);

                                if (actionType == "create-input") {
                                    console.log(input);
                                    $('#input-list').prepend(input);
                                } else {
                                    $("#input_id_" + data.id).replaceWith(input);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/inputs/index.blade.php ENDPATH**/ ?>