<?php $__env->startSection('title'); ?>
    Twalisha Trading | Produce Aggregation
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Produce Aggregation</h4>
        

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Produce Aggregation</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <?php if(isset($trader)): ?>
            <a id="create-aggregation" href="<?php echo e(route('produce-aggregations.create')); ?>" class="btn btn-primary btn-round btn-sm">
                <span class="btn-label"><i class="fa fa-plus"></i></span> Aggregate
            </a>
        <?php endif; ?>

        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($produce_aggregations->count()): ?>
                        <div class="table-responsive">
                            <table id="aggregations-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Farmer</th>
                                        <th>Produce</th>
                                        <th>Quantity</th>
                                        <th>Details</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Farmer</th >
                                        <th>Produce</th>
                                        <th>Quantity</th>
                                        <th>Details</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="aggregation-list">
                                    <?php $__currentLoopData = $produce_aggregations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_aggregation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="aggregation_id_<?php echo e($produce_aggregation->id); ?>">
                                            <td><?php echo e($produce_aggregation->farmer->fullname); ?></td>
                                            <td>
                                                <?php echo e($produce_aggregation->produce_item->produce->name); ?>

                                                <br><small><b>Price:</b> <?php echo e(number_format($produce_aggregation->produce_item->price_per_unit, 2) . '/ '); ?>

                                                    <?php echo e($produce_aggregation->produce_item->produce_unit->abbreviation); ?></small>
                                            </td>
                                            <td><?php echo e($produce_aggregation->quantity); ?></td>
                                            <td>
                                                <span><b>Aggregator:</b> <?php echo e($produce_aggregation->aggregator->fullname); ?></span>
                                                <br><span><b>Date:</b> <?php echo e($produce_aggregation->created_at); ?></span>
                                                <?php if($produce_aggregation->approved == 1): ?>
                                                    <br><span class="text-success">Approved</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <?php if(isset($trader) && !$produce_aggregation->approved): ?>
                                                        <a id="edit-aggregation" href="<?php echo e(route('produce-aggregations.edit', $produce_aggregation->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($produce_aggregation->id); ?>">
                                                            <i class="fa fa-edit"></i> Edit
                                                        </a>
                                                        <button id="delete-aggregation" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($produce_aggregation->id); ?>">
                                                            <i class="far fa-trash-alt"></i> Delete
                                                        </button>
                                                    <?php endif; ?>
                                                    <?php if(Auth::user()->isAdmin() && !$produce_aggregation->approved): ?>
                                                        <form id="aggregation-approval-form" class="d-inline" method="post">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="id" value="<?php echo e($produce_aggregation->id); ?>">
                                                            <button type="submit" id="approve-aggregation" class="btn btn-warning btn-sm ml-1" data-toggle="tooltip" title="Approve" data-original-title="Approve" data-id="<?php echo e($produce_aggregation->id); ?>">
                                                                <i class="fas fa-check-double"></i> Approve
                                                            </button>
                                                        </form>
                                                    <?php endif; ?>
                                                </div>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <?php if(isset($trader)): ?>
        <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="modal-title"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="aggregation-form" name="aggregation-form" method="post">
                        <?php echo csrf_field(); ?>

                        <div class="modal-body">
                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                            <input type="hidden" name="id" id="aggregation-id">
                            <input type="hidden" name="price_per_unit" id="aggregation-price-per-unit" value="0">
                            <div class="form-group">
                                <label for="aggregation-farmer-id">Farmer</label>
                                <select id="aggregation-farmer-id" name="farmer_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <?php $__currentLoopData = $trader->members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($member->user->id); ?>"><?php echo e($member->user->fullname); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="aggregation-produce-item-id">Produce</label>
                                <select id="aggregation-produce-item-id" name="produce_item_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <?php $__currentLoopData = $trader->produce_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($produce_item->id); ?>" data-price="<?php echo e($produce_item->price_per_unit); ?>"><?php echo e($produce_item->produce->name . ' - ' . $produce_item->quality . ' @' . number_format($produce_item->price_per_unit, 2) . ' /' . $produce_item->produce_unit->abbreviation); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="aggregation-quantity">Quantity</label>
                                <input type="text" name="quantity" id="aggregation-quantity" value="" class="form-control" placeholder="Quantity">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#crud-modal').on('shown.bs.modal', function() {
                $('#aggregation-name').trigger('focus');
            });

            $('#aggregations-list').DataTable({
                // "pageLength": 5,
            });

            $('#aggregation-produce-item-id').change(function(e) {
                let price = $(this).find(':selected').data('price');
                $('#aggregation-price-per-unit').val(price);
            });

            // create
            $('body').on('click', '#create-aggregation', function(e) {
                e.preventDefault();

                $('#modal-save').val("create-aggregation");
                $('#aggregation-form').trigger("reset");
                $('#aggregation-id').val('');
                $('#aggregation-farmer-id').val('').trigger('change');
                $('#aggregation-produce-item-id').val('').trigger('change');
                $('#aggregation-price-per-unit').val(0);
                $('#aggregation-quantity').val('');
                $('#modal-title').html("Aggregate Produce");
                $('#crud-modal').modal('show');
            });

            // edit
            $('body').on('click', '#edit-aggregation', function (e) {
                e.preventDefault();

                var aggregation_id = $(this).data('id');

                $.get('/produce-aggregations/' + aggregation_id +'/edit-ajax', function (data) {
                    $('#modal-title').html("Edit Aggregation");
                    $('#modal-save').val("edit-aggregation");

                    $('#aggregation-id').val(data.id);
                    $('#aggregation-farmer-id').val(data.farmer_id).trigger('change');
                    $('#aggregation-produce-item-id').val(data.produce_item_id).trigger('change');
                    $('#aggregation-price-per-unit').val(data.price_per_unit);
                    $('#aggregation-quantity').val(data.quantity);
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-aggregation', function (e) {
                e.preventDefault();

                var aggregation_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/produce-aggregations/' + aggregation_id + '/delete-ajax',
                        success: function (data) {
                            $("#aggregation_id_" + aggregation_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // approve
            $('body').on('click', '#approve-aggregation', function (e) {
                e.preventDefault();

                // let formData = $('#aggregation-approval-form').serialize();
                var formData = $(this).closest('form').serialize();
                let aggregation_id = $(this).data('id');

                $.ajax({
                    data: formData,
                    url: '/produce-aggregations/approve-ajax',
                    type: "POST",
                    dataType: 'json',
                    success: function (data) {
                        console.log(data);

                        let farmer_fullname = data.farmer.firstname + ' ' + data.farmer.lastname;
                        let aggregator_fullname = data.aggregator.firstname + ' ' + data.aggregator.lastname;
                        let approved = data.approved == 1 ? '<br><span class="text-success">Approved</span>' : '';

                        var aggregation = '<tr id="aggregation_id_' + data.id + '"><td>' + farmer_fullname + '</td>';
                            aggregation += '<td>' + data.produce_item.name + '</td><td>' + data.quantity + '</td>';
                            aggregation += '<td><span>Aggregated By: '+ aggregator_fullname +'</span><br><span>Date: '+ data.created_at +'</span>' + approved + '</td>';
                            aggregation += '<td><div class="btn-group form-actions" role="group" aria-label="Actions">';
                            // aggregation += '<a id="edit-aggregation" href="'+ data.id +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                            // aggregation += '<button id="delete-aggregation" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button>';
                            aggregation += '</div></td></tr>';

                        $("#aggregation_id_" + data.id).replaceWith(aggregation);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        // console.warn(xhr.responseText)
                        console.log(JSON.stringify(jqXHR));
                        console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                        $('#modal-save').html('Save');
                    }
                });
            });

            // submit
            if ($("#aggregation-form").length > 0) {
                $("#aggregation-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#aggregation-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/produce-aggregations/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                let farmer_fullname = data.farmer.firstname + ' ' + data.farmer.lastname;
                                let aggregator_fullname = data.aggregator.firstname + ' ' + data.aggregator.lastname;
                                let approved = data.approved == 1 ? '<br><span class="text-success">Approved</span>' : '';

                                var aggregation = '<tr id="aggregation_id_' + data.id + '"><td>' + farmer_fullname + '</td>';
                                    aggregation += '<td>' + data.produce_item.name + '<br><small><b>Produce:</b> ' + data.produce_item.produce.name + ' | <b>Units:</b> ' + data.produce_item.produce_unit.name + '</small></td><td>' + data.quantity + '</td>';
                                    aggregation += '<td><span>Aggregated By: '+ aggregator_fullname +'</span><br><span>Date: '+ data.created_at +'</span>' + approved + '</td>';
                                    aggregation += '<td><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    aggregation += '<a id="edit-aggregation" href="'+ data.id +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    aggregation += '<button id="delete-aggregation" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button>';
                                    // if(!data.approved) aggregation += '<form id="aggregation-approval-form" class="d-inline" method="post"><?php echo csrf_field(); ?><input type="hidden" name="id" value="'+ data.id +'"><button type="submit" id="approve-aggregation" class="btn btn-warning btn-sm ml-1" data-toggle="tooltip" title="Approve" data-original-title="Approve" data-id="'+ data.id +'"><i class="fas fa-check-double"></i> Approve</button></form>';
                                    aggregation += '</div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     aggregation
                                    // ]);

                                if (actionType == "create-aggregation") {
                                    $('#aggregation-list').prepend(aggregation);
                                } else {
                                    $("#aggregation_id_" + data.id).replaceWith(aggregation);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make( (Auth::user()->isAdmin()) ? 'layouts.admin' : 'layouts.fo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/produce-aggregations/index.blade.php ENDPATH**/ ?>