<?php $__env->startSection('title'); ?>
    Twalisha Trading | Financing Requests
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
    <h4 class="text-white page-title">Financing Requests</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Orders</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Financing Requests</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">

        <a href="<?php echo e(route('credit_requests.index')); ?>" class="btn btn-white btn-border btn-round ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <h5 class="text-right"></h5>

                    
                    <?php if($creditwithorders->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >
                                
                                <thead>
                                    <tr>
                                        <th>Input Order#ID</th>
                                        <?php if(Auth()->user()->isAdmin()): ?>
                                        <th>Farmer Organization</th>
                                        <?php endif; ?>
                                        <th>Total Requests</th>
                                        <td>Status</td>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $creditwithorders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $creditwithorder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="">
                                            <td><a href="<?php echo e(route('credit_requests.show', $creditwithorder->id)); ?>"></a><?php echo e($creditwithorder->id); ?></td>
                                            <?php if(Auth()->user()->isAdmin()): ?>
                                            <td><?php echo e($creditwithorder->inputOrder->organisation_name); ?></td>
                                            <?php endif; ?>
                                            <td><?php echo e($creditwithorder->orderItems->count('quantity')); ?></td>
                                            <td>
                                            <?php if($creditwithorder->approved == 0): ?>
                                            <l>Pending</l>
                                            <?php elseif($creditwithorder->approved == 1): ?>
                                             <l>In process</l>
                                             <?php elseif($creditwithorder->approved == 2): ?>
                                             <l>Completed</l>
                                             <?php endif; ?>
                                             </td>
                                            
                                            <td><?php echo e($creditwithorder->created_at); ?></td>
                                            <td><a class="btn btn-sm btn-success" href="<?php echo e(route('credit_requests.show', $creditwithorder->id)); ?>">View Requests
                                                </a></td>
                                                
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                    <th>Input Order#ID</th>
                                    <?php if(Auth()->user()->isAdmin()): ?>
                                        <th>Farmer Organization</th>
                                        <?php endif; ?>
                                        <th>Total Amount</th>
                                        <td>Status</td>
                                        <th>Created On</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
                </div>
            </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                // "pageLength": 5,
            });
        });
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make((Auth::user()->isAdmin()) ? 'layouts.admin' : 'layouts.fo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/credit_requests/index.blade.php ENDPATH**/ ?>