<?php $__env->startSection('title'); ?>
    Twalisha Trading | Financing Requests
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
    <h4 class="text-white page-title">Financing Requests</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Orders</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Financing Requests</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">

        <a href="<?php echo e(route('input_orders.index')); ?>" class="btn btn-white btn-border btn-round ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <h5 class="text-right"></h5>

                    
                    <?php if($credit->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >
                                
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Requested Amount</th>
                                        <th>Credit Limit</th>
                                        <td>Order</td>
                                        <th>Created On</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $credit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="">
                                            <td><a href=""><?php echo e($credit->farmer->id); ?></a></td>
                                            <td><?php echo e($credit->farmer->fullname); ?></td>
                                            <td><?php echo e($credit->price); ?></td>
                                            <td><?php echo e($credit->farmer->balance); ?></td>
                                            <td><a href="<?php echo e(route('input_orders.show',$credit->order_id)); ?>">View Order</a></td>
                                            <td><?php echo e($credit->created_at); ?></td>
                                                
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                    <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Requested Amount</th>
                                        <th>Credit Limit</th>
                                        <td>Order</td>
                                        <th>Created On</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
                </div>
            </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/credit_requests.blade.php ENDPATH**/ ?>