<?php
    if(Auth::user()->isAdmin()) {
        $layout = 'layouts.admin';
    } elseif(Auth::user()->getRelatedTrader()->isAgroDealer()) {
        $layout = 'layouts.ad';
    } elseif(Auth::user()->getRelatedTrader()->isFarmerOrganisation()) {
        $layout = 'layouts.fo';
    }
?>


<?php $__env->startSection('title'); ?>
    Twalisha Trading | Add Input Order Items
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
    <h4 class="page-title">Input Order Items | Add Items</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Orders</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Order Items</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
    <a href="#" class="btn btn-primary btn-round btn-sm" data-toggle="modal" data-target="#input-order-crud-modal">
            <span class="btn-label"><i class="fa fa-plus"></i></span> Add Input Order Items
        </a>
        <a href="<?php echo e(route('input_orders.index')); ?>" class="btn btn-white btn-border btn-round ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <!-- Modal -->
    <div id="input-order-crud-modal">
                <form id="input-order-form" name="input-order-form" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="body">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="input-order-id">
                            <div class="form-group">
                                <label for="input-order-item-farmer-id">Farmer</label>
                                <select id="input-order-item-farmer-id" name="trader_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <?php $__currentLoopData = $agfarmers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $farmer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($farmer->user_id); ?>" data-credit="<?php echo e($farmer->user->wallet->credit_limit); ?>" data-price="<?php echo e($farmer->user->wallet->float_bal); ?>"><?php echo e($farmer->user->lastname); ?> <?php echo e($farmer->user->firstname); ?>- <?php echo e($farmer->user->phone); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div id="repeater">
                                <div id="input-order-item-repeater-1">
                                    <!-- Repeater Items -->
                                    <div class="row">
                                        <div class="col-md-6 form-group form-floating-label"> 
                                            <label for="input-order-item-input-id" class="control-label">Input to purchase</label>
                                            <input type="text" name="input_order_item[1][price_per_unit]" id="input-order-item-price" class="input-order-item-price">
                                            <select id="input-order-item-input-id" name="input_order_item[1][input_id]" class="form-control input-order-item-input-id" style="width: 100%; border-color: #ebedf2;">
                                                <option value="">- Select -</option>
                                                <?php $__currentLoopData = $inputsagro; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $input): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option data-price="<?php echo e($input->price_per_unit); ?>" data-units="<?php echo e($input->input_unit->abbreviation); ?>" value="<?php echo e($input->id); ?>"><?php echo e($input->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6 form-group form-floating-label">
                                            <label for="input-order-item-quantity">Quantity <span class="quantity-label"></span></label>
                                            <div class="input-group">
                                                <input name="input_order_item[1][quantity]" onkeyup="calculateSum();" type="number" id="input-order-item-quantity" class="form-control" placeholder="Quantity">
                                            </div>
                                        </div>
                                        <div class="col-md-6 form-group form-floating-label">
                                            <label for="input-order-item-total">Total price <span class="total-label"></span></label>
                                            <div class="input-group">
                                                <input name="input_order_item[1][total]" type="number" id="input-order-item-total" class="form-control" disabled placeholder="Total">
                                            </div>
                                        </div>
                                        <div class="col-md-6 form-group form-floating-label">
                                            <label for="input-order-item-financing">Financing<span class="financing-label"></span></label>
                                            <div class="input-group">
                                            <select id="input-order-item-financing" name="financing" class="form-control select2" >
                                                <option value="">- Select Mode -</option>
                                            </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 form-group form-floating-label">
                                            <label for="input-order-item-date">Expected date<span class="date-label"></span></label>
                                            <div class="input-group">
                                                <input name="input_order_item[1][date]" type="date" id="input-order-item-date" class="form-control" placeholder="Expecteddate">
                                            </div>
                                        </div>
                                        <div class="col-md-6 form-group form-floating-label">
                                            <label for="input-order-item-description">Description<span class="date-label"></span></label>
                                            <div class="input-group">
                                            <textarea name="input_order_item[1][description]" id="input-order-item-description" class="form-control"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                       
                        <!-- Repeater Add Btn -->
                        <button id="add-input-order-item" class="btn btn-dark btn-round btn-sm"><i class="fas fa-plus"></i> Add Item</button>
                    </div>
                    <div class="modal-footer">
                        <h5>Items:<l id="items">0</l><h5><h5>Credit Totals:<l id="credits">0</l><h5><h5>Wallet Totals:<l id="credits">0</l><h5>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
    </div>
</div>
</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            
            function sum() {
            var txtFirstNumberValue = document.getElementById('input-order-item-quantity').value;
            var txtSecondNumberValue = document.getElementById('input-order-item-price').value;
            if (txtFirstNumberValue == "")
                txtFirstNumberValue = 0;
            if (txtSecondNumberValue == "")
                txtSecondNumberValue = 0;

            var result = parseInt(txtFirstNumberValue) * parseInt(txtSecondNumberValue);
            if (!isNaN(result)) {
                document.getElementById('input-order-item-total').value = result;
            }
        }


            $('#input-order-crud-modal').on('shown.bs.modal', function() {
                $('#input-order-item-farmer-id').select2({
                    dropdownParent: $('#input-order-crud-modal')
                });
            });
            $('#input-order-item-farmer-id').on('change', function(){
            var price = $(this).children('option:selected').data('price');
            var credit = $(this).children('option:selected').data('credit');
            $('#input-order-item-financing').empty();
            $('#input-order-item-financing').append("<option value=''>-Select Mode-</option><option value='wallet'>Wallet [KSh " + price + "]</option><option value='credit'>Credit[ Ksh "+credit +"]</option>");
        });

            $('body').on("select2:select", "#input-order-item-farmer-id", function(e) {
                let contract_select = $('.input-order-item-input-id');
                contract_select
                    .empty()
                    .append(
                        $('<option />')  // Create new <option> element
                            .text("- Select -") // Set textContent
                            .prop('selected', true)
                    );
                $('.input-order-item-price').val('');
                $('.quantity-label').text('');

                var selected = e.params.data;
                if(selected.id) {
                    $.ajax({
                        url: '/traders/get-items/' + selected.id,
                        dataType: 'json',
                        type: "GET",
                        success: function (data) {
                            //populate #input-order-item-input-id
                            $.each(data, function (key, datum) {
                                contract_select
                                    .append($('<option />')  // Create new <option> element
                                    .val(datum.id)            // Set value as "Hello"
                                    .text(datum.name+' @'+datum.price_per_unit+' /'+datum.input_unit.abbreviation) // Set textContent as "Hello"
                                    .data({                  // Set multiple data-* attributes
                                        price: datum.price_per_unit,
                                        units: datum.input_unit.name
                                    })
                                );
                            })
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            $('body').on('click', '#add-input-order-item', function(e) {
                e.preventDefault();
                klone();
            });

            function klone() {
                var $div = $('div[id^="input-order-item-repeater-"]:last');
                var num = parseInt( $div.prop("id").match(/\d+/g), 10 ) + 1;
                var $klon = $div.clone(true).prop('id', 'input-order-item-repeater-' + num );
                $klon.find('input, select').each(function() {
                    this.value= "";
                    let name_number = this.name.match(/\d+/);
                    name_number++;
                    this.name = this.name.replace(/\[[0-9]\]+/, '['+name_number+']')
                });

                // Finally insert $klon after the last div
                // $div.after( $klon );
                $klon.appendTo('#repeater');
            }

            $('body').on("change",".input-order-item-input-id", function(e) {
                $(this).closest('.row').find('.input-order-item-price').val('');
                $(this).closest('.row').find('.quantity-label').text('');

                let price = $(this).find(':selected').data('price');
                let units = $(this).find(':selected').data('units');

                if(price !== undefined) $(this).closest('.row').find('.input-order-item-price').val(price);
                if(units !== undefined) $(this).closest('.row').find('.quantity-label').text('('+units+')');
            });

            $('#input-orders-list').DataTable({
                // "pageLength": 5,
            });

            // create
            $('body').on('click', '#create-input-order', function(e) {
                e.preventDefault();

                $('#modal-save').val("create-input-order");
                $('#input-order-form').trigger("reset");
                $('#input-order-id').val('');
                $('#input-order-item-farmer-id').val('').trigger('change');
                $('#input-order-item-input-id')
                    .empty()
                    .val('')
                    .trigger('change')
                    .append(
                        $('<option />')
                            .text("- Select -")
                            .prop('selected', true)
                    )
                $('#input-order-item-quantity').val('');
                $('#input-order-item-total').val('');
                $('#input-order-item-farmer-id').val('');
                $('#input-order-item-input-id').val('');
                $('#input-order-item-financing').val('');
                $('#input-order-item-date').val('');
                $('#input-order-item-description').val('');
                $('#modal-title').html("Add Input Order Items");
                $('#input-order-item-quantity').val('');
                $('#input-order-crud-modal').modal('show');
            });

            // edit
            $('body').on('click', '#edit-input-order', function (e) {datedate
                e.preventDefault();
                var produce_order_id = $(this).data('id');

                $.get('/input-orders/' + produce_order_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit Produce Collection");
                    $('#modal-save').val("edit-input-order");

                    $('#input-order-id').val(data.id);
                    $('#input-order-item-farmer-id').select2();
                    $('#input-order-item-farmer-id')
                        .val(data.trader_id)
                        .trigger({
                            type: 'select2:select',
                            params: {
                                data: {id: data.trader_id},
                            }
                        });

                    $.each(data.input_order_items, function (key, datum) {
                        console.log(key, datum);
                    })
                    // $('#input-order-input-id').val(data.input_id).trigger('change');
                    // $('#input-order-quantity').val(data.quantity);
                    // $('#input-order-price-per-unit').val(data.price_per_unit);
                    $('#input-order-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-input-order', function (e) {
                e.preventDefault();

                var produce_order_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/input-orders/' + produce_order_id + '/delete-ajax',
                        success: function (data) {
                            $("#produce_order_id_" + produce_order_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // approve
            $('body').on('click', '#approve-input-order', function (e) {
                e.preventDefault();

                // let formData = $('#input-order-approval-form').serialize();
                var formData = $(this).closest('form').serialize();
                let produce_order_id = $(this).data('id');

                $.ajax({
                    data: formData,
                    url: '/input-orders/approve-ajax',
                    type: "POST",
                    dataType: 'json',
                    success: function (data) {
                        console.log(data);

                        let approved = data.approved == 1 ? '<i class="fa fa-check"></i>' : '';

                        var produce_order = '<tr id="produce_order_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.id + '</a></td>';
                            produce_order += '<td>' + data.trader.organisation_name + '</td><td>' + data.input_order_items_count + '</td><td>' + data.total + '</td><td>' + approved + '</td>';
                            produce_order += '<td><div class="btn-group form-actions" role="group" aria-label="Actions">';
                            produce_order += '<a id="edit-input-order" href="'+ data.id +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                            produce_order += '<button id="delete-input-order" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button>';
                            produce_order += '<button type="button" class="btn btn-dark btn-sm" title="Deliver" data-original-title="Deliver" data-id=""data-toggle="modal" data-target="#modal-default-'+ data.id +'"><i class="fas fa-truck-moving"></i> Deliver</button>'
                            produce_order += '</div></td></tr>';

                        $("#produce_order_id_" + data.id).replaceWith(produce_order);
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        // console.warn(xhr.responseText)
                        console.log(JSON.stringify(jqXHR));
                        console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                        $('#modal-save').html('Save');
                    }
                });
            });

            // submit
            if ($("#input-order-form").length > 0) {
                $("#input-order-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#input-order-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/input-orders/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {order
                                console.log(data);
                                let approved = data.approved == 1 ? '<i class="fa fa-check"></i>' : '';

                                var produce_order = '<tr id="produce_order_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.id + '</a></td>';
                                    produce_order += '<td>' + data.trader.organisation_name + '</td><td>' + data.input_order_items_count + '</td><td>' + data.total + '</td><td>' + approved + '</td>';
                                    produce_order += '<td><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    produce_order += '<a id="edit-input-order" href="'+ data.id +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    produce_order += '<button id="delete-input-order" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button>';
                                    if(!data.approved) produce_order += '<form id="input-order-approval-form" class="d-inline" method="post"><input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>"><input type="hidden" name="id" value="'+ data.id +'"><button type="submit" id="approve-input-order" class="btn btn-warning btn-sm ml-1" data-toggle="tooltip" title="Approve" data-original-title="Approve" data-id="'+ data.id +'"><i class="fas fa-check-double"></i> Approve</button></form>';
                                    produce_order += '</div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     produce_order
                                    // ]);

                                if (actionType == "create-input-order") {
                                    $('#input-order-list').prepend(produce_order);
                                } else {
                                    $("#produce_order_id_" + data.id).replaceWith(produce_order);
                                }

                                $('#modal-save').html('Save');
                                $('#input-order-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
        function calculateSum() {

        var sum = 0;
        //iterate through each textboxes and add the values
        $("#input-order-item-quantity").each(function() {

            //add only if the value is number
            if(!isNaN(this.value) && this.value.length!=0) {
                sum += parseFloat(this.value);
            }

        });
        //.toFixed() method will roundoff the final sum to 2 decimal places
        $("#items").html(sum.toFixed(2));
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/input_orders/create.blade.php ENDPATH**/ ?>