<?php
    if(Auth::user()->isAdmin()) {
        $layout = 'layouts.admin';
    } elseif(Auth::user()->getRelatedTrader()->isAgroDealer()) {
        $layout = 'layouts.ad';
    } elseif(Auth::user()->getRelatedTrader()->isFarmerOrganisation()) {
        $layout = 'layouts.fo';
    }
?>


<?php $__env->startSection('title'); ?>
    Twalisha Trading | Edit Input
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
    <h4 class="text-white page-title">Edit Input</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Inputs</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(route('inputs.index')); ?>" class="btn btn-white btn-border btn-round ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <h5 class="text-right"><strong>Input order item ID:</strong> #</h5>
                    <form action="<?php echo e(route('input_orders.update', $item->id)); ?>" method="post">
                        <?php echo method_field('PUT'); ?>
                        
                        <?php echo $__env->make("input_orders._form", ['buttonText' => "Update"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/input_orders/edit.blade.php ENDPATH**/ ?>