<?php $__env->startSection('title'); ?>
    Twalisha Trading | Produce Deliveries On Transit
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Produce Deliveries On Transit</h4>
        

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">On Transit</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <?php if(isset($trader)): ?>
            <a href="" class="btn btn-primary btn-round btn-sm">
                <i class="fa fa-plus"></i>
            </a>
        <?php endif; ?>

        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                <?php if($errors->any()): ?>
                        <div class="alert alert-danger alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                           <strong>Error! </strong>There were some errors with inputs.
                         <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    </div>

                <?php endif; ?>
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($deliveries->count()): ?>
                        <div class="table-responsive">
                            <table  id="inputs-list" class="display table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>S/No</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Produce</th>
                                        <th>Driver</th>
                                        <th>Vehicle</th>
                                        <th>Dates</th>
                                        <th>Status</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                    <th>S/No</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Produce</th>
                                        <th>Driver</th>
                                        <th>Vehicle</th>
                                        <th>Dates</th>
                                        <th>Status</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="aggregation-list">
                                    <?php $__currentLoopData = $deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($delivery->id); ?>">
                                            <td> <?php echo e(++$i); ?></td>

                                            <td><?php echo e($delivery->produce_collection->contract_detail->produce_item->trader->organisation_name); ?> </td>
                                            <td><?php echo e($delivery->produce_collection->contract_detail->contract->trader->organisation_name); ?></td>
                                            <td><?php echo e($delivery->produce_collection->contract_detail->produce_item->produce->name); ?>

                                            <td><?php echo e($delivery->delivery->firstname); ?> <?php echo e($delivery->delivery->lastname); ?></td>
                                            <td><?php echo e($delivery->deliveries->make); ?> <?php echo e($delivery->deliveries->plate); ?></td>
                                            <td><b>Picking Date:</b> <?php echo e(Str::limit($delivery->deliveryRequests['picking_time'], 10,'.')); ?><br>
                                            <b>Delivery Date:</b> <?php echo e(Str::limit($delivery->deliveryRequests['delivery_time'], 10,'.')); ?></td>
                                            <td>
                                                <?php if($delivery->status == 3): ?>
                                                   <span class="badge badge-success">Received</span>
                                                <?php elseif($delivery->status == 2): ?>
                                                   <span class="badge badge-info">Completed</span>
                                                <?php elseif($delivery->status == 1): ?>
                                                   <span class="badge badge-warning">In Process</span>
                                                <?php else: ?>
                                                   <span class="badge badge-danger">Pending</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                <button type="button" name="view" class="btn btn-success btn-sm" title="view" data-original-title="view" data-id=""data-toggle="modal" data-target="#modal-default-<?php echo e($delivery->id); ?>">
                                                        <i class="fa fa-check"></i> View
                                                    </button>
                                            </td>
                                            <!--Modal Confirm receipt-->
                                        <div class="modal fade" id="confirm-<?php echo e($delivery->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Confirm Receipt | Order Ref#<?php echo e($delivery->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form name="confirm-receipt" method="post" action="<?php echo e(route('my-deliveries.store')); ?>">
                                                        <?php echo csrf_field(); ?>

                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            <input type="hidden" name="trader_id" value="<?php echo e($delivery->produce_collection->contract_detail->contract->trader_id); ?>">
                                                            <div class="form-group">
                                                                <label for="trader-id">State of produce at arrival</label>
                                                                <textarea class="form-control"name="state_of_arrival">
                                                                </textarea>
                                                                <label for="trader-id">Other Comments</label>
                                                                <textarea name="comment" class="form-control">
                                                                </textarea>

                                                                <input type="hidden" name="delivery_id" value="<?php echo e($delivery->id); ?>">
                                                                <input type="hidden" name="status" value="3">
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" name="confirm-receipt" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--/end modal confirm receipt-->
                                            <!-- Modal view-->

                                        <div class="modal fade" id="modal-default-<?php echo e($delivery->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Delivery Details#<?php echo e($delivery->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                   <div class="modal-body">

                                                   <?php if(Auth::user()->isAdmin() || Auth::user()->getRelatedTrader()->isTransporter()): ?>
                                                   <h3>From: <?php echo e($delivery->produce_collection->contract_detail->produce_item->trader->organisation_name); ?></h3>
                                                        <p>Located in: <?php echo e($delivery->produce_collection->contract_detail->produce_item->trader->physical_address); ?></p>
                                                        <p>Phone: 254<?php echo e($delivery->produce_collection->contract_detail->produce_item->trader->phone); ?></p>
                                                            <p>Email: <?php echo e($delivery->produce_collection->contract_detail->produce_item->trader->email); ?></p>
                                                        <h3>To: <?php echo e($delivery->produce_collection->contract_detail->contract->trader->organisation_name); ?></h3>
                                                        <p>Located in: <?php echo e($delivery->produce_collection->contract_detail->contract->trader->physical_address); ?></p>
                                                        <p>Phone: 254<?php echo e($delivery->produce_collection->contract_detail->contract->trader->phone); ?></p>
                                                        <p>Email: <?php echo e($delivery->produce_collection->contract_detail->contract->trader->email); ?></p>
                                                        <?php endif; ?>
                                                        <h3>Item Details</h3>
                                                        <?php echo e($delivery->produce_collection->quantity); ?> Kgs. of <?php echo e($delivery->produce_collection->contract_detail->produce_item->produce->name); ?>

                                                        <?php if($delivery->status == 3): ?>
                                                        <h3>Acknowlegement</h3>
                                                        <p>State of goods: <?php echo $delivery->deliveryAcknowledgement[0]->state_of_arrival; ?></p>
                                                        <p>Other Comments: <?php echo $delivery->deliveryAcknowledgement[0]->comment; ?></p>
                                                        <?php endif; ?>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end modal -->
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                              </tr>

                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/on-transit/index.blade.php ENDPATH**/ ?>