<?php $__env->startSection('title'); ?>
    Twalisha Trading | Transport Requests
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Delivery Requests</h4>
        

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Delivery</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        
            <!-- <a href="" class="btn btn-primary btn-round btn-sm">
                <span class="btn-label"><i class="fa fa-plus"></i></span> Add Delivery
            </a> -->
        <a href="<?php echo e(route('tdashboard')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                <?php if($errors->any()): ?>
                        <div class="alert alert-danger alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                           <strong>Error! </strong>There were some errors with inputs. 
                         <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul> 
                    </div>
                    
                <?php endif; ?>
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($requests->count()): ?>
                        <div class="table-responsive">
                            <table  id="inputs-list" class="display table table-striped table-hover">
                            <thead>
                                    <tr>
                                        <th>S/No</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Produce</th>
                                        <th>Quantity</th>
                                        
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>S/No</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Produce</th>
                                        <th>Quantity</th>
                                        
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="aggregation-list">
                                    <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($request->id); ?>">
                                            <td> <?php echo e(++$i); ?></td>
                                            <td><?php echo e($request->produceOrder->produce_order_items[0]->contract->produce->produce_items[0]->trader->organisation_name); ?> </td>
                                            <td><?php echo e($request->produceOrder->trader->organisation_name); ?></td>
                                            <td><?php echo e($request->produceOrder->produce_order_items[0]->contract->produce->produce_items[0]->produce->name); ?></td>
                                            <td><?php echo e($request->produceOrder->produce_order_items->sum('quantity')); ?> Kgs.</td>
                                            <!-- <td><?php if($request->status == 1): ?>
                                                   <span class="text-warning">Taken</span>
                                                   <?php else: ?>
                                                   <span class="text-success">Open</span>
                                                <?php endif; ?> </td> -->
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <button type="button" name="view" class="btn btn-success btn-sm" title="view" data-original-title="view" data-id=""data-toggle="modal" data-target="#modal-default1-<?php echo e($request->id); ?>">
                                                        <i class="fa fa-check"></i> View
                                                    </button>
                                                   
                                                    
                                                    
                                                    <button type="button" class="btn btn-info btn-sm" title="Accept" data-original-title="Accept" data-id=""data-toggle="modal" data-target="#modal-default-<?php echo e($request->id); ?>">
                                                        <i class="fa fa-check"></i> Accept
                                                    </button>
                                                    
                                                    
                                                </div>

                                            </td>
                                            <!-- Modal Edit-->
   
                                        <div class="modal fade" id="modal-default-<?php echo e($request->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Delivery Ref#<?php echo e($request->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form name="store" action="<?php echo e(route('my-delivery-requests.store')); ?>" method="post">
                                                    <?php echo csrf_field(); ?>

                                                        <div class="modal-body">
                                                            
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            
                                                            <div class="form-group">
                                                                
                                                                <label for="">Driver:</label>
                                                                <select class="form-control" name="driver_id" required>
                                                                <option value="">Select Driver</option>
                                                                <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($driver->id); ?>"><?php echo e($driver->firstname); ?> <?php echo e($driver->lastname); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                                <label for="">Vehicle:</label>
                                                                <select class="form-control" name="vehicle_id">
                                                                <option value="">Select Vehicle</option>
                                                                <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($vehicle->id); ?>"><?php echo e($vehicle->model); ?>-<?php echo e($vehicle->plate); ?> <?php echo e($vehicle->tonnage); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                                <input type="hidden" name="produce_order_id" value="<?php echo e($request->produceOrder->id); ?>">
                                                                <input type="hidden" name="id" value="<?php echo e($request->id); ?>">
                                                                <input type="hidden" name="status" value="1">
                                                                <input type="hidden" name="from_id" value="<?php echo e($request->produceOrder->produce_order_items[0]->contract->produce->produce_items[0]->trader->id); ?>">
                                                                <input type="hidden" name="to_id" value="<?php echo e($request->produceOrder->trader->id); ?>">
                                                                <input type="hidden" name="transporter_id" value="<?php echo e($request->transporter_id); ?>">
                                                            </div>
                                                        
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" name="store" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Modal view-->
   
                                        <div class="modal fade" id="modal-default1-<?php echo e($request->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Delivery Details#<?php echo e($request->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                   <div class="modal-body">

                                                        <h3>From: <?php echo e($request->produceOrder->produce_order_items[0]->contract->produce->produce_items[0]->trader->organisation_name); ?></h3> 
                                                        <p>Located in: <?php echo e($request->produceOrder->produce_order_items[0]->contract->produce->produce_items[0]->trader->physical_address); ?>| 
                                                         Phone: 254<?php echo e($request->produceOrder->produce_order_items[0]->contract->produce->produce_items[0]->trader->phone); ?> |
                                                         Email: <?php echo e($request->produceOrder->produce_order_items[0]->contract->produce->produce_items[0]->trader->email); ?></p> 
                                                        <h3>To: <?php echo e($request->produceOrder->trader->organisation_name); ?></h3> 
                                                        <p>Located in: <?php echo e($request->produceOrder->trader->physical_address); ?> | 
                                                        Phone: 254<?php echo e($request->produceOrder->trader->phone); ?> | 
                                                        Email: <?php echo e($request->produceOrder->trader->email); ?></p>
                                                        <h3>Item Details</h3>
                                                        <?php echo e($request->produceOrder->produce_order_items->sum('quantity')); ?> Kgs. of <?php echo e($request->produceOrder->produce_order_items[0]->contract->produce->produce_items[0]->produce->name); ?> 
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end modal -->
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                        </tr>
                                <!--start addmodal-->
                                        <div class="modal fade" id="modal-default" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Add Driver </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(route('my-delivery-requests.store')); ?>" method="post">
                                                        <?php echo csrf_field(); ?>

                                                        <div class="modal-body">
                                                            
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            
                                                            <div class="form-group">
                                                                <label for="license">License:</label>
                                                                <input class="form-control" type="text" name="licence_no">
                                                                <label for="">First Name:</label>   
                                                                <input class="form-control" type="text" name="firstname">
                                                                <label for="">Last Name:</label>
                                                                <input class="form-control" type="text" name="lastname">
                                                                
                                                            </div>
                                                        
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Update</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--end add modal-->
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                // "pageLength": 5,
            });
        });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.t', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/my-delivery-requests/index.blade.php ENDPATH**/ ?>