<?php echo csrf_field(); ?>
<div class="form-group">
    <label for="name">Name</label>
    <input type="text" name="name" id="name" value="<?php echo e(old('name', $trader_type->name ?? '')); ?>" class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" placeholder="Trader Type">

    <?php if($errors->has('name')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('name')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <label for="trader-type-description">Description</label>
    <textarea name="description" id="trader-type-description" class="form-control <?php echo e($errors->has('description') ? 'is-invalid' : ''); ?>" disabled><?php echo e(old('description', $trader_type->description ?? '')); ?></textarea>

    <?php if($errors->has('description')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('description')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<?php if( isset($buttonText) ): ?>
    <div class="form-group">
        <button type="submit" class="btn btn-primary btn-lg"><?php echo e($buttonText); ?></button>
    </div>
<?php endif; ?>
<?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/trader-types/_form.blade.php ENDPATH**/ ?>