<?php
    if(Auth::user()->isAdmin()) {
        $layout = 'layouts.admin';
    } elseif(Auth::user()->getRelatedTrader()->isBulkSeller()) {
        $layout = 'layouts.s';
    } elseif(Auth::user()->getRelatedTrader()->isBulkBuyer()) {
        $layout = 'layouts.b';
    } elseif(Auth::user()->getRelatedTrader()->isAgroDealer()) {
        $layout = 'layouts.ad';
    } elseif(Auth::user()->getRelatedTrader()->isTransporter()) {
        $layout = 'layouts.t';
    } elseif(Auth::user()->getRelatedTrader()->isFarmerOrganisation()) {
        $layout = 'layouts.fo';
    }
?>


<?php $__env->startSection('title'); ?>
    Twalisha Trading | Organisation - <?php echo e($trader->organisation_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Organisation - <?php echo e($trader->organisation_name); ?></h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Organisations</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-trader" href="<?php echo e(route('traders.edit', $trader->id)); ?>" class="btn btn-primary btn-round btn-sm">
            <span class="btn-label"><i class="fa fa-plus"></i></span> Edit Organisation
        </a>

        <a href="<?php echo e(route('traders.index')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                
                                <li class="nav-item">
                                    <a class="nav-link active" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="true"><i class="far fa-building"></i> Profile</a>
                                </li>

                                
                                <?php if($trader->isFarmerOrganisation()): ?>
                                    <li class="nav-item">
                                        <a class="nav-link" id="members-tab" data-toggle="tab" href="#members" role="tab" aria-controls="members" aria-selected="false"><i class="far fa-address-card"></i>  Members</a>
                                    </li>
                                <?php endif; ?>

                                
                                <li class="nav-item">
                                    <a class="nav-link" id="contacts-tab" data-toggle="tab" href="#contacts" role="tab" aria-controls="contacts" aria-selected="false"><i class="fas fa-users"></i> Contact Persons</a>
                                </li>

                                
                                <?php if($trader->isFarmerOrganisation()): ?>
                                    <li class="nav-item">
                                        <a class="nav-link" id="produce-items-tab" data-toggle="tab" href="#produce-items" role="tab" aria-controls="contacts" aria-selected="false"><i class="fas fa-seedling"></i> Produce Items</a>
                                    </li>
                                <?php endif; ?>

                                
                                <?php if($trader->isBulkBuyer()): ?>
                                    <li class="nav-item">
                                        <a class="nav-link" id="contracts-tab" data-toggle="tab" href="#contracts" role="tab" aria-controls="contracts" aria-selected="false"><i class="far fa-folder-open"></i> Contracts</a>
                                    </li>
                                <?php endif; ?>

                                
                                <?php if($trader->isBulkSeller()): ?>
                                    <li class="nav-item">
                                        <a class="nav-link" id="input-items-tab" data-toggle="tab" href="#input-items" role="tab" aria-controls="input-items" aria-selected="false"><i class="fas fa-reply-all"></i> Input Items</a>
                                    </li>
                                <?php endif; ?>

                                
                                <?php if($trader->isBulkSeller()): ?>
                                    <li class="nav-item">
                                        <a class="nav-link" id="networks-tab" data-toggle="tab" href="#networks" role="tab" aria-controls="networks" aria-selected="false"><i class="fas fa-sitemap"></i> Networks</a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                            <div class="tab-content" id="myTabContent">
                                
                                <div id="profile" role="tabpanel" aria-labelledby="profile-tab" class="tab-pane fade show active">
                                    <div class="alert alert-info shadow-none">
                                        <dl class="row">
                                            <dt class="col-md-3">Organisation</dt>
                                            <dd class="col-md-9"><?php echo e($trader->organisation_name); ?> (<?php echo e($trader->trader_type->name); ?>)</dd>
                                            <dt class="col-md-3">Phone</dt>
                                            <dd class="col-md-9"><?php echo e($trader->phone); ?></dd>
                                            <dt class="col-md-3">Email</dt>
                                            <dd class="col-md-9"><?php echo e($trader->email); ?></dd>
                                            <dt class="col-md-3">Postal Address</dt>
                                            <dd class="col-md-9"><?php echo e($trader->postal_address); ?></dd>
                                            <dt class="col-md-3">Physical Address</dt>
                                            <dd class="col-md-9"><?php echo e($trader->physical_address); ?></dd>
                                            <dt class="col-md-3">County</dt>
                                            <dd class="col-md-9"><?php echo e($trader->county); ?></dd>
                                            <dt class="col-md-3">Ward</dt>
                                            <dd class="col-md-9"><?php echo e($trader->ward); ?></dd>
                                            <dt class="col-md-3">Preferred Regions</dt>
                                            <dd class="col-md-9"><?php echo e($trader->preferred_regions); ?></dd>
                                        </dl>
                                    </div>
                                </div>

                                
                                <?php if($trader->isFarmerOrganisation()): ?>
                                    <div id="members" role="tabpanel" aria-labelledby="members-tab" class="tab-pane fade">
                                        <div class="text-right mb-3">
                                            <a id="create-trader-member" href="#" class="btn btn-primary btn-round btn-sm">Add a Member</a>
                                            <hr>
                                        </div>
                                        <?php if($trader_members->count()): ?>
                                            <?php echo $__env->make('trader-members._index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                        <?php else: ?>
                                            <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endif; ?>

                                    </div>
                                <?php endif; ?>

                                
                                <div id="contacts" role="tabpanel" aria-labelledby="contacts-tab" class="tab-pane fade">
                                    <div class="panel panel-default">
                                        <div class="text-right mb-3">
                                            <a id="create-trader-contact" href="#" class="btn btn-primary btn-round btn-sm">Add a Contact Person</a>
                                            <hr>
                                        </div>
                                        <?php if($trader_contacts->count()): ?>
                                            <?php echo $__env->make('trader-contacts._index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                        <?php else: ?>
                                            <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                
                                <?php if($trader->isFarmerOrganisation()): ?>
                                    <div id="produce-items" role="tabpanel" aria-labelledby="produce-items-tab" class="tab-pane fade">
                                        <?php if(Auth::user()->isAdmin()): ?>
                                            <div class="text-right mb-3">
                                                <a id="create-produce-item" href="#" class="btn btn-primary btn-round btn-sm">Add a Produce Item</a>
                                                <hr>
                                            </div>
                                        <?php endif; ?>

                                        <?php if($produce_items->count()): ?>
                                            <?php echo $__env->make('produce-items._index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                        <?php else: ?>
                                            <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endif; ?>

                                    </div>
                                <?php endif; ?>

                                
                                <?php if($trader->isBulkBuyer()): ?>
                                    <div id="contracts" role="tabpanel" aria-labelledby="contracts-tab" class="tab-pane fade">
                                        <div class="panel panel-default">
                                            <?php if(Auth::user()->isAdmin()): ?>
                                                <div class="text-right mb-3">
                                                    <a id="create-trader-contract" href="#" class="btn btn-primary btn-round btn-sm">Add a Contract</a>
                                                    <hr>
                                                </div>
                                            <?php endif; ?>

                                            <?php if($trader_contracts->count()): ?>
                                                <?php echo $__env->make('trader-contracts._index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                            <?php else: ?>
                                                <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                
                                <?php if($trader->isBulkSeller()): ?>
                                    <div id="input-items" role="tabpanel" aria-labelledby="input-items-tab" class="tab-pane fade">
                                        <div class="text-right mb-3">
                                            <a id="create-input-item" href="#" class="btn btn-primary btn-round btn-sm">Add an Input Item</a>
                                            <hr>
                                        </div>

                                        <?php if($input_items->count()): ?>
                                            <?php echo $__env->make('input-items._index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                        <?php else: ?>
                                            <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endif; ?>

                                    </div>
                                <?php endif; ?>

                                
                                <?php if($trader->isBulkSeller()): ?>
                                    <div id="networks" role="tabpanel" aria-labelledby="networks-tab" class="tab-pane fade">
                                        <div class="panel panel-default">
                                            <div class="text-right mb-3">
                                                <a id="create-trader-network" href="#" class="btn btn-primary btn-round btn-sm">Link an Agrodealer</a>
                                                <hr>
                                            </div>

                                            <?php if($trader_networks->count()): ?>
                                                <?php echo $__env->make('trader-networks._index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                            <?php else: ?>
                                                <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Trader Member Modal -->
    <?php if($trader->isFarmerOrganisation()): ?>
        <div class="modal fade" id="trader-members-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="trader-member-modal-title" id="trader-member-modal-title"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="trader-member-form" name="trader-member-form" method="post">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="trader-member-id">
                        <input type="hidden" name="trader_id" id="trader-member-trader-id" value="<?php echo e($trader->id); ?>">
                        <input type="hidden" name="user_id" id="trader-member-user-id">

                        <div class="modal-body">
                            <div class="form-row">
                                <div class="col form-group">
                                    <label for="trader-member-firstname">First Name*</label>
                                    <input name="firstname" id="trader-member-firstname" type="text" class="form-control" placeholder="First Name">
                                </div>
                                <div class="col form-group">
                                    <label for="trader-member-lastname">Last Name*</label>
                                    <input name="lastname" id="trader-member-lastname" type="text" class="form-control" placeholder="Last Name">
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col form-group">
                                    <label for="trader-member-email">Email*</label>
                                    <input name="email" id="trader-member-email" type="text" class="form-control" placeholder="Email">
                                </div>

                                <div class="col form-group">
                                    <label for="trader-member-phone">Phone Number*</label>
                                    <input name="phone" id="trader-member-phone" type="text" class="form-control" placeholder="Phone Number">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="trader-member-active">Active?</label>
                                <select name="active" id="trader-member-active" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <option value="1">Yes</option>
                                    <option value="0">No</option>
                                </select>
                            </div>
                            <hr>
                            <fieldset>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-member-username">Username*</label>
                                        <input name="username" id="trader-member-username" type="text" class="form-control" placeholder="Username">
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="col form-group">
                                        <label for="trader-member-password">Password*</label>
                                        <input name="password" id="trader-member-password" type="password" class="form-control" placeholder="Password">
                                    </div>
                                    <div class="col form-group">
                                        <label for="trader-member-confirm-password">Confirm Password*</label>
                                        <input name="confirm_password" id="trader-member-confirm-password" type="password" class="form-control"  placeholder="Confirm Password">
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="trader-member-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Trader Contact Modal -->
    <div class="modal fade" id="trader-contacts-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="trader-contact-modal-title" id="trader-contact-modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="trader-contact-form" name="trader-contact-form" method="post">
                    <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                    <input type="hidden" name="id" id="trader-contact-id">
                    <input type="hidden" name="trader_id" id="trader-contact-trader-id" value="<?php echo e($trader->id); ?>">

                    <div class="modal-body">
                        <?php if($trader->isFarmerOrganisation()): ?>
                            <fieldset>
                                <div class="form-group">
                                    <label for="trader-contact-user-id">Select a Member</label>
                                    <select id="trader-contact-user-id" name="user_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                        <option value="">- Select -</option>
                                        <?php $__currentLoopData = $trader_members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($member->user_id); ?>"><?php echo e($member->user->fullname); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </fieldset>
                        <?php endif; ?>

                        <div class="form-row">
                            <div class="col form-group">
                                <label for="trader-contact-firstname">First Name*</label>
                                <input name="firstname" id="trader-contact-firstname" type="text" class="form-control" placeholder="First Name">
                            </div>
                            <div class="col form-group">
                                <label for="trader-contact-lastname">Last Name*</label>
                                <input name="lastname" id="trader-contact-lastname" type="text" class="form-control" placeholder="Last Name">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col form-group">
                                <label for="trader-contact-email">Email*</label>
                                <input name="email" id="trader-contact-email" type="email" class="form-control" placeholder="Email">
                            </div>
                            <div class="col form-group">
                                <label for="trader-contact-phone">Phone*</label>
                                <input name="phone" id="trader-contact-phone" type="text" class="form-control" placeholder="Phone">
                            </div>
                        </div>
                        <hr>
                        <div class="form-group">
                            <label for="trader-contact-is-admin">Is Primary Contact?</label>
                            <select name="is_admin" id="trader-contact-is-admin" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="trader-contact-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Produce Item Modal -->
    <?php if($trader->isFarmerOrganisation()): ?>
        <div class="modal fade" id="trader-produce-items-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="produce-item-modal-title" id="produce-item-modal-title"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="produce-item-form" name="produce-item-form" method="post">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="produce-item-id">
                        <input type="hidden" name="trader_id" id="produce-item-trader-id" value="<?php echo e($trader->id); ?>">

                        <div class="modal-body">
                            <div class="form-group">
                                <label for="produce-item-produce-id">Produce</label>
                                <select id="produce-item-produce-id" name="produce_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <?php $__currentLoopData = $produces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($produce->id); ?>"><?php echo e($produce->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="produce-item-produce-unit-id">Produce Unit</label>
                                <select id="produce-item-produce-unit-id" name="produce_unit_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <?php $__currentLoopData = $produce_units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($produce_unit->id); ?>"><?php echo e($produce_unit->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="produce-item-quality">Quality</label>
                                <input type="text" name="quality" id="produce-item-quality" value="" class="form-control" placeholder="Quality">
                            </div>
                            <div class="row">
                            <div class="form-group col-md-6">
                                <label for="produce-item-price-per-unit">Price per Unit</label>
                                <input type="text" name="price_per_unit" id="produce-item-price-per-unit" value="" class="form-control" placeholder="Price per unit">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="produce-item-tonnage">Tonnage (in Kgs)</label>
                                <input type="text" name="tonnage" id="produce-item-tonnage" value="" class="form-control" placeholder="Tonnage (in Kgs)">
                            </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="produce-item-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Trader Contract Modal -->
    <?php if($trader->isBulkBuyer()): ?>
        <div class="modal fade" id="trader-contracts-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="trader-contract-modal-title" id="trader-contract-modal-title">Add Contract - <?php echo e($trader->organisation_name); ?></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="trader-contract-form" name="trader-contract-form" method="post" enctype="multipart/form-data">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="trader-contract-id">
                        <input type="hidden" name="trader_id" id="trader-contract-trader-id" value="<?php echo e($trader->id); ?>">
                        <input type="hidden" name="old_contract_file" id="trader-contract-old-file">

                        <div class="modal-body">
                            <div class="form-group">
                                <label for="trader-contract-name">Name</label>
                                <input type="text" name="name" id="trader-contract-name" value="" class="form-control" placeholder="Contract Name">
                            </div>
                            <div class="form-group">
                                <label for="trader-contract-file">Contract Document</label>
                                <input type="file" name="contract_file" id="trader-contract-file" class="form-control">
                            </div>
                            <hr>
                            <fieldset>
                                <legend>Contract Details</legend>

                                <div class="form-group row">
                                    <div class="col-md-6">
                                        <label for="trader-contract-produce-id">Produce</label>
                                        <select id="trader-contract-produce-id" name="produce_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <?php $__currentLoopData = $produces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($produce->id); ?>"><?php echo e($produce->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="trader-contract-tonnage">Tonnage (in Kgs)</label>
                                        <input type="text" name="tonnage" id="trader-contract-tonnage" value="" class="form-control" placeholder="Tonnage (in Kgs)">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-md-6">
                                        <label for="trader-contract-produce-unit-id">Produce Unit</label>
                                        <select id="trader-contract-produce-unit-id" name="produce_unit_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <?php $__currentLoopData = $produce_units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($produce_unit->id); ?>"><?php echo e($produce_unit->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="trader-contract-price-per-unit">Price per Unit</label>
                                        <input type="text" name="price_per_unit" id="trader-contract-price-per-unit" value="" class="form-control" placeholder="Price per Unit">
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="trader-contract-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Input Item Modal -->
    <?php if($trader->isBulkSeller()): ?>
        <div class="modal fade" id="trader-input-items-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="input-item-modal-title" id="input-item-modal-title"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="trader-input-item-form" name="trader-input-item-form" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                            <input type="hidden" name="id" id="input-item-id">
                            <input type="hidden" name="trader_id" id="input-item-trader-id" value="<?php echo e($trader->id); ?>">
                            <div class="form-group">
                                <label for="input-item-name">Name</label>
                                <input type="text" name="name" id="input-item-name" value="" class="form-control" placeholder="Name">
                            </div>
                            <div class="form-group">
                                <label for="input-item-input-id">Input</label>
                                <select id="input-item-input-id" name="input_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <?php $__currentLoopData = $inputs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $input): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($input->id); ?>"><?php echo e($input->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="input-item-input-unit-id">Input Unit</label>
                                <select id="input-item-input-unit-id" name="input_unit_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <?php $__currentLoopData = $input_units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $input_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($input_unit->id); ?>"><?php echo e($input_unit->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="row">
                            <div class="form-group col-md-6">
                                <label for="input-item-price-per-unit">Price per Unit</label>
                                <input type="text" name="price_per_unit" id="input-item-price-per-unit" value="" class="form-control" placeholder="Price per Unit">
                            </div>
                            <div class="form-group col-md-6">

                                <label for="input-item-listed">Listed?</label>
                                <select name="listed" id="input-listed" class="form-control">
                                    <option value="">- Select -</option>
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="input-item-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Trader Network Modal -->
    <?php if($trader->isBulkSeller()): ?>
        <div class="modal fade" id="trader-networks-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="trader-network-modal-title" id="trader-network-modal-title">Add Network - <?php echo e($trader->organisation_name); ?></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form id="trader-network-form" name="trader-network-form" method="post" enctype="multipart/form-data">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="trader-network-id">
                        <input type="hidden" name="trader_id" id="trader-network-trader-id" value="<?php echo e($trader->id); ?>">

                        <div class="modal-body">
                            <div class="form-group">
                                <label for="trader-network-type">Type</label>
                                <select id="trader-network-type" name="type" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    <option value="national">National</option>
                                    <option value="regional">Regional</option>
                                    <option value="last-mile">Last-mile</option>
                                </select>
                            </div>
                            <div class="form-group row">
                                <div id="trader-network-region" class="col d-none">
                                    <label for="trader-network-region-id">Region</label>
                                    <select id="trader-network-region-id" name="region_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                        <option value="">- Select -</option>
                                        <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($region->id); ?>"><?php echo e($region->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div id="trader-network-county" class="col d-none">
                                    <label for="trader-network-county-id">County</label>
                                    <select id="trader-network-county-id" name="county_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                        <option value="">- Select -</option>
                                        <?php $__currentLoopData = $counties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $county): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($county->id); ?>"><?php echo e($county->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <label for="trader-network-agrodealer-id">Agrodealer</label>
                                    <select id="trader-network-agrodealer-id" name="agrodealer_id" style="width: 100%; border-color: #ebedf2;" class="form-control">
                                        <option value="">- Select -</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="trader-network-description">Description</label>
                                <textarea id="trader-network-description" name="description" class="form-control"></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="trader-network-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    
    <script>
        function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
            try {
                decimalCount = Math.abs(decimalCount);
                decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

                const negativeSign = amount < 0 ? "-" : "";

                let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
                let j = (i.length > 3) ? i.length % 3 : 0;

                return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
            } catch (e) {
                console.log(e)
            }
        }

        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
        });
    </script>

    
    <script>
        $(document).ready(function () {
            // initialize datatable
            $('#trader-members-list').DataTable();

            // on click create-trader-member
            $('body').on('click', '#create-trader-member', function(e) {
                e.preventDefault();

                $('#trader-member-modal-save').val("create-trader-member");
                $('#trader-member-modal-title').html("Add Member");
                $('#trader-member-form').trigger("reset");

                $('#trader-member-id').val('');
                $('#trader-member-user-id').val('');
                $('#trader-member-firstname').val('');
                $('#trader-member-lastname').val('');
                $('#trader-member-email').val('');
                $('#trader-member-phone').val('');
                $('#trader-member-username').val('');
                $('#trader-member-password').val('');
                $('#trader-member-confirm-password').val('');
                $('#trader-member-active').val('').trigger("change");

                $('#trader-member-modal-title').html("Add a Member");
                $('#trader-members-crud-modal').modal('show');
            });

            // on click edit-trader-member
            $('body').on('click', '#edit-trader-member', function (e) {
                e.preventDefault();

                var trader_member_id = $(this).data('id');
                console.log("trader_member_id: " + trader_member_id);

                $.get('/trader-members/' + trader_member_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#trader-member-modal-title').html("Edit Member");
                    $('#trader-member-modal-save').val("edit-trader-member");

                    $('#trader-member-id').val(data.id);
                    $('#trader-member-user-id').val(data.user_id);
                    $('#trader-member-firstname').val(data.user.firstname);
                    $('#trader-member-lastname').val(data.user.lastname);
                    $('#trader-member-email').val(data.user.email);
                    $('#trader-member-phone').val(data.user.phone);
                    $('#trader-member-username').val(data.user.username);
                    $('#trader-member-password').val('');
                    $('#trader-member-confirm-password').val('');
                    $('#trader-member-active').val(data.active).trigger("change");

                    $('#trader-members-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#trader-member-modal-save').html('Save');
                })
            });

            // on click delete-trader-member
            $('body').on('click', '#delete-trader-member', function (e) {
                e.preventDefault();

                var trader_member_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if(confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-members/' + trader_member_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_member_id_" + trader_member_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // save trader-member (after create or edit)
            if ($("#trader-member-form").length > 0) {
                $("#trader-member-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-member-form').serialize();
                        let actionType = $('#trader-member-modal-save').val();
                        $('#trader-member-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-members/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                let active = data.active == 1 ? '<i class="fa fa-check"></i>' : '';

                                let trader_member = '<tr id="trader_member_id_' + data.id + '"><td><a href="#">' + data.user.firstname + ' ' + data.user.lastname + '</a></td>';
                                    trader_member += '<td>'+ data.user.username +'</td><td>' + data.user.email + '</td><td>' + data.user.phone + '</td><td class="text-center">'+ active +'</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader_member += '<button id="edit-trader-member" type="button" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</button>';
                                    trader_member += '<button id="delete-trader-member" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                if (actionType == "create-trader-member") {
                                    $('#trader-member-list').prepend(trader_member);
                                } else {
                                    $("#trader_member_id_" + data.id).replaceWith(trader_member);
                                }

                                $('#trader-member-modal-save').html('Save');
                                $('#trader-members-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#trader-member-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    
    <script>
        $(document).ready(function () {
            // initialize datatable
            $('#trader-contacts-list').DataTable();

            // on modal-shown
            $('#trader-contacts-crud-modal').on('shown.bs.modal', function() {
                $('#trader-contact-firstname').trigger('focus');

                $('#trader-contact-user-id').select2({
                    dropdownParent: $('#trader-contacts-crud-modal')
                });
            });

            // on select user
            $('#trader-contact-user-id').on('select2:select', function(e) {
                var selected = e.params.data;

                $.ajax({
                    url: '/users/get-user/' + selected.id,
                    dataType: 'json',
                    type: "GET",
                    success: function (data) {
                        $('#trader-contact-firstname').val(data.firstname);
                        $('#trader-contact-lastname').val(data.lastname);
                        $('#trader-contact-email').val(data.email);
                        $('#trader-contact-phone').val(data.phone);
                    },
                    error: function (data) {
                        console.log('Error:', data);
                    }
                });
            });

            // on click create-trader-contact
            $('body').on('click', '#create-trader-contact', function(e) {
                e.preventDefault();

                $('#trader-contact-modal-save').val("create-trader-contact");
                $('#trader-contact-modal-title').html("Add Member");
                $('#trader-contact-form').trigger("reset");

                $('#trader-contact-id').val('');
                $('#trader-contact-user-id').val('').trigger('change');
                $('#trader-contact-firstname').val('');
                $('#trader-contact-lastname').val('');
                $('#trader-contact-email').val('');
                $('#trader-contact-phone').val('');
                $('#trader-contact-is-admin').val('').trigger('change');

                $('#trader-contact-modal-title').html("Add Contact Person");
                $('#trader-contacts-crud-modal').modal('show');
            });

            // on click edit-trader-contact
            $('body').on('click', '#edit-trader-contact', function (e) {
                e.preventDefault();

                var trader_contact_id = $(this).data('id');

                $.get('/trader-contacts/' + trader_contact_id +'/edit-ajax', function (data) {
                    $('#trader-contact-modal-title').html("Edit Contact Person");
                    $('#trader-contact-modal-save').val("edit-trader-contact");

                    $('#trader-contact-id').val(data.id);
                    $('#trader-contact-user-id').val(data.user_id);
                    $('#trader-contact-firstname').val(data.firstname);
                    $('#trader-contact-lastname').val(data.lastname);
                    $('#trader-contact-email').val(data.email);
                    $('#trader-contact-phone').val(data.phone);
                    $('#trader-contact-is-admin').val(data.is_admin).trigger('change');

                    $('#trader-contacts-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#trader-contact-modal-save').html('Save');
                })
            });

            // on click delete-trader-contact
            $('body').on('click', '#delete-trader-contact', function (e) {
                e.preventDefault();

                var trader_contact_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if(confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-contacts/' + trader_contact_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_contact_id_" + trader_contact_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // save trader-contact (after create or edit)
            if ($("#trader-contact-form").length > 0) {
                $("#trader-contact-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-contact-form').serialize();
                        var actionType = $('#trader-contact-modal-save').val();
                        $('#trader-contact-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-contacts/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                // TODO: Add code to remove fa-check icon from all td.is-admin

                                let is_admin = (data.is_admin == 1) ? '<i class="fa fa-check"></i>' : '';
                                let trader_contact = '<tr id="trader_contact_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.firstname + ' ' + data.lastname + '</a></td>';
                                    trader_contact += '<td>' + data.email + '</td><td>' + data.phone + '</td><td class="text-center is-admin">'+ is_admin +'</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader_contact += '<a id="edit-trader-contact" href="#" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    trader_contact += '<button id="delete-trader-contact" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                if (actionType == "create-trader-contact") {
                                    $('#trader-contact-list').prepend(trader_contact);
                                } else {
                                    $("#trader_contact_id_" + data.id).replaceWith(trader_contact);
                                }

                                $('#trader-contact-modal-save').html('Save');
                                $('#trader-contacts-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#trader-contact-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    
    <script>
        $(document).ready(function () {
            // initialize datatable
            $('#produce-items-list').DataTable();

            // on modal-shown
            $('#trader-produce-items-crud-modal').on('shown.bs.modal', function() {
                $('#produce-item-name').trigger('focus');

                $('#produce-item-category_id').select2({
                    dropdownParent: $('#trader-produce-items-crud-modal')
                });
            });

            // on click create-produce-item
            $('#create-produce-item').click(function(e) {
                e.preventDefault();

                $('#produce-item-modal-save').val("create-produce-item");
                $('#produce-item-modal-title').html("Add Produce Item");
                $('#produce-item-form').trigger("reset");

                $('#produce-item-id').val('');
                $('#produce-item-produce-id').val('').trigger('change');
                $('#produce-item-produce-unit-id').val('').trigger('change');
                $('#produce-item-quality').val('');
                $('#produce-item-price-per-unit').val('');
                $('#produce-item-tonnage').val('');

                $('#trader-produce-items-crud-modal').modal('show');
            });

            // on click edit-produce-item
            $('body').on('click', '#edit-produce-item', function (e) {
                e.preventDefault();

                var produce_item_id = $(this).data('id');

                $.get('/produce-items/' + produce_item_id +'/edit-ajax', function (data) {
                    $('#produce-item-modal-title').html("Edit Produce Item");
                    $('#produce-item-modal-save').val("edit-produce-item");

                    $('#produce-item-id').val(data.id);
                    $('#produce-item-produce-id').val(data.produce_id).trigger('change');
                    $('#produce-item-produce-unit-id').val(data.produce_unit_id).trigger('change');
                    $('#produce-item-price-per-unit').val(data.price_per_unit);
                    $('#produce-item-quality').val(data.quality);
                    $('#produce-item-tonnage').val(data.tonnage);

                    $('#trader-produce-items-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#produce-item-modal-save').html('Save');
                })
            });

            // on click delete-produce-item
            $('body').on('click', '#delete-produce-item', function (e) {
                e.preventDefault();

                var produce_item_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/produce-items/' + produce_item_id + '/delete-ajax',
                        success: function (data) {
                            $("#produce_item_id_" + produce_item_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // save produce-item (after create or edit)
            if ($("#produce-item-form").length > 0) {
                $("#produce-item-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#produce-item-form').serialize();
                        var actionType = $('#produce-item-modal-save').val();
                        $('#produce-item-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/produce-items/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                var produce_item = '<tr id="produce_item_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.produce.name + '</a></td>';
                                    produce_item += '<td>' + data.produce_unit.name + '</td><td>' + data.price_per_unit + '</td><td>' + data.quality + '</td><td>' + data.tonnage + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    produce_item += '<a id="edit-produce-item" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    produce_item += '<button id="delete-produce-item" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                if (actionType == "create-produce-item") {
                                    console.log(produce_item);
                                    $('#produce-item-list').prepend(produce_item);
                                } else {
                                    $("#produce_item_id_" + data.id).replaceWith(produce_item);
                                }

                                $('#produce-item-modal-save').html('Save');
                                $('#trader-produce-items-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#produce-item-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    
    <script>
        $(document).ready(function () {
            //initialize datatable
            $('#trader-contracts-list').DataTable();

            // on modal-shown
            $('#trader-contracts-crud-modal').on('shown.bs.modal', function() {
                $('#trader-contract-produce-id').select2({
                    dropdownParent: $('#trader-contracts-crud-modal')
                });

                $('#trader-contract-name').trigger('focus');
            });

            // on click create-contract
            $('body').on('click', '#create-trader-contract', function(e) {
                e.preventDefault();

                $('#trader-contract-modal-title').html("Add Contract");
                $('#trader-contract-modal-save').val("create-trader-contract");

                $('#trader-contract-form').trigger("reset");
                $('#trader-contract-id').val('');
                $('#trader-contract-name').val('');
                $('#trader-contract-produce-id').val('').trigger('change');
                $('#trader-contract-produce-unit-id').val('').trigger('change');
                $('#trader-contract-price-per-unit').val('');
                $('#trader-contract-tonnage').val('');

                $('#trader-contracts-crud-modal').modal('show');
            });

            // on click edit-contract
            $('body').on('click', '#edit-trader-contract', function (e) {
                e.preventDefault();

                var trader_contract_id = $(this).data('id');

                $.get('/trader-contracts/' + trader_contract_id +'/edit-ajax', function (data) {
                    $('#trader-contract-modal-title').html("Edit Contract");
                    $('#trader-contract-modal-save').val("edit-trader-contract");

                    $('#trader-contract-id').val(data.id);
                    $('#trader-contract-old-file').val(data.contract_file);
                    $('#trader-contract-name').val(data.name);
                    $('#trader-contract-produce-id').val(data.produce_id).trigger('change');
                    $('#trader-contract-produce-unit-id').val(data.produce_unit_id).trigger('change');
                    $('#trader-contract-price-per-unit').val(formatMoney(data.price_per_unit));
                    $('#trader-contract-tonnage').val(data.tonnage);

                    $('#trader-contracts-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#trader-contract-modal-save').html('Save');
                })
            });

            // on click delete-contract
            $('body').on('click', '#delete-trader-contract', function (e) {
                e.preventDefault();

                var trader_contract_id = $(this).data("id");
                var confirmDelete = confirm("Are You sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-contracts/' + trader_contract_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_contract_id_" + trader_contract_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // save contract (after create or edit)
            $("#trader-contract-form").on('submit', (function(e) {
                e.preventDefault();

                $(this).validate({
                    submitHandler: function(form) {
                        let myForm = $("#trader-contract-form")[0];
                        let formData = new FormData(myForm);

                        let actionType = $('#trader-contract-modal-save').val();
                        $('#trader-contract-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-contracts/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            contentType: false,
                            cache: false,
                            processData: false,
                            success: function (data) {
                                let site_path = $('meta[name="base_url"]').attr('content');

                                let trader_contract = '<tr id="trader_contract_id_' + data.id + '"><td class="details-control" data-id="'+ data.id +'"></td>'
                                    trader_contract += '<td><a href="'+ data.url +'">' + data.name + '</a>'
                                    trader_contract += '<br><small><i class="far fa-file-pdf"></i> Contract Document [<a href="'+ site_path +'/public/trader-contracts/'+ data.contract_file +'" target="_blank">Download</a>]</small>';
                                    trader_contract += '<br><small>Produce: '+ data.produce.name +'</small>';
                                    trader_contract += '<br><small>Unit: '+ data.produce_unit.name +'</small></td>';
                                    trader_contract += '<td>' + data.price_per_unit + '</td><td>' + data.tonnage + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    trader_contract += '<a id="edit-trader-contract" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    trader_contract += '<button id="delete-trader-contract" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                if (actionType == "create-trader-contract") {
                                    $('#trader-contract-list').prepend(trader_contract);
                                } else {
                                    $("#trader_contract_id_" + data.id).replaceWith(trader_contract);
                                }

                                $('#trader-contract-modal-save').html('Save');
                                $('#trader-contracts-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#trader-contract-modal-save').html('Save');
                            }
                        });
                    }
                });
            }));
        });
    </script>

    
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // initialize datatable
            $('#input-items-list').DataTable();

            // on modal-shown
            $('#trader-input-items-crud-modal').on('shown.bs.modal', function() {
                $('#input-item-name').trigger('focus');

                $('#input-item-input-id').select2({
                    dropdownParent: $('#trader-input-items-crud-modal')
                });
            });

            // on click create-input-item
            $('#create-input-item').click(function(e) {
                e.preventDefault();

                $('#input-item-modal-save').val("create-input-item");
                $('#input-item-modal-title').html("Add Input Item");
                $('#trader-input-item-form').trigger("reset");

                $('#input-item-id').val('');
                $('#input-item-name').val('');
                $('#input-item-input-id').val('').trigger('change');
                $('#input-item-input-unit-id').val('').trigger('change');
                $('#input-item-price-per-unit').val('');
                $('#input-item-listed').val('').trigger('change');

                $('#trader-input-items-crud-modal').modal('show');
            });

            // on click edit-input-item
            $('body').on('click', '#edit-input-item', function (e) {
                e.preventDefault();

                var input_item_id = $(this).data('id');

                $.get('/input-items/' + input_item_id +'/edit-ajax', function (data) {
                    $('#input-item-modal-title').html("Edit Input Item");
                    $('#input-item-modal-save').val("edit-input-item");

                    $('#input-item-id').val(data.id);
                    $('#input-item-name').val(data.name);
                    $('#input-item-input-id').val(data.input_id).trigger('change');
                    $('#input-item-input-unit-id').val(data.input_unit_id).trigger('change');
                    $('#input-item-price-per-unit').val(data.price_per_unit);
                    $('#input-item-listed').val(data.listed).trigger('change');

                    $('#trader-input-items-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#input-item-modal-save').html('Save');
                })
            });

            // on click delete-input-item
            $('body').on('click', '#delete-input-item', function (e) {
                e.preventDefault();

                var input_item_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/input-items/' + input_item_id + '/delete-ajax',
                        success: function (data) {
                            $("#input_item_id_" + input_item_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // save input-item (after create or edit)
            if ($("#trader-input-item-form").length > 0) {
                $("#trader-input-item-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-input-item-form').serialize();
                        var actionType = $('#input-item-modal-save').val();
                        $('#input-item-modal-save').html('Saving...');
                        console.log(formData);
                        $.ajax({
                            data: formData,
                            url: '/input-items/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                let listed = data.listed == 1 ? '<i class="fa fa-check">' : '';

                                let input_item = '<tr id="input_item_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.name + '</a>';
                                    input_item += '<br><b>Input:</b> '+ data.input.name;
                                    input_item += '<br><b>Unit:</b> '+ data.input_unit.name +'</small></td>';
                                    input_item += '<td>' + data.price_per_unit + '</td><td>' + listed + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    input_item += '<a id="edit-input-item" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    input_item += '<button id="delete-input-item" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                if (actionType == "create-input-item") {
                                    console.log(input_item);
                                    $('#input-item-list').prepend(input_item);
                                } else {
                                    $("#input_item_id_" + data.id).replaceWith(input_item);
                                }

                                $('#input-item-modal-save').html('Save');
                                $('#trader-input-items-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#input-item-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>

    
    <script>
        $(document).ready(function() {
            // initialize datatable
            $('#trader-networks-list').DataTable();

            // on modal-shown
            $('#trader-networks-crud-modal').on('shown.bs.modal', function() {
                $('#trader-network-region-id').select2({
                    dropdownParent: $('#trader-networks-crud-modal')
                });

                $('#trader-network-county-id').select2({
                    dropdownParent: $('#trader-networks-crud-modal')
                });

                $('#trader-network-agrodealer-id').select2({
                    dropdownParent: $('#trader-networks-crud-modal')
                });
            });

            // on select network-type
            $('#trader-network-type').change(function(e) {
                let agrodealer_select = $('#trader-network-agrodealer-id');
                agrodealer_select.empty().append($('<option />').text("- Select -").val('').prop('selected', true));

                var optionSelected = $("option:selected", this);
                var network_type = this.value;

                if(network_type == 'last-mile') {
                    $('#trader-network-region').removeClass('d-block').addClass('d-none');
                    $('#trader-network-county').removeClass('d-none').addClass('d-block');
                } else if(network_type == 'regional') {
                    $('#trader-network-region').removeClass('d-none').addClass('d-block');
                    $('#trader-network-county').removeClass('d-block').addClass('d-none');
                }

                $('#trader-network-region-id').val('').trigger('change');
                $('#trader-network-county-id').val('').trigger('change');
            });

            $('#trader-network-region-id, #trader-network-county-id').on('select2:select', function (e) {
                var optionSelected = $("option:selected", this);
                var location_id = this.value;

                if (location_id) {
                    let trader_id = $('#trader-network-trader-id').val();
                    let network_type = $('#trader-network-type').val();
                    let agrodealer_select = $('#trader-network-agrodealer-id');
                    agrodealer_select
                        .empty()
                        .append(
                            $('<option />')  // Create new <option> element
                                .text("- Select -") // Set textContent
                                .val('')
                                .prop('selected', true)
                        );

                    $.ajax({
                        url: '/traders/get-agrodealers/' + trader_id,
                        dataType: 'json',
                        type: "GET",
                        data: {
                            'location_id' : location_id,
                            'type': network_type
                        },
                        success: function (data) {
                            console.log(data);

                            $.each(data, function (key, datum) {
                                agrodealer_select
                                    .append($('<option />') // Create new <option> element
                                    .val(datum.id)
                                    .text(datum.organisation_name)
                                );
                            })
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // on click create-network
            $('body').on('click', '#create-trader-network', function(e) {
                e.preventDefault();

                $('#trader-network-modal-title').html("Link Agrodealer");
                $('#trader-network-modal-save').val("create-trader-network");
                $('#trader-network-form').trigger("reset");

                $('#trader-network-id').val('');
                $('#trader-network-type').val('').trigger('change');
                $('#trader-network-region-id').val('').trigger('change');
                $('#trader-network-county-id').val('').trigger('change');
                $('#trader-network-agrodealer-id').val('- Select -').prop('selected', true);
                $('#trader-network-description').val('');

                $('#trader-networks-crud-modal').modal('show');
            });

            // on click edit-network
            $('body').on('click', '#edit-trader-network', function (e) {
                e.preventDefault();

                var trader_network_id = $(this).data('id');

                $.get('/trader-networks/' + trader_network_id +'/edit-ajax', function (data) {
                    $('#trader-network-modal-title').html("Edit Network");
                    $('#trader-network-modal-save').val("edit-trader-network");

                    $('#trader-network-id').val(data.id);
                    $('#trader-network-type').val(data.type).trigger('change');
                    $('#trader-network-region-id').val(data.region_id).trigger('select2:select');
                    $('#trader-network-county-id').val(data.county_id).trigger('select2:select');
                    $('#trader-network-agrodealer-id').val(data.agrodealer_id).trigger('select2:select');
                    $('#trader-network-description').val(data.description);

                    $('#trader-networks-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#trader-network-modal-save').html('Save');
                })
            });

            // on click delete-network
            $('body').on('click', '#delete-trader-network', function (e) {
                e.preventDefault();

                var trader_network_id = $(this).data("id");
                var confirmDelete = confirm("Are You sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/trader-networks/' + trader_network_id + '/delete-ajax',
                        success: function (data) {
                            $("#trader_network_id_" + trader_network_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // save network (after create or edit)
            if ($("#trader-network-form").length > 0) {
                $("#trader-network-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#trader-network-form').serialize();
                        var actionType = $('#trader-network-modal-save').val();
                        $('#trader-network-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/trader-networks/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);
                                let listed = data.listed == 1 ? '<i class="fa fa-check">' : '';

                                let network = '<tr id="trader_network_id_' + data.id + '"><td>' + data.agrodealer.organisation_name;
                                    network += '<small><br><b>Type: </b><span class="text-capitalize">'+ data.type +'</span>';
                                    network += (data.type == 'regional') ? '<br><b>Region:</b> '+ data.region.name : '';
                                    network += (data.type == 'last-mile') ? '<br><b>County:</b> '+ data.county.name : '';
                                    network += '</small></td>';
                                    network += '<td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    network += '<a id="edit-network" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    network += '<button id="delete-network" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                if (actionType == "create-trader-network") {
                                    $('#trader-network-list').prepend(network);
                                } else {
                                    $("#network_id_" + data.id).replaceWith(network);
                                }

                                $('#trader-network-modal-save').html('Save');
                                $('#trader-networks-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#trader-network-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/traders/profile.blade.php ENDPATH**/ ?>