<?php $__env->startSection('title'); ?>
    Twalisha Trading | Input Orders
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Input Orders</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Input orders</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <?php if($trader->count() > 0): ?>
        <form id="input-form" name="form" method="post" action="<?php echo e(route('input_orders.store')); ?>">
                    <?php echo csrf_field(); ?>
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="approved" value="0">
                        <input type="hidden" name="total" value="0">
                        <input type="hidden" name="trader_id" value="<?php echo e($trader[0]); ?>">
        <button type="submit" class="btn btn-primary btn-round btn-sm">
            <span class="btn-label"><i class="fa fa-plus"></i></span> Add Input Order
            </button>
        </form>
        <?php elseif($trader->count() == 0): ?>
        <a href="#" class="btn btn-primary btn-round btn-sm" data-toggle="modal" data-target="#modal-default">
            <span class="btn-label"><i class="fa fa-plus"></i></span> Add Input Orders
        </a>

        <?php endif; ?>
        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>
<!DOCTYPE html>
<html lang="en">
<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($inputs->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer Organization </th>
                                        <th>Total items</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $inputs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $input): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($input->id); ?>">
                                            <td><a href="<?php echo e(route('input_orders.show', $input->id)); ?>"><?php echo e($input->id); ?></a></td>
                                            <td><?php echo e($input->inputOrder->organisation_name); ?></td>
                                            <td><?php echo e($input->orderItems->count('quantity')); ?> </td>

                                            <td>
                                            <?php if($input->approved == 0): ?>
                                            <l>Pending</l>
                                            <?php elseif($input->approved == 1): ?>
                                             <l>In process</l>
                                             <?php elseif($input->approved == 2): ?>
                                             <l>Done</l>
                                             <?php endif; ?>
                                            </td>
                                            <td><?php echo e(Str::limit($input->created_at,10,'.')); ?></td>
                                            <td class="text-right">
                                            <form action="<?php echo e(route('input_orders.update', $input->id)); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                <input type="hidden" name="id" value="<?php echo e($input->id); ?>">
                                                <input type="hidden" name="approved" value="1">
                                                <a href="<?php echo e(route('input_orders.show', $input->id)); ?>" class="btn btn-success btn-sm" data-toggle="tooltip" title="View" data-original-title="View">
                                                        <i class="fa fa-edit"></i> View Items
                                                    
                                                    </a>
                                                    <?php if($input->approved == 0): ?><button type="submit" name="approveorder" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Approve" data-original-title="Approve" data-id="">
                                                        <i class="fa fa-edit"></i> Approve
                                                    </button>
                                                
                                                </form>
                                                <form action="<?php echo e(route('input_orders.destroy', $input->id)); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                    <button id="delete-input" name="deleteorder" onsubmit="return confirm('Delete order?')" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="">
                                                        <i class="far fa-trash-alt"></i> Cancel
                                                    </button>
                                                </form>
                                                <?php else: ?><button type="button" class="btn btn-info btn-sm" title="Deliver" data-original-title="Deliver" data-id=""data-toggle="modal" data-target="#modal-default-<?php echo e($input->id); ?>">
                                                        <i class="fa fa-edit"></i> Deliver
                                                    </button>
                                            <?php endif; ?>
                                    </tr>
                                     <!--Modal Deliver-->
                                        <div class="modal fade" id="modal-default-<?php echo e($input->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Add Transport Information | Order Ref#<?php echo e($input->id); ?> </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form id="input-form" name="input-form" method="post" action="<?php echo e(route('produce-orders.store')); ?>">
                                                        <?php echo csrf_field(); ?>

                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                                                            <input type="hidden" name="approved" value="1">
                                                            <input type="hidden" name="trader_id" value="<?php echo e($input->trader_id); ?>">
                                                            <input type="hidden" name="total" value="<?php echo e($input->price); ?>">
                                                            <div class="form-group align-left">
                                                                <label for="trader-id">Transporter</label>
                                                                <input class="form-control" name="recipient" type="text">
                                                                
                                                                <label for="trader-id">Means of Delivery</label>
                                                                <input type="text" name="means" value="" class="form-control">
                                                                <label for="trader-id">Expected Date of Arrival</label>
                                                                <input type="date" name="date" class="form-control">
                                                                <input type="hidden" name="order_id" value="<?php echo e($input->id); ?>">
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" name="transport" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    <!--/end modal deliver-->
                                    
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer Organization</th>
                                        <th>Total items</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                 </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>


        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="modal-default" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title">Add Input Order</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="input-form" name="input-form" method="post" action="<?php echo e(route('input_orders.store')); ?>">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="approved" value="0">
                        <input type="hidden" name="total" value="0">
                        <div class="form-group">
                            <label for="trader-id">Farmer Organization</label>
                            <select id="input-category-id" name="trader_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select Organization -</option>
                                <?php $__currentLoopData = $inpu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inpu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($inpu->id); ?>"><?php echo e($inpu->organisation_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="modal-default1" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title">Raise Invoice</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="input-form" name="input-form" method="post" action="<?php echo e(route('input_orders.store')); ?>">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="approved" value="0">
                        <input type="hidden" name="total" value="0">
                        <div class="form-group">
                            <label for="trader-id">Order ID</label>
                            <select id="input-category-id" name="order_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select Order -</option>
                                <?php $__currentLoopData = $order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($order->id); ?>"><?php echo e($order->id); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <label>Invoice Number</label>
                            <input type="text" class="form-control" value="" name="number">
                            <label>Amount</label>
                            <input type="text" class="form-control" value="" name="total">
                            <input type="hidden" value="0" name="status">
                            <input type="hidden" value="out" name="direction">
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" name="invoice" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                // "pageLength": 5,
            });
        });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make( (Auth::user()->isAdmin()) ? 'layouts.admin' : 'layouts.fo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/input_orders/index.blade.php ENDPATH**/ ?>