<?php $__env->startSection('title'); ?>
    Twalisha Trading | Invoices to pay Twalisha
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Invoices</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Invoices</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($invoices->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >
                                
                                <thead>
                                    <tr>
                                        <th>S/No.</th>
                                        <th>Invoice No.</th>
                                        <th>Amount</th>
                                        <th>Posted By</th>
                                        <th>Direction</th>
                                        <th>Status</th>
                                        <th>Date Created</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($invoice->id); ?>">
                                            <td><a href="#"><?php echo e($invoice->id); ?></a></td>
                                            <td><?php echo e($invoice->number); ?></td>
                                            <td><?php echo e($invoice->total); ?></td>
                                            <td><?php echo e($invoice->posted_by); ?></td>
                                            <td><?php echo e($invoice->direction); ?></td>
                                            <td>
                                            <?php if($invoice->status == 0): ?>
                                            <l>Pending</l>
                                            <?php elseif($invoice->status == 1): ?>
                                             <l>Paid</l>
                                             <?php endif; ?>
                                            </td>
                                            <td><?php echo e($invoice->created_at); ?></td>
                                            <td class="text-right">
                                               <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                   <a href="<?php echo e(route('invoices.show', $invoice->id)); ?>">
                                                    <button type="submit" class="btn btn-success btn-sm" data-toggle="tooltip" title="View" data-original-title="View">
                                                        <i class="fa fa-edit"></i> View
                                                    </button>
                                                    </a>
                                                    <form action="<?php echo e(route('invoices.destroy', $invoice->id)); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete">
                                                        <i class="fa fa-trash-alt"></i> Delete
                                                    </button>
                                                    </form>
                                                    </div>
                                                    
                                    </tr>
                                       
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer Organization</th>
                                        <th>Totals</th>
                                        <th>Status</th>
                                        <th>Date Created</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>


        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/invoices/index.blade.php ENDPATH**/ ?>