<?php $__env->startSection('title'); ?>
BTCotton | Invoices to pay Twalisha
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title"> Invoices</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Invoices</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($invoices->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>S/No.</th>
                                        <th>Invoice No.</th>
                                        <th>Amount</th>
                                        <th>Balance</th>
                                        <th>Input Item(s)</th>
                                        <th>Status</th>
                                        <th>Date Created</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($invoice->id); ?>">
                                            <td><a href="#"><?php echo e($invoice->id); ?></a></td>
                                            <td><?php echo e($invoice->number); ?></td>
                                            <td><?php echo e(Str::limit($invoice->total,-2,'.')); ?></td>
                                            <td><?php echo e(Str::limit($invoice->balance,-2,'.')); ?></td>
                                            <?php if($invoice->invoice->input!=null): ?>
                                            <td><?php echo e($invoice->invoice->input['name']); ?></td>
                                            <?php elseif($invoice->invoice->input==null): ?>
                                            <td>no item</td>
                                            <?php endif; ?>
                                            <td>
                                                <?php if($invoice->status == 0): ?>
                                                    <span class="badge badge-danger">Pending</span>
                                                <?php elseif($invoice->status == 1): ?>
                                                    <span class="badge badge-warning">Paid</span>
                                                <?php elseif($invoice->status == 2): ?>
                                                    <span class="badge badge-success">Confirmed</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e(Str::limit($invoice->created_at,10,'.')); ?></td>
                                            <td class="text-right">
                                               <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                   <a href="<?php echo e(route('seller-invoices.show', $invoice->id)); ?>">
                                                    <button type="submit" class="btn btn-success btn-sm" data-toggle="tooltip" title="View" data-original-title="View">
                                                        <i class="fa fa-edit"></i> View
                                                    </button>
                                                    </a>
                                            <?php if($invoice->status == 1): ?>
                                                <form action="<?php echo e(route('seller-invoices.store')); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="id" value="<?php echo e($invoice->id); ?>">
                                                <button type="submit" name="confirm" class="btn btn-sm btn-primary">
                                                <i class="fa fa-check"></i> Confirm</button>
                                                </form>
                                             <?php endif; ?>
                                            </div>

                                    </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                    <th>S/No.</th>
                                        <th>Invoice No.</th>
                                        <th>Amount</th>
                                        <th>Balance</th>
                                        <th>Input Item(s)</th>
                                        <th>Status</th>
                                        <th>Date Created</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>


        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/seller-invoices/index.blade.php ENDPATH**/ ?>