<?php echo csrf_field(); ?>
<div class="form-group">
    <label for="produce-item-name">Name</label>
    <input type="text" name="name" id="produce-item-name" value="<?php echo e(old('name', $produceitem->name ?? '')); ?>" class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" placeholder="Name">

    <?php if($errors->has('name')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('name')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<?php if(! isset($item)): ?>
    <div class="form-group">
        <label for="item-trader">Organisation</label>
        <select id="item-trader" name="trader_id" style="width: 100%; border-color: #ebedf2;" class="form-control">
            <option value="">--Select--</option>
            <?php $__currentLoopData = $traders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($trader->id); ?>"><?php echo e(sprintf('%s', $trader->organisation_name)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <?php if($errors->has('trader_id')): ?>
            <div class="invalid-feedback">
                <strong><?php echo e($errors->first('trader_id')); ?></strong>
            </div>
        <?php endif; ?>
    </div>
    <div class="form-group">
        <label for="item-product">Product</label>
        <select id="item-product" name="product_id" style="width: 100%; border-color: #ebedf2;" class="form-control">
            <option value="">--Select--</option>
            <?php $__currentLoopData = $produces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($product->id); ?>"><?php echo e(sprintf('%s', $product->name)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <?php if($errors->has('product_id')): ?>
            <div class="invalid-feedback">
                <strong><?php echo e($errors->first('product_id')); ?></strong>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
<div class="form-group">
    <label for="item-unit">Unit</label>
    <select name="unit" id="item-unit" class="form-control">
        <option value="">--Select--</option>
        <?php $__currentLoopData = $produceunits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($unit->id); ?> <?php echo e(old('unit', $item->unit ?? '') == $unit->id ? 'selected="selected"' : ''); ?>"><?php echo e($unit->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>

    <?php if($errors->has('unit')): ?>
    <div class="invalid-feedback">
        <strong><?php echo e($errors->first('unit')); ?></strong>
    </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg"><?php echo e($buttonText); ?></button>
</div>
<?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/produce-items/_form.blade.php ENDPATH**/ ?>