<?php $__env->startSection('title'); ?>
    Twalisha Trading | Produce Collection
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Produce Collection</h4>
        

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <span>Produce Collection</span>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Collect</a>
            </li>
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="<?php echo e(route('produce-collections.index')); ?>" class="btn btn-primary btn-round btn-sm">
            <i class="fas fa-layer-group"></i> All Collections
        </a>
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($produce_items->count()): ?>
                        <div class="table-responsive">
                            <table id="produce-items-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Collect From</th>
                                        <th>Buyer & Produce</th>
                                        <th>Balance (Kgs)</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Collect From</th>
                                        <th>Buyer & Produce</th>
                                        <th>Balance (Kgs)</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="collection-list">
                                    <?php $__currentLoopData = $produce_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            foreach($produce_item->contract_details as $contract_detail) {
                                                $pending_collections = $contract_detail->collections->where('status', 0)->sum('quantity');
                                                $available_balance = $produce_item->balance - $pending_collections;
                                                $buyer = $contract_detail->contract->trader->organisation_name;
                                                $buyer_price = $contract_detail->contract->price_per_unit;
                                            }
                                        ?>

                                        <tr id="produce_item_id_<?php echo e($produce_item->id); ?>">
                                            <td><h5><?php echo e($produce_item->trader->organisation_name); ?></h5></td>
                                            <td>
                                                <h5><?php echo e($buyer); ?></h5>
                                                <b>Produce:</b> <?php echo e($produce_item->produce->name); ?>

                                                <br><b>Quality:</b> <?php echo e($produce_item->quality); ?>

                                                <br><b>Price:</b> KSh <?php echo e(number_format($buyer_price, 2)); ?>

                                            </td>
                                            <td>
                                                <h5><?php echo e(number_format($available_balance)); ?></h5>
                                                <b>Pending Collections:</b> <span class="text-danger"><?php echo e(number_format($pending_collections)); ?></span>
                                                <br><b>Total:</b> <?php echo e(number_format($produce_item->balance)); ?>

                                            </td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <?php if($available_balance > 0): ?>
                                                        <a id="add-collection" href="#" class="btn btn-success btn-sm" data-toggle="tooltip" title="Collect" data-original-title="Collect" data-id="<?php echo e($produce_item->id); ?>">
                                                            <i class="fas fa-layer-group"></i> Collect Produce
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-collection-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="collection-form" name="collection-form" method="post">
                    <div class="modal-body">
                        <div class="alert alert-info">
                            <dl class="row">
                                <dt class="col-md-5">Farmer Organisation</dt>
                                <dd class="col-md-7" id="produce-item-farmer-organisation"></dd>
                                <dt class="col-md-5">Produce</dt>
                                <dd class="col-md-7" id="produce-item-produce"></dd>
                                <dt class="col-md-5">Pending Collections</dt>
                                <dd class="col-md-7 text-danger text-bold" id="produce-item-pending"></dd>
                                <dt class="col-md-5">Available Balance</dt>
                                <dd class="col-md-7" id="produce-item-balance"></dd>
                            </dl>
                        </div>
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="collected_by" id="collection-produce-item-id" value="<?php echo e(Auth::user()->id); ?>">
                        <div class="form-group">
                            <label for="collection-contract-detail">Contract</label>
                            <select id="collection-contract-detail" name="contract_detail_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="collection-quantity">Quantity <span id="produce-item-produce-unit"></span></label>
                            <input type="number" name="quantity" id="collection-quantity" class="form-control" placeholder="Quantity">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#crud-collection-modal').on('shown.bs.modal', function() {

            });

            $('#produce-items-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // edit
            $('body').on('click', '#add-collection', function (e) {
                e.preventDefault();

                var produce_item_id = $(this).data('id');

                $.get('/produce-collections/' + produce_item_id +'/collect-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Collect Produce");
                    $('#modal-save').val("add-collection");

                    $('#collection-quantity')
                        .val(data.available_balance)
                        .attr('data-max', data.available_balance);
                    $('#collection-contract-detail')
                        .empty()
                        .val('')
                        .trigger('change');
                    $.each(data.contract_details, function (key, datum) {
                        $('#collection-contract-detail')
                            .append($('<option />')  // Create new <option> element
                            .val(datum.id)            // Set value as "Hello"
                            .text(datum.contract.trader.organisation_name +' ('+ datum.contract.name +')') // Set textContent as "Hello"
                            .prop('selected', true)
                        );
                    });

                    $('#produce-item-produce-unit').text('('+ data.produce_unit.abbreviation +')');
                    $('#produce-item-farmer-organisation').text(data.trader.organisation_name);
                    $('#produce-item-produce').html(data.produce.name +'<br><b>Price:</b> '+ data.contract_details[0].contract.price_per_unit +' /'+ data.produce_unit.abbreviation +'<br><b>Quality: </b> '+ data.quality);
                    $('#produce-item-pending').text(data.pending_collections);
                    $('#produce-item-balance').text(data.available_balance);

                    $('#crud-collection-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // submit
            if ($("#collection-form").length > 0) {
                $("#collection-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#collection-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/produce-collections/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);
                                // var produce_item = '<tr id="produce_item_id_' + data.id + '"><td>' + data.trader.organisation_name + '</td>';
                                //     produce_item += '<td>' + data.produce.name + '<br><b>Price:</b> ' + data.price_per_unit + '/ ' + data.produce_unit.abbreviation + '</td><td>' + data.quality + '</td><td>' + data.balance + '</td>';
                                //     produce_item += '<td><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                //     produce_item += '<a id="add-collection" href="#" class="btn btn-success btn-sm" data-toggle="tooltip" title="Collect" data-original-title="Collect" data-id="'+ data.id +'"><i class="fas fa-layer-group"></i> Collect Produce</a>';
                                //     produce_item += '</div></td></tr>';

                                // $("#produce_item_id_" + data.id).replaceWith(produce_item);

                                $('#modal-save').html('Save');
                                $('#crud-collection-modal').modal('hide');
                                if(data.notification) showNotification(data.notification);

                                var redirect_url = "<?php echo e(route('produce-collections.index')); ?>";
                                setTimeout(function(){ $(location).attr('href', redirect_url); }, 2000);
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        })
                        .done(function(response) {
                            if(response.errors) {
                                console.log(response.errors);
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/produce-collections/collect.blade.php ENDPATH**/ ?>