<?php $__env->startSection('title'); ?>
    Twalisha Trading | Produce Varieties
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Produce Varieties</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Produce Varieties</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-produce" href="<?php echo e(route('produces.create')); ?>" class="btn btn-primary btn-round btn-sm">
            <span class="btn-label"><i class="fa fa-plus"></i></span> Add a Produce Variety
        </a>

        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($produces->count()): ?>
                        <div class="table-responsive">
                            <table id="produces-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Category</th>
                                        <th>Description</th>
                                        <th>Listed?</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Category</th>
                                        <th>Description</th>
                                        <th>Listed?</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="produce-list">
                                    <?php $__currentLoopData = $produces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="produce_id_<?php echo e($produce->id); ?>">
                                            <td><a href="<?php echo e($produce->url); ?>"><?php echo e($produce->name); ?></a></td>
                                            <td><?php echo e($produce->category->name); ?></td>
                                            <td><?php echo e(Str::limit($produce->description, '100')); ?></td>
                                            <td><?php echo e(($produce->listed == 1) ? 'Yes' : 'No'); ?></td>
                                            <td class="text-right">
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-produce" href="<?php echo e(route('produces.edit', $produce->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($produce->id); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-produce" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($produce->id); ?>">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</td>
</tr>
    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="produce-form" name="produce-form" method="post">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="produce-id">
                        <div class="form-group">
                            <label for="produce-name">Name</label>
                            <input type="text" name="name" id="produce-name" value="" class="form-control" placeholder="Name" autofocus>
                        </div>
                        <div class="form-group">
                            <label for="produce-category-id">Category</label>
                            <select id="produce-category-id" name="category_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                <?php $__currentLoopData = $produce_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="produce-description">Description</label>
                            <textarea name="description" id="produce-description" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="produce-listed">Listed?</label>
                            <select id="produce-listed" name="listed" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#produces-list').DataTable({
                // "pageLength": 5,
            });

            //onclick add
            $('#create-produce').click(function(e) {
                e.preventDefault();

                $('#modal-save').val("create-produce");
                $('#produce-form').trigger("reset");
                $('#produce-id').val('');
                $('#produce-category-id').val('').trigger('change');
                $('#modal-title').html("Add Produce Variety");
                $('#crud-modal').modal('show');
            });

            // onclick edit
            $('body').on('click', '#edit-produce', function (e) {
                e.preventDefault();

                var produce_id = $(this).data('id');

                $.get('produces/' + produce_id +'/edit-ajax', function (data) {
                    $('#modal-title').html("Edit Produce Variety");
                    $('#modal-save').val("edit-produce");

                    $('#produce-id').val(data.id);
                    $('#produce-name').val(data.name);
                    $('#produce-category-id').val(data.category_id).trigger('change');
                    $('#produce-description').val(data.description);
                    $('#produce-listed').val(data.listed).trigger('change');
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            //onclick delete
            $('body').on('click', '#delete-produce', function (e) {
                e.preventDefault();

                var produce_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: 'produces/' + produce_id + '/delete-ajax',
                        success: function (data) {
                            $("#produce_id_" + produce_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            //onload modal
            $('#crud-modal').on('shown.bs.modal', function() {
                $('#produce-name').trigger('focus');

                $('#produce-category-id').select2({
                    dropdownParent: $('#crud-modal')
                });
            });

            //onsubmit
            if ($("#produce-form").length > 0) {
                $("#produce-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#produce-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/produces/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);

                                var long_description = data.description;
                                if (long_description) var short_description = long_description.substring(0, 100);
                                var listed = data.listed == 1 ? 'Yes' : 'No';

                                var produce = '<tr id="produce_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.name + '</a></td>';
                                    produce += '<td>' + data.category.name + '</td><td>' + short_description + '</td><td>' + listed + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    produce += '<a id="edit-produce" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    produce += '<button id="delete-produce" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     produce
                                    // ]);

                                if (actionType == "create-produce") {
                                    console.log(produce);
                                    $('#produce-list').prepend(produce);
                                } else {
                                    $("#produce_id_" + data.id).replaceWith(produce);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/produces/index.blade.php ENDPATH**/ ?>