<?php
    if(Auth::user()->getRelatedTrader()->isBulkSeller()) {
        $layout = 'layouts.s';
    } elseif(Auth::user()->getRelatedTrader()->isAgroDealer()) {
        $layout = 'layouts.ad';
    }
?>


<?php $__env->startSection('title'); ?>
    Twalisha Trading | Input Order Items
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
    <h4 class="page-title">Input Order Items | Order for <?php echo e($order->inputOrder->organisation_name); ?>  Ref# <?php echo e($order->id); ?></h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Orders</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Order Items</a>
            </li>
            
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">

        <a href="<?php echo e(route('bulk-seller.index')); ?>" class="btn btn-white btn-border btn-round ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <h5 class="text-right"><strong>Input Order ID:</strong> <?php echo e($order->id); ?></h5>

                    <form action="<?php echo e(route('bulk-seller.update', $order->id)); ?>" method="post">
                        <?php echo method_field('PUT'); ?>
                        <input name="category_id" type="hidden" value="<?php echo e($order->id); ?>"/>

                    </form>
                    <?php if($items->count()): ?>
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Input</th>
                                        <th>Quantity</th>
                                        <th>Price[Kes.]</th>
                                        <th>Status</th>
                                        <th>Expected On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="">
                                            <td><a href=""><?php echo e($item->id); ?></a></td>
                                            <td><?php echo e($item->farmer->fullname); ?></td>
                                            <td><?php echo e($item->input->name); ?></td>
                                            <td><?php echo e($item->quantity); ?> <?php echo e($item->input->input_unit->abbreviation); ?></td>
                                            <td><?php echo e($item->price); ?></td>
                                            <td>
                                                <?php if($item->approved == 0): ?>
                                                    <span>Pending</span>
                                                <?php elseif($item->approved == 1): ?>
                                                    <span>In process</span>
                                                <?php elseif($item->approved == 2): ?>
                                                    <span>Completed</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e(Str::limit($item->expected_date,10,'.')); ?></td>
                                            <td class="text-right">
                                                <form name="approveitem" action="<?php echo e(route('bulk-seller.store')); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    
                                                    <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                                    <input type="hidden" name="order_id" value="<?php echo e($order->id); ?>">
                                                    <input type="hidden" name="amount" value="<?php echo e($item->price); ?>">
                                                    <input type="hidden" name="financing" value="<?php echo e($item->financing); ?>">
                                                    <input type="hidden" name="uid" value="<?php echo e($item->farmer->wallet->id); ?>">
                                                    <input type="hidden" name="bal" value="<?php echo e($item->farmer->wallet->balance); ?>">
                                                    <input type="hidden" name="approved" value="2">
                                                    <?php if($item->approved == 2): ?>

                                                    <?php else: ?>
                                                        <button type="submit" name="approveitem" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Complete">
                                                            <i class="fa fa-edit"></i> Complete
                                                        </button>
                                                    <?php endif; ?>
                                                </form>
                                                
                                                <?php if($item->approved == 1): ?>
                                                <?php if(Auth::user()->getRelatedTrader()->isBulkSeller()): ?>
                                                    <button id="forward-input-order-item" type="button" class="btn btn-warning btn-sm" data-toggle="tooltip" title="Forward" data-original-title="Forward" data-id="<?php echo e($item->id); ?>">
                                                        <i class="fas fa-forward"></i> Forward
                                                    </button>
                                                <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                                
                                    </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Input</th>
                                        <th>Quantity</th>
                                        <th>Price[Kes.]</th>
                                        <th>Status</th>
                                        <th>Expected On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="input-order-item-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="input-order-item-modal-title" id="input-order-item-modal-title">Add Network</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="input-order-item-form" name="input-order-item-form" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                    <input type="hidden" name="id" id="input-order-item-id">
                    <input type="hidden" name="forwarded_by" id="input-order-item-forwarded-by" value="<?php echo e($trader->id); ?>">

                    <div class="modal-body">
                        <div class="form-group">
                            <label for="input-order-item-forwarded-to">Forward to...</label>
                            <select id="input-order-item-forwarded-to" name="forwarded_to" style="width: 100%; border-color: #ebedf2;" class="form-control">
                                <option value="">- Select -</option>
                                <?php $__currentLoopData = $trader->networks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader_network): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($trader_network->agrodealer->id); ?>"><?php echo e(sprintf('%s - %s', $trader_network->agrodealer->organisation_name, ucwords($trader_network->type))); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="input-order-item-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        function inputPrice(e) {
            //var x = document.getElementById("inputs").value;
            document.getElementById("price").value = e.target.value;
        }
        function farmerWallet(e) {
            //var x = document.getElementById("inputs").value;
            document.getElementById("amount").value = e.target.value;
        }

        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                // "pageLength": 5,
            });

            // on click forward-input-order-item
            $('body').on('click', '#forward-input-order-item', function (e) {
                e.preventDefault();

                var input_order_item_id = $(this).data('id');

                $.get('/input_orders/forward-input-item/' + input_order_item_id, function (data) {
                    $('#input-order-item-modal-title').html("Forward Order");
                    $('#input-order-item-modal-save').val("forward-input-order-item");

                    $('#input-order-item-id').val(data.id);

                    $('#input-order-item-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#input-order-item-modal-save').html('Save');
                })
            });

            if ($("#input-order-item-form").length > 0) {
                $("#input-order-item-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#input-order-item-form').serialize();
                        var actionType = $('#input-order-item-modal-save').val();
                        $('#input-order-item-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/input_orders/forward-input-item',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);
                                let listed = data.listed == 1 ? '<i class="fa fa-check">' : '';

                                let network = '<tr id="trader_network_id_' + data.id + '"><td>' + data.agrodealer.organisation_name;
                                    network += '<small><br><b>Type: </b><span class="text-capitalize">'+ data.type +'</span>';
                                    network += (data.type == 'regional') ? '<br><b>Region:</b> '+ data.region.name : '';
                                    network += (data.type == 'last-mile') ? '<br><b>County:</b> '+ data.county.name : '';
                                    network += '</small></td>';
                                    network += '<td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    network += '<a id="edit-network" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    network += '<button id="delete-network" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                if (actionType == "create-trader-network") {
                                    $('#trader-network-list').prepend(network);
                                } else {
                                    $("#network_id_" + data.id).replaceWith(network);
                                }

                                $('#input-order-item-modal-save').html('Save');
                                $('#trader-networks-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#input-order-item-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/bulk-seller/details.blade.php ENDPATH**/ ?>