<?php echo csrf_field(); ?>
<div class="form-group">
    <label for="input-name">Name</label>
    <input type="text" name="name" id="input-name" value="<?php echo e(old('name', $input->name ?? '')); ?>" class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" placeholder="Input Name">

    <?php if($errors->has('name')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('name')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <?php $selectedvalue = old('category_id', $input->category_id ?? '') ?>

    <label for="input-category_id">Category</label>
    <select id="input-category_id" name="category_id" style="width: 100%; border-color: #ebedf2;">
            <option value="">--Select--</option>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category->id); ?>" <?php echo e($selectedvalue == $category->id ? 'selected="selected"' : ''); ?>><?php echo e(sprintf('%s', $category->name)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

    <?php if($errors->has('category_id')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('category_id')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <?php $selectedvalue = old('listed', $input->listed ?? '') ?>

    <label for="input-listed">Listed?</label>
    <select name="listed" id="input-listed" class="form-control">
        <option value="">- Select -</option>
        <option value="0" <?php echo e($selectedvalue == 0 ? 'selected="selected"' : ''); ?>>No</option>
        <option value="1" <?php echo e($selectedvalue == 1 ? 'selected="selected"' : ''); ?>>Yes</option>
    </select>

    <?php if($errors->has('listed')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('listed')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <label for="input-description">Description</label>
    <textarea name="description" id="input-description" class="form-control <?php echo e($errors->has('description') ? 'is-invalid' : ''); ?>" rows="10"><?php echo e(old('description', $input->description ?? '')); ?></textarea>

    <?php if($errors->has('description')): ?>
        <div class="invalid-feedback">
            <strong><?php echo e($errors->first('description')); ?></strong>
        </div>
    <?php endif; ?>
</div>
<div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg"><?php echo e($buttonText); ?></button>
</div>
<?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/inputs/_form.blade.php ENDPATH**/ ?>