<?php $__env->startSection('title'); ?>
    Twalisha Trading | Dashboard
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Dashboard</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row mt--2">
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-danger mr-3">
                    <i class="fas fa-users-cog"></i>
                </span>
                <div>
                    
                    <h5 class="mb-1"><b><a href="#"><?php echo e($statistics['users']['count']); ?> Users</a></b></h5>
                    
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-secondary mr-3">
                    <i class="far fa-building"></i>
                </span>
                <div>
                    <h5 class="mb-1"><b><a href="#"><?php echo e($statistics['traders']['count']); ?> Organisations</a></b></h5>
                    
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-success mr-3">
                    <i class="fas fa-layer-group"></i>
                </span>
                <div>
                    <h5 class="mb-1"><b><a href="#"><?php echo e($statistics['produce_orders']['count']); ?> <small>Collections</small></a></b></h5>
                    <small class="text-muted"><?php echo e($statistics['produce_orders']['pending']); ?> pending approval</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-warning mr-3">
                    <i class="fas fa-cart-arrow-down"></i>
                </span>
                <div>
                    <h5 class="mb-1"><b><a href="#"><?php echo e($statistics['input_orders']['count']); ?> <small>Input Orders</small></a></b></h5>
                    <small class="text-muted"><?php echo e($statistics['input_orders']['pending']); ?> pending approval</small>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <div class="card-head-row">
                    <div class="card-title">Organisation Statistics</div>
                    <div class="card-tools">
                        <a href="#" class="btn btn-info btn-border btn-round btn-sm mr-2">
                            <span class="btn-label">
                                <i class="fa fa-pencil"></i>
                            </span>
                            Export
                        </a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <?php echo $trader_chart->container(); ?>

            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card card-primary bg-primary-gradient">
            <div class="card-body">
                <h4 class="mt-3 b-b1 pb-2 mb-4 fw-bold">Quick Stats</h4>
                <h4 class="mt-0 pb-3 mb-0 fw-bold">Organisations</h4>
                <h1 class="mb-4 fw-bold"><?php echo e($statistics['traders']['count']); ?></h1>

                <ul class="list-unstyled">
                    <li class="d-flex justify-content-between pb-1 pt-1"><small>Farmer Organisations</small> <span><?php echo e($counts['fo']); ?></span></li>
                    <li class="d-flex justify-content-between pb-1 pt-1"><small>Bulk Buyers</small> <span><?php echo e($counts['bb']); ?></span></li>
                    <li class="d-flex justify-content-between pb-1 pt-1"><small>Input Sellers</small> <span><?php echo e($counts['bs']); ?></span></li>
                    <li class="d-flex justify-content-between pb-1 pt-1"><small>Agrodealers</small> <span><?php echo e($counts['ad']); ?></span></li>
                    <li class="d-flex justify-content-between pb-1 pt-1"><small>Transporters</small> <span><?php echo e($counts['t']); ?></span></li>
                </ul>
                <hr>
                <div class="chart" style="max-height:150px;">
                    <?php echo $trader_type_chart->container(); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo $trader_chart->script(); ?>

    <?php echo $trader_type_chart->script(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/dashboard.blade.php ENDPATH**/ ?>