<?php $__env->startSection('title'); ?>
    Twalisha Trading | Produce Items
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Produce Items</h4>
        
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Produce Items</a>
            </li>
            
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-produce-item" href="<?php echo e(route('produce-items.create')); ?>" class="btn btn-primary btn-round btn-sm">
            <span class="btn-label"><i class="fa fa-plus"></i></span> Add Produce Items
        </a>

        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-white btn-border btn-round btn-sm ml-1">
            <span class="btn-label"><i class="fas fa-caret-left"></i></span> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php if($produce_items->count()): ?>
                        <div class="table-responsive">
                            <table id="produce-items-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Organisation</th>
                                        <th>Produce</th>
                                        <th>Description/Local Name</th>
                                        <th>Produce Unit</th>
                                        <th>Quality</th>
                                        <th>Price per unit</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Organisation</th>
                                        <th>Produce</th>
                                        <th>Description/Local Name</th>
                                        <th>Produce Unit</th>
                                        <th>Quality</th>
                                        <th>Price per unit</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="produce-item-list">
                                    <?php $__currentLoopData = $produce_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="produce_item_id_<?php echo e($produce_item->id); ?>">
                                            <td><?php echo e($produce_item->trader->organisation_name); ?></td>
                                            <td><?php echo e($produce_item->produce->name); ?></td>
                                            <td><?php echo e($produce_item->produce->description); ?></td>
                                            <td><?php echo e($produce_item->produce_unit->name); ?></td>
                                            <td><?php echo e($produce_item->quality); ?></td>
                                            <td><?php echo e($produce_item->price_per_unit); ?></td>
                                            <td class="text-right">
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-produce-item" href="<?php echo e(route('produce-items.edit', $produce_item->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($produce_item->id); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-produce-item" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($produce_item->id); ?>">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="produce-item-form" name="produce-item-form" method="post">
                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="produce-item-id">

                        <div class="form-group">
                            <label for="produce-item-trader-id">Organisation</label>
                            <select id="produce-item-trader-id" name="trader_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                <?php $__currentLoopData = $traders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($trader->id); ?>"><?php echo e($trader->organisation_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="produce-item-produce-id">Produce</label>
                            <select id="produce-item-produce-id" name="produce_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                <?php $__currentLoopData = $produces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($produce->id); ?>"><?php echo e($produce->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="produce-item-produce-unit-id">Produce Unit</label>
                            <select id="produce-item-produce-unit-id" name="produce_unit_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                <?php $__currentLoopData = $produce_units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($produce_unit->id); ?>"><?php echo e($produce_unit->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="produce-item-name">Quality</label>
                            <input type="text" name="quality" id="produce-item-quality" value="" class="form-control" placeholder="Quality">
                        </div>
                        <div class="row">
                        <div class="form-group col-md-6">
                            <label for="price_per_unit">Price per unit</label>
                            <input type="text" name="price_per_unit" id="produce-item-price-per-unit" value="" class="form-control" placeholder="Price per unit">
                        </div>
                        <div class="form-group col-md-6">
                            <label for="tonnage">Tonnage (in Kgs)</label>
                            <input type="text" name="tonnage" id="produce-item-tonnage" value="" class="form-control" placeholder="Tonnage (in Kgs) per year">
                        </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // onload modal
            $('#crud-modal').on('shown.bs.modal', function() {
                $('#produce-item-name').trigger('focus');

                $('#produce-item-category_id').select2({
                    dropdownParent: $('#crud-modal')
                });
            });

            // datatable
            $('#produce-items-list').DataTable({
                // "pageLength": 5,
            });

            // add
            $('#create-produce-item').click(function(e) {
                e.preventDefault();

                $('#modal-save').val("create-produce-item");
                $('#produce-item-form').trigger("reset");
                $('#produce-item-id').val('');
                $('#produce-item-trader-id').val('').trigger('change');
                $('#produce-item-produce-id').val('').trigger('change');
                $('#produce-item-produce-unit-id').val('').trigger('change');
                $('#produce-item-quality').val('').trigger('change');
                $('#produce-item-tonnage').val('').trigger('change');
                $('#produce-item-price_per_unit').val('').trigger('change');
                $('#modal-title').html("Add Produce Item");
                $('#crud-modal').modal('show');
            });

            // edit
            $('body').on('click', '#edit-produce-item', function (e) {
                e.preventDefault();

                var produce_item_id = $(this).data('id');

                $.get('produce-items/' + produce_item_id +'/edit-ajax', function (data) {
                    $('#modal-title').html("Edit Produce Item");
                    $('#modal-save').val("edit-produce-item");

                    $('#produce-item-id').val(data.id);
                    $('#produce-item-name').val(data.name);
                    $('#produce-item-trader-id').val(data.trader_id).trigger('change');
                    $('#produce-item-produce-id').val(data.produce_id).trigger('change');
                    $('#produce-item-produce-unit-id').val(data.produce_unit_id).trigger('change');
                    $('#produce-item-quality').val(data.quality).trigger('change');
                    $('#produce-item-price-per-unit').val(data.price_per_unit).trigger('change');
                    $('#produce-item-tonnage').val(data.tonnage).trigger('change');
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-produce-item', function (e) {
                e.preventDefault();

                var produce_item_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: 'produce-items/' + produce_item_id + '/delete-ajax',
                        success: function (data) {
                            $("#produce_item_id_" + produce_item_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // submit
            if ($("#produce-item-form").length > 0) {
                $("#produce-item-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#produce-item-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/produce-items/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                var is_listed = data.listed == 1 ? 'Yes' : 'No';

                                var produce_item = '<tr id="produce_item_id_' + data.id + '"><td><a href="'+ data.id +'">' + data.trader.organisation_name + '</a></td>';
                                    produce_item += '<td>'+ data.produce.name +'</td><td>' + data.produce.description + '</td><td>' + data.produce_unit.name + '</td><td>' + data.quality + '</td><td>' + data.price_per_unit + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    produce_item += '<a id="edit-produce-item" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    produce_item += '<button id="delete-produce-item" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     produce
                                    // ]);

                                if (actionType == "create-produce-item") {
                                    console.log(produce_item);
                                    $('#produce-item-list').prepend(produce_item);
                                } else {
                                    $("#produce_item_id_" + data.id).replaceWith(produce_item);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/produce-items/index.blade.php ENDPATH**/ ?>