<?php echo csrf_field(); ?>
<style type="text/css">
    #buyer_type_category{
        display: none;
    }
</style>

<div class="row trader-form">
    <div class="col-md-6">
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-organisation-name">Organisation Name*</label>
                <input type="text" name="organisation_name" id="trader-organisation-name" value="" class="form-control" placeholder="Organisation Name" autofocus>
                <?php if($errors->has('organisation_name')): ?>
                    <div class="invalid-feedback">
                        <strong><?php echo e($errors->first('organisation_name')); ?></strong>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-email">Email*</label>
                <input name="email" id="trader-email" type="email" class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>" placeholder="Email" value="<?php echo e(old('email', $trader->email ?? '')); ?>">

                <?php if($errors->has('email')): ?>
                    <div class="invalid-feedback">
                        <strong><?php echo e($errors->first('email')); ?></strong>
                    </div>
                <?php endif; ?>
            </div>

            <div class="col form-group">
                <label for="trader-phone">Phone Number</label>
                <input name="phone" id="trader-phone" type="text" class="form-control <?php echo e($errors->has('phone') ? 'is-invalid' : ''); ?>" placeholder="Phone Number" value="<?php echo e(old('phone', $trader->phone ?? '')); ?>">

                <?php if($errors->has('phone')): ?>
                    <div class="invalid-feedback">
                        <strong><?php echo e($errors->first('phone')); ?></strong>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-postal_address">Postal Address</label>
                <textarea name="postal_address" id="trader-postal_address" class="form-control <?php echo e($errors->has('postal_address') ? 'is-invalid' : ''); ?>" placeholder="Postal Address"><?php echo e(old('postal_address', $trader->postal_address ?? '')); ?></textarea>
                <?php if($errors->has('postal_address')): ?>
                    <div class="invalid-feedback">
                        <strong><?php echo e($errors->first('postal_address')); ?></strong>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-region">Region*</label><br>
                <select name="region_id" id="trader-region-id" class="form-control">
                    <option value="">- Select -</option>
                        <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($region->id); ?>"><?php echo e($region->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('region_id')): ?>
                    <div class="invalid-feedback">
                        <strong><?php echo e($errors->first('region_id')); ?></strong>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-county">County*</label><br>
                <select name="county_id" id="trader-county-id" class="form-control">
                                            <option value="">- Select -</option>
                                            <?php $__currentLoopData = $counties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $county): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($county->id); ?>"><?php echo e($county->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('county_id')): ?>
                    <div class="invalid-feedback">
                        <strong><?php echo e($errors->first('county_id')); ?></strong>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col form-group">
                <label for="trader-ward">Ward*</label><br>
                <input type="text" name="ward_id" id="trader-ward" class="form-control <?php echo e($errors->has('ward') ? 'is-invalid' : ''); ?>" placeholder="Ward" value="<?php echo e(old('ward', $trader->ward ?? '')); ?>">
                <?php if($errors->has('ward')): ?>
                    <div class="invalid-feedback">
                        <strong><?php echo e($errors->first('ward')); ?></strong>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
    </div>
    <div class="col-md-6">
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-type-id">Organisation Type*</label>            
                <select id="trader-type-id" name="type_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            <?php $__currentLoopData = $trader_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trader_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($trader_type->id); ?>"><?php echo e($trader_type->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('type_id')): ?>
                    <div class="invalid-feedback">
                        <strong><?php echo e($errors->first('type_id')); ?></strong>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="form-row" id="buyer_type_category">
            <div class="col form-group">
                <label for="buyer-type-id">Buyer Type*</label>            
                <select id="buyer-type-id" name="buyer_type" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>                                            
                                                <option value="1">Ginner</option>
                                                <option value="2">Spinner</option>
                                         
                </select>
                <?php if($errors->has('buyer-type-id')): ?>
                    <div class="invalid-feedback">
                        <strong><?php echo e($errors->first('buyer-type-id')); ?></strong>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <fieldset class="farmer-organisation-fields" hidden>

        </fieldset>
        <fieldset class="input-seller-fields" hidden>

        </fieldset>
        <fieldset class="local-aggregator-fields" hidden>

        </fieldset>
        <fieldset class="agrodealer-fields" hidden>

        </fieldset>
    </div>
    <div class="col-md-12">
        <hr>
        <fieldset <?php echo e((request()->is('*edit')) ? 'disabled' : ''); ?>>
            <legend>Other Information</legend>

            <div class="panel panel-default">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-row">
                            <div class="col form-group">
                                <label for="trader-user-firstname">First Name*</label>
                                <input name="user_firstname" id="trader-user-firstname" type="text" class="form-control <?php echo e($errors->has('user_firstname') ? 'is-invalid' : ''); ?>" placeholder="Your First Name" value="<?php echo e(old('user_firstname', $trader->user->firstname ?? '')); ?>">

                                <?php if($errors->has('user_firstname')): ?>
                                    <div class="invalid-feedback">
                                        <strong><?php echo e($errors->first('user_firstname')); ?></strong>
                                    </div>
                                <?php endif; ?>
                            </div> <!-- form-group end.// -->
                            <div class="col form-group">
                                <label for="trader-user-lastname">Last Name*</label>
                                <input name="user_lastname" id="trader-user-lastname" type="text" class="form-control <?php echo e($errors->has('user_lastname') ? 'is-invalid' : ''); ?>" placeholder="Your Last Name" value="<?php echo e(old('user_lastname', $trader->user->lastname ?? '')); ?>">

                                <?php if($errors->has('user_lastname')): ?>
                                    <div class="invalid-feedback">
                                        <strong><?php echo e($errors->first('user_lastname')); ?></strong>
                                    </div>
                                <?php endif; ?>
                            </div> <!-- form-group end.// -->
                        </div>
                        <div class="form-row">
                            <div class="col form-group">
                                <label for="trader-user-email">Email*</label>
                                <input name="user_email" id="trader-user-email" type="text" class="form-control <?php echo e($errors->has('user_email') ? 'is-invalid' : ''); ?>" placeholder="Your Email" value="<?php echo e(old('user_email', $trader->user->email ?? '')); ?>">

                                <?php if($errors->has('user_email')): ?>
                                    <div class="invalid-feedback">
                                        <strong><?php echo e($errors->first('user_email')); ?></strong>
                                    </div>
                                <?php endif; ?>
                            </div> <!-- form-group end.// -->

                            <div class="col form-group">
                                <label for="trader-user-phone">Phone Number*</label>
                                <input name="user_phone" id="trader-user-phone" type="text" class="form-control <?php echo e($errors->has('user_phone') ? 'is-invalid' : ''); ?>" placeholder="Your Phone Number" value="<?php echo e(old('user_phone', $trader->user->phone ?? '')); ?>">

                                <?php if($errors->has('user_phone')): ?>
                                    <div class="invalid-feedback">
                                        <strong><?php echo e($errors->first('user_phone')); ?></strong>
                                    </div>
                                <?php endif; ?>
                            </div> <!-- form-group end.// -->
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-row">
                            <div class="col form-group">
                                <label for="trader-user-username">Username*</label>
                                <input name="user_username" id="trader-user-username" type="text" class="form-control <?php echo e($errors->has('user_username') ? 'is-invalid' : ''); ?>" placeholder="Your Username" value="<?php echo e(old('user_username', $trader->user->username ?? '')); ?>">

                                <?php if($errors->has('user_username')): ?>
                                    <div class="invalid-feedback">
                                        <strong><?php echo e($errors->first('user_username')); ?></strong>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col form-group">
                                <label for="trader-user-password">Password*</label>
                                <input name="user_password" id="trader-user-password" type="password" class="form-control <?php echo e($errors->has('user_password') ? 'is-invalid' : ''); ?>" placeholder="Your Password">

                                <?php if($errors->has('user_password')): ?>
                                    <div class="invalid-feedback">
                                        <strong><?php echo e($errors->first('user_password')); ?></strong>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col form-group">
                                <label for="trader-user-password-confirm">Confirm Password*</label>
                                <input name="user_password_confirm" id="trader-user-password-confirm" type="password" class="form-control <?php echo e($errors->has('user_password_confirm') ? 'is-invalid' : ''); ?>"  placeholder="Confirm Password">

                                <?php if($errors->has('user_password_confirm')): ?>
                                    <div class="invalid-feedback">
                                        <strong><?php echo e($errors->first('user_password_confirm')); ?></strong>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </fieldset>
    </div>
</div>
<?php $__env->startSection('scripts'); ?>    
     <script>
       
       $('#trader-type-id').on('change',function(){                       
                       
                          var el = document.getElementById('trader-type-id');
                          
                          var selectedText = el.options[el.selectedIndex].text;
                        
  
                          if(selectedText=="BTCotton Buyer"){
                           
                              $("#buyer_type_category").show();
                          }
                          else if(selectedText!="BTCotton Buyer"){
                              $("#buyer_type_category").hide();                             
                          }
                      
                      });
    </script>


<?php $__env->stopSection(); ?>
<?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/_partials/form_register_noauth.blade.php ENDPATH**/ ?>