<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />

        <title><?php echo $__env->yieldContent('title'); ?></title>

        <link rel="icon" href="<?php echo e(asset('img/icon.ico')); ?>" type="image/x-icon"/>

        <!-- Fonts and icons -->
        <script src="<?php echo e(asset('js/plugin/webfont/webfont.min.js')); ?>"></script>
        <script>
            WebFont.load({
                google: {"families":["Lato:300,400,700,900"]},
                custom: {"families":["Flaticon", "Font Awesome 5 Solid", "Font Awesome 5 Regular", "Font Awesome 5 Brands", "simple-line-icons"], urls: ['<?php echo e(asset('css/fonts.min.css')); ?>']},
                active: function() {
                    sessionStorage.fonts = true;
                }
            });
        </script>

        <!-- CSS Files -->
        <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.10/css/select2.min.css" rel="stylesheet" />
        <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('css/atlantis2.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('css/custom.css')); ?>">

        <!-- CSS Just for demo purpose, don't include it in your project -->
        
    </head>

    <body>
        <div class="wrapper horizontal-layout-3">
            <?php echo $__env->make('_partials.back-header-noauth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            

            <div class="main-panel">
                <div class="bg-primary2 pt-4 pb-5" style="background-image: url('<?php echo e(asset('img/bg-green.png')); ?>'); background-position: center; background-size: cover;">
                    <div class="container text-white py-2">
                        <div class="d-flex align-items-center">
                            <?php echo $__env->yieldContent('header'); ?>
                        </div>
                    </div>
                </div>
                <div class="container mt--5">
                    <div class="page-inner mt--3">
                        <div class="row">
                            <?php echo $__env->yieldContent('content'); ?>
                        </div>
                    </div>
                </div>
            </div>
            <footer class="footer">
                <div class="container">
                    <nav class="pull-left">
                        <ul class="nav">
                            <li class="nav-item">
                                <a class="nav-link" href="http://www.twalisha.com">
                                    Twalisha
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#">
                                    Help
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#">
                                    Licenses
                                </a>
                            </li>
                        </ul>
                    </nav>
                    <div class="copyright ml-auto">
                        &copy; 2019</a>
                    </div>
                </div>
            </footer>

            <?php echo $__env->make('_partials.back-drawer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <?php echo $__env->make('_partials.back-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </body>
</html>
<?php /**PATH /home/mobigrow/public_html/twalisha.com/trading/public/resources/views/layouts/noauth.blade.php ENDPATH**/ ?>