<?php if($trader->isFarmerOrganisation()): ?>
    <div class="panel-body">
        <form id="trader-settings-form" name="trader-settings-form" method="post">
            <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
            <input type="hidden" name="id" id="trader-settings-id" value="<?php echo e(isset($trader->settings->id) ? $trader->settings->id : ''); ?>">
            <input type="hidden" name="trader_id" id="trader-settings-trader-id" value="<?php echo e($trader->id); ?>">

            <div class="form-group">
                <label for="trader-settings-locked">Locked Amount (%)</label>
                <input name="locked" id="trader-settings-locked" type="number" class="form-control" placeholder="Locked Amount" min="1" max="100" value="<?php echo e(isset($trader->settings->locked) ? $trader->settings->locked : 0); ?>" <?php echo e(Auth::user()->isAdmin() ? '' : 'readonly'); ?>>
            </div>
            <div class="form-group">
                <label for="trader-settings-credit-limit">Credit Limit</label>
                <input name="credit_limit" id="trader-settings-credit-limit" type="number" class="form-control" placeholder="Credit Limit" min="1" max="10" value="<?php echo e(isset($trader->settings->credit_limit) ? $trader->settings->credit_limit : 0); ?>" <?php echo e(Auth::user()->isAdmin() ? '' : 'readonly'); ?>>
            </div>
            <?php if(Auth::user()->isAdmin()): ?>
                <div class="form-group">
                    <button type="submit" id="trader-settings-save" class="btn btn-primary btn-round btn-sm"><i class="fas fa-check"></i> Save</button>
                </div>
            <?php endif; ?>
        </form>
    </div>
<?php endif; ?>
<?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/_partials/trader-settings.blade.php ENDPATH**/ ?>