<?php $__env->startSection('title'); ?>
BTCotton | Contract - <?php echo e($trader_contract->name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <div class="page-header">
        <h4 class="page-title">Contract - <?php echo e($trader_contract->produce->name); ?></h4>
        

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(URL::previous()); ?>" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route('traders.index')); ?>">Organisations</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route('traders.show', $trader_contract->trader_id)); ?>"><?php echo e($trader_contract->trader->organisation_name); ?></a>
            </li>

        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="edit-contract" href="<?php echo e(route('trader-contracts.edit', $trader_contract->id)); ?>" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-edit"></i> Edit Contract
        </a>

        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php echo $__env->make('layouts._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <div class="text-right mb-3">
                        <a id="create-contract-detail" href="<?php echo e(route('trader-contracts.create')); ?>" class="btn btn-primary btn-round btn-sm"><i class="fa fa-plus"></i>  Link Farmer Organisation</a>
                    </div>
                    <hr>
                    <div class="alert alert-info shadow-sm">
                        <dl class="row main">
                            <dt class="col-sm-5">Contract Name</dt>
                            <dd class="col-sm-7"><?php echo e($trader_contract->name); ?></dd>
                            <dt class="col-sm-5">Produce</dt>
                            <dd class="col-sm-7"><?php echo e($trader_contract->produce->name); ?></dd>
                            <dt class="col-sm-5 text-truncate">Price per Unit (<?php echo e($trader_contract->produce_unit->abbreviation); ?>)</dt>
                            <dd class="col-sm-7"><?php echo e('KSh ' . number_format($trader_contract->price_per_unit, 2)); ?></dd>
                            <dt class="col-sm-5">Tonnage (<?php echo e($trader_contract->produce_unit->abbreviation); ?>)</dt>
                            <dd class="col-sm-7"><?php echo e(number_format($trader_contract->tonnage)); ?></dd>
                            <dt class="col-sm-5">Percentage Fulfilled (<span class="percentage-label"><?php echo e($trader_contract->fulfilled); ?></span> %)</dt>
                            <dd class="col-sm-7 pt-1">
                                <span class="percentage in-main">
                                    <div class="progress-card fulfilled mb-0">
                                        <div class="progress">
                                            <div class="progress-bar progress-bar-striped bg-warning" role="progressbar" style="width: <?php echo e($trader_contract->fulfilled); ?>%" aria-valuenow="0" aria-valuemin="<?php echo e($trader_contract->fulfilled); ?>" aria-valuemax="100" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo e($trader_contract->fulfilled); ?>%"></div>
                                        </div>
                                    </div>
                                </span>
                            </dd>
                        </dl>
                    </div>
                    <hr>
                    
                    <?php if($contract_details->count()): ?>
                        <div class="table-responsive">
                            <table id="contract-details-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Farmer Organisation</th>
                                        <th>Tonnage (in Kgs)</th>
                                        <th>Available</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Farmer Organisation</th>
                                        <th>Tonnage (in Kgs)</th>
                                        <th>Available</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="contract-detail-list">
                                    <?php $__currentLoopData = $contract_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contract_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="contract_detail_id_<?php echo e($contract_detail->id); ?>">
                                            <td>
                                                <a href="<?php echo e($contract_detail->url); ?>"><?php echo e($contract_detail->produce_item->trader->organisation_name); ?></a>
                                                <small><br><b>Produce:</b> <?php echo e($contract_detail->produce_item->produce->name); ?>

                                                <br><b>Quality:</b> <?php echo e($contract_detail->produce_item->quality); ?>

                                                <br><b>Unit:</b> <?php echo e($contract_detail->produce_item->produce_unit->abbreviation); ?></small>
                                            </td>
                                            <td><?php echo e(number_format($contract_detail->tonnage)); ?></td>
                                            <td><?php echo e(number_format($contract_detail->produce_item->balance)); ?></td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-contract-detail" href="<?php echo e(route('contract-details.edit', $contract_detail->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($contract_detail->id); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-contract-detail" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($contract_detail->id); ?>">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('layouts._nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Contract Details Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="contract-detail-form" name="contract-detail-form" method="post">
                    <div class="modal-body">
                        <div class="alert alert-info shadow-sm bg-info text-white">
                            <dl class="row">
                                <dt class="col-sm-5">Contract Name</dt>
                                <dd class="col-sm-7"><?php echo e($trader_contract->name); ?></dd>
                                <dt class="col-sm-5">Produce</dt>
                                <dd class="col-sm-7"><?php echo e($trader_contract->produce->name); ?></dd>
                                <dt class="col-sm-5 text-truncate">Price per Unit (<?php echo e($trader_contract->produce_unit->abbreviation); ?>)</dt>
                                <dd class="col-sm-7"><?php echo e('KSh ' . number_format($trader_contract->price_per_unit, 2)); ?></dd>
                                <dt class="col-sm-5">Tonnage (<?php echo e($trader_contract->produce_unit->abbreviation); ?>)</dt>
                                <dd class="col-sm-7"><?php echo e(number_format($trader_contract->tonnage)); ?></dd>
                                <dt class="col-sm-5">Percentage Fulfilled</dt>
                                <dd class="col-sm-7 pt-1">
                                    <span class="percentage in-modal">
                                        <div class="progress-card fulfilled mb-0">
                                            <div class="progress">
                                            <div class="progress-bar progress-bar-striped bg-warning" role="progressbar" style="width: <?php echo e($trader_contract->fulfilled); ?>%" aria-valuenow="<?php echo e($trader_contract->fulfilled); ?>" aria-valuemin="<?php echo e($trader_contract->fulfilled); ?>" aria-valuemax="100" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo e($trader_contract->fulfilled); ?>%"></div>
                                            </div>
                                            <span class="percentage-label"></span>
                                        </div>
                                    </span>
                                </dd>
                            </dl>
                        </div>
                        <input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" id="contract-detail-id">
                        <input type="hidden" name="contract_id" id="contract-detail-contract-id" value="<?php echo e($trader_contract->id); ?>">

                        <div class="form-group">
                            <label for="contract-detail-produce-item-id">Farmer Organisation</label>
                           
                            <select id="contract-detail-produce-item-id" name="produce_item_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                            
                                <?php $__currentLoopData = $produce_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($produce_item->id.'/'); ?><?php echo e($produce_item->trader['id']); ?>" data-id="<?php echo e($produce_item->id); ?>"><?php echo e($produce_item->trader['organisation_name'] . ' (Quality: ' . $produce_item->quality . ')'); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="contract-detail-tonnage">Tonnage (in Kgs)</label>
                            <input type="number" name="tonnage" id="contract-detail-tonnage" class="form-control">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#crud-modal').on('shown.bs.modal', function() {
                $('#contract-detail-produce-item-id').trigger('focus');

                $('#contract-detail-produce-item-id').select2({
                    dropdownParent: $('#crud-modal')
                });
            });

            $('#contract-details-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // create
            $('body').on('click', '#create-contract-detail', function(e) {
                e.preventDefault();

                $('#modal-save').val("create-contract-detail");
                $('#contract-detail-form').trigger("reset");
                $('#contract-detail-id').val('');
                $('#contract-detail-produce-item-id').val('').trigger('change');
                $('#contract-detail-tonnage').val('');
                $('#modal-title').html("Add Contract Item");
                $('#crud-modal').modal('show');
            });

            // edit
            $('body').on('click', '#edit-contract-detail', function (e) {
                e.preventDefault();

                var contract_detail_id = $(this).data('id');

                $.get('/contract-details/' + contract_detail_id +'/edit-ajax', function (data) {
                    $('#modal-title').html("Edit Contract Item");
                    $('#modal-save').val("edit-contract-detail");

                    $('#contract-detail-id').val(data.id);
                    $('#contract-detail-contract-id').val(data.contract_id);
                    $('#contract-detail-produce-item-id').val(data.produce_item_id).trigger('change');
                    $('#contract-detail-tonnage').val(data.tonnage);
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            // delete
            $('body').on('click', '#delete-contract-detail', function (e) {
                e.preventDefault();

                var contract_detail_id = $(this).data("id");
                var confirmDelete = confirm("Are you sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: '/contract-details/' + contract_detail_id + '/delete-ajax',
                        success: function (data) {
                            $("#contract_detail_id_" + contract_detail_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // progress
            // $('body').on("select2:select","#contract-detail-produce-item-id", function(e) {
            $('#contract-detail-tonnage').on('input', function() {
                let el_fulfilled_percentage = $('.percentage.in-modal .fulfilled .percentage-label');
                let el_fulfilled_progress_bar = $('.percentage.in-modal  .fulfilled .progress-bar');
                let contract_id = $('#contract-detail-contract-id').val();
                console.log(contract_id);
                if(contract_id) {
                    $.ajax({
                        url: '/trader-contracts/calculate-fulfilment/' + contract_id,
                        dataType: 'json',
                        type: "GET",
                        data: {
                            tonnage: $("#contract-detail-tonnage").val()
                        },
                        success: function (data) {
                            el_fulfilled_progress_bar.css('width', data.fulfilled + '%').attr('aria-valuenow', data.fulfilled).data("original-title", data.fulfilled);
                            el_fulfilled_percentage.text(data.fulfilled + '%');
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            // submit
            if ($("#contract-detail-form").length > 0) {
                $("#contract-detail-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#contract-detail-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/contract-details/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                let el_fulfilled_percentage = $('.main .percentage-label');
                                let el_fulfilled_progress_bar = $('.percentage.in-main  .fulfilled .progress-bar');
                                el_fulfilled_progress_bar.css('width', data.contract.fulfilled + '%').attr('aria-valuenow', data.contract.fulfilled).data("original-title", data.contract.fulfilled);
                                el_fulfilled_percentage.text(data.contract.fulfilled);

                                // var produce = getProduceName(data.produce_item.produce_id);
                                // var produce_unit = getProduceUnitName(data.produce_item.produce_unit_id);
                                // var contract_detail = '<tr id="contract_detail_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.produce_item.name + '</a><br><span><b>Produce: </b> </span><br><span><b>Units: </b> </span></td>';
                                var contract_detail = '<tr id="contract_detail_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.produce_item.trader.organisation_name + '</a>';
                                    contract_detail += '<br><small><b>Produce:</b> ' + data.produce_item.produce.name;
                                    contract_detail += '<br><b>Quality:</b> ' + data.produce_item.quality;
                                    contract_detail += '<br><b>Unit:</b> ' + data.produce_item.produce_unit.abbreviation + '</small></td>';
                                    contract_detail += '<td>' + data.tonnage + '</td><td>' + data.produce_item.balance + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    contract_detail += '<a id="edit-contract-detail" href="'+ data.id +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    contract_detail += '<button id="delete-contract-detail" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     contract-detail
                                    // ]);

                                if (actionType == "create-contract-detail") {
                                    $('#contract-detail-list').prepend(contract_detail);
                                } else {
                                    $("#contract_detail_id_" + data.id).replaceWith(contract_detail);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spinmobisky/public_html/btcotton/resources/views/trader-contracts/show.blade.php ENDPATH**/ ?>