<div class="table-responsive">
    <table id="produce-items-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th>Produce</th>
                <th>Produce Unit</th>
                <th>Price per Unit</th>
                <th>Quality</th>
                <th>Tonnage (in Kgs)</th>
                <?php if(Auth::user()->isAdmin()): ?>
                    <th class="text-right" style="width: 10%">Action</th>
                <?php endif; ?>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>Produce</th>
                <th>Produce Unit</th>
                <th>Price per Unit</th>
                <th>Quality</th>
                <th>Tonnage (in Kgs)</th>
                <?php if(Auth::user()->isAdmin()): ?>
                    <th class="text-right">Action</th>
                <?php endif; ?>
            </tr>
        </tfoot>
        <tbody id="produce-item-list">
            <?php $__currentLoopData = $produce_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produce_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr id="produce_item_id_<?php echo e($produce_item->id); ?>">
                    <td><a href="<?php echo e($produce_item->url); ?>"><?php echo e($produce_item->produce->name); ?></a></td>
                    <td><?php echo e($produce_item->produce_unit->name); ?></td>
                    <td><?php echo e(number_format($produce_item->price_per_unit, 2)); ?></td>
                    <td><?php echo e($produce_item->quality); ?></td>
                    <td><?php echo e(number_format($produce_item->tonnage)); ?></td>
                    <?php if(Auth::user()->isAdmin()): ?>
                        <td class="text-right">
                            <div class="btn-group form-actions" role="group" aria-label="Actions">
                                <a id="edit-produce-item" href="<?php echo e(route('produce-items.edit', $produce_item->id)); ?>" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="<?php echo e($produce_item->id); ?>">
                                    <i class="fa fa-edit"></i> Edit
                                </a>
                                <button id="delete-produce" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="<?php echo e($produce_item->id); ?>">
                                    <i class="far fa-trash-alt"></i> Delete
                                </button>
                            </div>
                        </td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH /home/mobigrow/public_html/twa-orders/resources/views/produce-items/_index.blade.php ENDPATH**/ ?>